<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>证书管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

			// 选择下拉列表
			var $select = $('#showCategoryClass');

			// 遍历所有的 <option> 元素
			$select.find('option').each(function() {
				// 检查 value 是否等于 5 为FCI增发类型，不展示
				if ($(this).val() === '5') {
					// 从下拉列表中移除该 <option>
					$(this).remove();
				}
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctxSchools}/schoolsGroomerQualificationCertificate/">证书列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="groomerQualificationCertificate" action="${ctxSchools}/schoolsGroomerQualificationCertificate/" 
					method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号/姓名：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>赛事编号：</label>
				<form:input path="groomerRegister.showCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>报名序号：</label>
				<form:input path="groomerRegister.registerCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>证书编号：</label>
				<form:input path="certificateCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>活动分类：</label>
				<form:select path="showCategory" id="showCategoryClass" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('groomer_show_category')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>证书级别：</label>
				<form:select path="levelEn" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="C" label="C"/>
					<form:option value="国际宠物美容师" label="国际宠物美容师"/>
					<form:options items="${fns:getDictList('groomer_nurse_level')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			
			<li><label>缴费状态：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询" onclick="return page();" /></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>报名序号</th>
				<th>会员号</th>
				<th>姓名</th>
				<th>美容师类型</th>
				<th>性别</th>
				<th>移动电话</th>
				<th>培训学校</th>
				<th>比赛犬种</th>
				<th>赛事名称</th>
				<th>赛事编号</th>
				<th>证书级别</th>
				<th>成绩</th> 
				<th>笔试成绩</th> 
				<th>缴费状态</th>
				<th>证书号</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach  items="${page.list}" var="groomerQualificationCertificate" varStatus="xh">
			<tr>
				<c:choose>
					<c:when test="${groomerQualificationCertificate.paymentState=='1' }">
					<td style="display:none">
						<input class="certificateiId"  type="text" style="display:none" value="${fns:escapeHtml(groomerQualificationCertificate.id)}"/>
					</td>
					</c:when>
				</c:choose>
				<td>
					${fns:escapeHtml(groomerQualificationCertificate.groomerRegister.registerCode)}
				</td>
				<td>
					${fns:escapeHtml(groomerQualificationCertificate.memberCode)}
				</td>
				<td>
					${fns:escapeHtml(groomerQualificationCertificate.member.name)}
				</td>
				<td>
					${fns:getDictLabels(groomerQualificationCertificate.member.groomerType, 'user_groomer_type', '无')}
				</td>
				<td>
					 ${fns:getDictLabel(groomerQualificationCertificate.member.gender,'user_gender','')}
				</td>
				<td>
					${fns:escapeHtml(groomerQualificationCertificate.member.mobile)}
				</td>
				<td>
					${fn:replace(groomerQualificationCertificate.groomerRegister.schoolNameCn, ",", "  ")}
				</td>
				<td>
					${fn:replace(groomerQualificationCertificate.groomerRegister.showDogBreed, ",", "  ")}
				</td>
				<td>
					${fns:escapeHtml(groomerQualificationCertificate.groomerShow.showName)}
				</td>
				<td>
					${fns:escapeHtml(groomerQualificationCertificate.groomerRegister.showCode)}
				</td>
				<td>
					<c:choose>
						<c:when test="${groomerQualificationCertificate.certificateType=='4'}">
							${fns:getDictLabel(groomerQualificationCertificate.levelEn, 'groomer_nurse_level', '')}
						</c:when>
						<c:otherwise>
							${fns:escapeHtml(groomerQualificationCertificate.levelCn)}
						</c:otherwise>
					</c:choose>
				</td>
				<td>
					${fns:getDictLabel(groomerQualificationCertificate.groomerRegister.grade, 'Grade', '')}
				</td>
				<td>
					${fns:getDictLabel(groomerQualificationCertificate.groomerRegister.gradeWrite, 'grade_write', '')}
				</td>
				<td>
					<c:choose>
						<c:when test="${groomerQualificationCertificate.paymentState=='1' and groomerQualificationCertificate.groomerShow.endTime<deadline}">
							<font color="red">已过期</font>
						</c:when>
						<c:when test="${groomerQualificationCertificate.paymentState=='1'}">
							<a style="color:red;" href="${ctxSchools}/payment/qualificationCertificate?id=${groomerQualificationCertificate.id}">
								${fns:getDictLabel(groomerQualificationCertificate.paymentState,'user_payment_state','')}
							</a>
						</c:when>
						<c:when test="${groomerQualificationCertificate.paymentState=='2'}">
							<font color="green">${fns:getDictLabel(groomerQualificationCertificate.paymentState, 'user_payment_state', '')}</font>
						</c:when>
					</c:choose>
				</td>
				<td>
					${fns:escapeHtml(groomerQualificationCertificate.certificateCode)}
				</td>
				<td>
					<a href="${ctxSchools}/schoolsGroomerQualificationCertificate/view?id=${fns:escapeHtml(groomerQualificationCertificate.id)}">查看</a>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>