<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>美容师结业证书管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					var avatar=$("#avatar").val();
					if(avatar==''){
						$.jBox.alert("请上传证件照","提示");
					}else{
						form.submit();
					}
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
		<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="#">当前位置:美容师结业证书添加</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="groomerDiploma" action="${ctxSchools}/schoolsCourse/diplomaSave" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<form:hidden path="schoolId" value="${schoolId }"/>
		<form:hidden path="schoolNameCn" value="${schoolNameCn }"/>
		<form:hidden path="schoolNameEn" value="${schoolNameEn }"/>
		<sys:message content="${message}"/>
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input path="memberCode" htmlEscape="false" maxlength="64" readonly="true" class="input-xlarge required"/>
				<button class="btn btn-primary" onclick="searchUser();return false;">查询</button>
				<span id="paymentMsg"></span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				<input id="name" type="text" readonly="readonly" >
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员类型：</label>
			<div class="controls">
				<input id="memberType" type="text" readonly="readonly" >
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">美容师类型：</label>
			<div class="controls">
				<input id="groomerType" type="text" readonly="readonly" >
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">身份证号：</label>
			<div class="controls">
				<input id="cardNo" type="text" readonly="readonly" >
			</div>
		</div>		
		<div class="control-group">
			<label class="control-label">联系电话：</label>
			<div class="controls">
				<input id="mobile" type="text" readonly="readonly" >
			</div>
		</div>		
		<div class="control-group" style="width:50%">
			<label class="control-label">证件照：</label> 
			<div class="controls">
			 	<div class="file-portrait">
              		 <img id="avatarPreview" style="max-width:117px;max-height:150px;"  src="${ctxStatic}/images/head.png">
               </div>
                <span><a id="uploadImg" class="btn btn-primary" href="javascript:;" onclick="uploadImg()">重新上传证件照</a></span>
				<input id="avatar" name="avatar"  type="hidden"/>
				<!-- 文件上传成功的回调方法 -->
				<script type="text/javascript">
					function uploadSuccess(file,response){
						$("#avatar").val(response.id);
					}
			        function uploadImg(){
			        	layer.open({
			        		  type: 2,
			        		  title: '证件照上传',
			        		  shadeClose: true,
			        		  shade: 0.8,
			        		  area: ['480px', '340px'],
			        		  content:'${ctxSchools}/file/uploadPage'
			        		}); 
			        }
				</script>
			</div>
		</div>
		
		<div style = "clear:both;"></div>
		
		<div class="control-group">
			<label class="control-label">培训课程：</label>
			<div class="controls">
				<form:select id="groomerCourseId" path="groomerCourseId" class="input-xlarge required" onchange="selectCourse()" >
					<form:option value="" label=""/>
	             	<form:options items="${findList}" itemLabel="courseName" itemValue="id" htmlEscape="false"/>
	   		  </form:select>
			</div>
		</div>
		<script type="text/javascript">
		Date.prototype.format = function(fmt) { 
		     var o = { 
		        "M+" : this.getMonth()+1,                 //月份 
		        "d+" : this.getDate(),                    //日 
		        "h+" : this.getHours(),                   //小时 
		        "m+" : this.getMinutes(),                 //分 
		        "s+" : this.getSeconds(),                 //秒 
		        "q+" : Math.floor((this.getMonth()+3)/3), //季度 
		        "S"  : this.getMilliseconds()             //毫秒 
		    }; 
		    if(/(y+)/.test(fmt)) {
		            fmt=fmt.replace(RegExp.$1, (this.getFullYear()+"").substr(4 - RegExp.$1.length)); 
		    }
		     for(var k in o) {
		        if(new RegExp("("+ k +")").test(fmt)){
		             fmt = fmt.replace(RegExp.$1, (RegExp.$1.length==1) ? (o[k]) : (("00"+ o[k]).substr((""+ o[k]).length)));
		         }
		     }
		    return fmt; 
		}
		//回显所选课程的信息
			function selectCourse(){
				var  groomerCourseId = $("#groomerCourseId").val();
				if(groomerCourseId!=''){
					$.ajax({
						   type:"POST",
			                url: "${ctxSchools}/schoolsCourse/rockMsg",
			                data : {'id':groomerCourseId},
			                dataType: 'json',
			                async: false, 
			                success: function(json){
			                	if(json.rc==true){
			                		$("#startDate").val(new Date(json.startDate).format("yyyy-MM-dd"));
			                		$("#endDate").val(new Date(json.endDate).format("yyyy-MM-dd"));
			                		$("#certificateLevel").val(json.diplomaLevel);
			                		$("#teacher").val(json.teacher);
			                		$("#certificateLevel").trigger("change"); 
			                	}else if(json.rc==false){
			                		$.jBox.alert(json.msg,"提示");
			                	}
			                }
					});
				}
			}
		</script>
		<div class="control-group">
			<label class="control-label">证书级别：</label>
			<div class="controls">
				<form:select path="certificateLevel" class="input-xlarge required" >
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('groomer_level')}"  itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">培训教师：</label>
			<div class="controls">
				<form:input path="teacher" htmlEscape="false" maxlength="64" readonly="true" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">开始时间：</label>
			<div class="controls">
				<input id="startDate" type="text" readonly="readonly" maxlength="20" class="input-medium"
					/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">结束时间：</label>
			<div class="controls">
				<input id="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium "
					
					/>
			</div>
		</div>
		<div style = "clear:both;"></div>
		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
	<script>
	//打开查询用户的弹窗
	function searchUser(){
		top.layer.open({
			type: 2,
			title: ['会员查询', 'font-size:18px;text-align: center;'],
			shadeClose: false,
			shade: [0.8, '#393D49'],
			maxmin: false, //开启最大化最小化按钮
			area: ['700px', '500px'],
			content: "${ctxSchools}/schoolsMember/search"
		});
	}
	
	//查询用户完成的回调方法
	this.searchUserCallback = function (json){
		console.log(json);
		$("#memberCode").val(json.memberCode);
		$("#name").val(json.name);
		$("#cardNo").val(json.cardNo);
		if(json.avatar !=''){
			if(json.avatar.startsWith("http")){
				$('#avatarPreview').attr('src',json.avatar);
			}else{
				$('#avatarPreview').attr('src','${ctxSchools}/file/image/'+json.avatar);
			}
			$("#avatar").val(json.avatar);
		}
		$("#mobile").val(json.mobile);
		if("basic"==json.memberType){
			$("#memberType").val("银卡会员");
		}else if("professional"==json.memberType){
			$("#memberType").val("金卡会员");
		}
		if("reserve"==json.groomerType){
			$("#groomerType").val("预备会员");	 
		}else if("formal"==json.groomerType){
			$("#groomerType").val("正式会员");	 
		}
    	if(json.memberCode!=''){
	    	$.ajax({
	    		 type:"POST",
	             url:"${ctxSchools}/schoolsMember/checkStudent",
	             data : {'memberCode':json.memberCode},
	             dataType: 'json',
	             async: false, 
	             success: function(jsons){
	            	 if(jsons.rc==true){
	            	 	$("#name").val(jsons.name);
		            	 if(jsons.paymentState==2){
            				$("paymentMsg").html("");
            				$("#paymentMsg").html("<font style='color:green;'>有效会员</font>");
            				$("#btnSubmit").show();
		            	 }else{
            				$("#paymentMsg").html("");
            				$("#paymentMsg").html("<font style='color:red;'>无效会员</font>");
            				$("#btnSubmit").hide();
		            	 }
	            	 }
	             }
	    	});
    	}
	}
</script>
</body>
</html>