<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>淘宠宝犬舍管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});

		function setMemberInfo(){
			var memberCode = $("#memberCode").val();
			if(memberCode==''){
				$.jBox.alert("请输入会员号！","提示");
				return;
			}
			$.post('${ctx}/tcb/tcbKennel/setMemberInfo', {
				memberCode: memberCode
			}, function(data) {

				if(data.status=='1'){
					$.jBox.alert(data.msg,"提示");
					$("#memberName").html("");
					$("#memberGender").html("");
					$("#memberCardType").html("");
					$("#memberCardNo").html("");
					$("#memberMobile").html("");
					$("#memberAddress").html("");
					$("#memberMemberType").html("");
					$("#memberMemberEndDate").html("");
					$("#kennelName").html("");
					$("#kennelEndTime").html("");
					return;
				}

				$("#memberName").html(data.memberName);
				$("#memberGender").html(data.memberGender);
				$("#memberCardType").html(data.memberCardType);
				$("#memberCardNo").html(data.memberCardNo);
				$("#memberMobile").html(data.memberMobile);
				$("#memberAddress").html(data.memberAddress);
				$("#memberMemberType").html(data.memberMemberType);
				$("#memberMemberEndDate").html(data.memberMemberEndDate);
				$("#kennelName").html(data.kennelName);
				$("#kennelEndTime").html(data.kennelEndTime);

			});
		}

	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/tcb/tcbKennel/">淘宠宝犬舍列表</a></li>
		<li class="active"><a href="${ctx}/tcb/tcbKennel/form?id=${tcbKennel.id}">淘宠宝犬舍${not empty tcbKennel.id?'修改':'添加'}</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="tcbKennel" action="${ctx}/tcb/tcbKennel/${not empty tcbKennel.id?'edit':'add'}" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<h3>会员基本信息</h3>
		<div class="control-group">
			<label class="control-label">会员编号：</label>
			<div class="controls">
				<c:if test="${empty tcbKennel.id}">
					<form:input id="memberCode" path="memberCode" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
					<input id="btnSeacher" class="btn btn-primary" value="查询" type="button" onclick="setMemberInfo()"/>
				</c:if>
				<c:if test="${not empty tcbKennel.id}">
					${fns:escapeHtml(tcbKennel.memberCode)}
				</c:if>
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">会员姓名：</label>
			<div id="memberName" class="controls">
				${fns:escapeHtml(tcbKennel.member.name)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div id="memberGender" class="controls">
				${fns:getDictLabels(tcbKennel.member.gender, 'user_gender', '')}
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">证件类型：</label>
			<div id="memberCardType" class="controls">
				${fns:escapeHtml(tcbKennel.member.cardType)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证件编号：</label>
			<div id="memberCardNo" class="controls">
				${fns:escapeHtml(tcbKennel.member.cardNo)}
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">手机号码：</label>
			<div id="memberMobile" class="controls">
				${fns:escapeHtml(tcbKennel.member.mobile)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">联系地址：</label>
			<div id="memberAddress" class="controls">
				${fns:escapeHtml(tcbKennel.member.address)}
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">会员类型：</label>
			<div id="memberMemberType" class="controls">
				${fns:getDictLabels(tcbKennel.member.memberType, 'user_member_type', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">截止日期：</label>
			<div id="memberMemberEndDate" class="controls">
				<fmt:formatDate value="${tcbKennel.member.memberEndDate}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">犬舍名称：</label>
			<div id="kennelName" class="controls">
				${fns:escapeHtml(tcbKennel.kennel.name)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">截止日期：</label>
			<div id="kennelEndTime" class="controls">
				<fmt:formatDate value="${tcbKennel.kennel.endTime}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<div style = "clear:both;"/>
		<h3>项目信息</h3>
		<div class="control-group">
			<label class="control-label">项目名称：</label>
			<div class="controls">
				淘宠犬舍
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">开始日期：</label>
			<div class="controls">
				<input name="startDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${tcbKennel.startDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">结束日期：</label>
			<div class="controls">
				<input name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${tcbKennel.endDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">合同编号：</label>
			<div class="controls">
				<c:if test="${empty tcbKennel.id}">
					<form:input id="contractCode" path="contractCode" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
				</c:if>
				<c:if test="${not empty tcbKennel.id}">
					${fns:escapeHtml(tcbKennel.contractCode)}
				</c:if>
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="5" maxlength="1024" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>