<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>优惠劵管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			 $("#btnImport").click(function(){
	                $.jBox(
	    	                $("#importBox").html(), 
	    	                {title:"优惠券导入", buttons:{"关闭":true},bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"}
                    );
	          });

			var importError = "${importError}";
            var reg = new RegExp("##", "g")
            if (importError != null && importError != '' && typeof importError != 'undefined') {
                alert(importError.replace(reg, "\n"));
            }
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		//增加优惠券
		function openLayer2(id){
			top.layer.open({
				type: 2,
				title: ['优惠券发放', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['800px', '800px'],
				content: "${ctx}/coupon/sysCoupon/addSysCouponView",
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					};
				}
			});
		}
	</script>
</head>
<body>

	<div id="importBox" class="hide">
		<div style="color:red;text-align: center;">目前只支持50元代金券导入</div>
		<form id="importForm" action="${ctx}/coupon/sysCoupon/import" method="post" enctype="multipart/form-data"
			  class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>
			<input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　
			
			<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
			<a href="${ctx}/coupon/sysCoupon/import/template">下载模板</a>
		</form>
	</div>
	
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/coupon/sysCoupon/">优惠劵列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="sysCoupon" action="${ctx}/coupon/sysCoupon/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>优惠劵名称：</label>
				<form:input path="couponName" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>说明：</label>
				<form:input path="explains" htmlEscape="false" maxlength="150" class="input-medium"/>
			</li>
			
			<li><label>优惠券类型：</label>
				<form:select path="couponTypeAdmin" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="1" label="代金券"/>
					<form:option value="2" label="抵扣券"/>
					<form:option value="3" label="参展券"/>
					<form:option value="4" label="满减券"/>
				</form:select>
			</li>
			
			<li><label>状态</label>
				<form:select path="state" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="0" label="可用"/>
					<form:option value="2" label="已使用"/>
					<form:option value="1" label="已过期"/>
				</form:select>
			</li>
			
			<li><label>备注信息：</label>
				<form:input path="remarks" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<shiro:hasPermission name="coupon:sysCoupon:add">
				<li class="btns"><input  id="btn111" type="button" class="btn btn-primary" onclick="openLayer2('${fns:escapeHtml(groomerPackage.id)}')" value="发券"/></li>
			</shiro:hasPermission>
			
			<shiro:hasPermission name="coupon:sysCoupon:add">
				<li class="btns"><input id="btnImport" class="btn btn-primary" type="button" value="导入优惠券"/></li>
			</shiro:hasPermission>
			
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员号</th>
				<th>优惠劵名称</th>
				<th>优惠券类型</th>
				<th>面值</th>
				<th>状态</th>
				<th>有效期</th>
				<th>说明</th>
				<th>创建时间</th>
				<th>备注信息</th>
				<shiro:hasPermission name="coupon:sysCoupon:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="sysCoupon">
			<tr>
				<td><a href="${ctx}/coupon/sysCoupon/form?id=${sysCoupon.id}">
					${sysCoupon.memberCode}
				</a></td>
				<td>
					${sysCoupon.couponName}
				</td>
				<td>
					${sysCoupon.couponTypeDesc}
				</td>
				<td>
					${sysCoupon.facePrice}
				</td>
				<td> 
					${sysCoupon.state}
				</td>
				<td>
					<c:if test="${sysCoupon.validDate==null}">永久</c:if>
					<c:if test="${sysCoupon.validDate!=null}">
						<fmt:formatDate value="${sysCoupon.effectiveDate}" pattern="yyyy-MM-dd"/> 至
						<fmt:formatDate value="${sysCoupon.validDate}" pattern="yyyy-MM-dd"/>
					</c:if>
				</td>
				<td>
					${sysCoupon.explains}
				</td>
				<td>
					<fmt:formatDate value="${sysCoupon.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${sysCoupon.remarks}
				</td>
				<shiro:hasPermission name="coupon:sysCoupon:edit"><td>
    				<a href="${ctx}/coupon/sysCoupon/form?id=${sysCoupon.id}">修改</a>
    				
    				<c:if test="${sysCoupon.couponDelFlag}">
    					<a href="${ctx}/coupon/sysCoupon/delete?id=${sysCoupon.id}" onclick="return confirmx('确认要删除该优惠劵吗？', this.href)">删除</a>
    				</c:if>
				
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>