<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展规范管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/show/ckuMatchRule/">犬展规范列表</a></li>
		<shiro:hasPermission name="show:ckuMatchRule:edit"><li><a href="${ctx}/show/ckuMatchRule/form">犬展规范添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="ckuMatchRule" action="${ctx}/show/ckuMatchRule/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>类型：</label>
				<form:select path="type" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('match_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>序号</th>
				<th>名称</th>
				<th>类型</th>
				<shiro:hasPermission name="show:ckuMatchRule:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="ckuMatchRule">
			<tr>
				<td>
						${ckuMatchRule.code}
				</td>
				<td><a href="${ctx}/show/ckuMatchRule/form?id=${ckuMatchRule.id}">
					${ckuMatchRule.ruleName}
				</a></td>
				<td>
						${ckuMatchRule.type}
				</td>
				<shiro:hasPermission name="show:ckuMatchRule:edit"><td>
    				<a href="${ctx}/show/ckuMatchRule/form?id=${ckuMatchRule.id}">修改</a>
					<%--<a href="${ctx}/show/ckuMatchRule/delete?id=${ckuMatchRule.id}" onclick="return confirmx('确认要删除该犬展规范吗？', this.href)">删除</a>--%>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>