<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬舍信息</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body >
	<div style="padding:10px;">
	<form:form id="searchForm" modelAttribute="kennel" action="${ctx}/kennel/kennel/search/page" method="post" class="breadcrumb form-search" >
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label></label>
				<form:input path="keyword" htmlEscape="false" placeholder = "犬舍编号/会员号/犬舍中文名称" class="input-xlarge"  />
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>犬舍编号</th>
				<th>犬舍中文名称</th>
				<th>犬舍英文名称</th>
				<th>主理人</th>
				<th>选择</th>
			</tr>
		</thead>
		<tbody>
		<c:if test="${page.count == 0 }">
		<tr> <td colspan="8">没有找到任何犬舍信息，请输入犬舍编号/会员号/犬舍中文名称进行查询</td></tr></c:if>
		<c:forEach items="${page.list}" var="kennel">
			<tr>
				<td>
					${fns:escapeHtml(kennel.kennelCode)}
				</td>
				<td>
					${fns:escapeHtml(kennel.name)}
				</td>
				<td>
					${fns:escapeHtml(kennel.nameEn)}
				</td>
				<td>
					${fns:escapeHtml(kennel.member.name)}
				</td>
				<td>
    				<a href="#" onclick="select('${kennel.kennelCode}','${kennel.name}','${kennel.nameEn}','${kennel.member.name}','${kennel.province}','${kennel.city}','${kennel.area}' , '${kennel.mainDogBreedFirst}' )">选择</a>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
	</div>
	<script type="text/javascript">
	 function select(kennelCode,name,nameEn,memberName,province,city,area,mainDogBreedFirst){
	     var index = parent.layer.getFrameIndex(window.name); //获取窗口索引
		 var kennel = {
				kennelCode:kennelCode,
				name:name,
				nameEn:nameEn,
				memberName:memberName,
				province:province,
				city:city,
				area:area,
				mainDogBreedFirst:mainDogBreedFirst
		 }
		 if(parent.document.getElementById("mainFrame").contentWindow.searchKennelCallback != undefined){
			 parent.document.getElementById("mainFrame").contentWindow.searchKennelCallback(kennel);
		 }
		 parent.layer.close(index);
	 }
	</script>
</body>
</html>