<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>报名管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
			
			$("#btnExport").click(function(){
				top.$.jBox.confirm("确认要导出赛事数据吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						$("#searchForm").attr("action","${ctx}/handler/handlerRegister/export");
						$("#searchForm").submit();
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").attr("action","${ctx}/handler/handlerRegister/");
			$("#searchForm").submit();
        	return false;
        }
		//打开上传图片的弹窗
		function openLayer(id){
			top.layer.open({
				type: 2,
				title: ['图片审核', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['500px', '500px'],
				content: "${ctx}/handler/handlerRegister/uploadImage?id="+id,
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					};
				}
			});
		}
		//未到场原因
		function showLayer(id){
			var remarks = "";
			parent.layer.prompt({
				title: ['未到场原因', 'font-size:18px;text-align: center;'],
				formType: 2
			}, function(text){
				remarks = text;
				window.location.href="${ctx}/handler/handlerRegister/match?id="+id+"&type=fail&remarks="+remarks;
				parent.layer.closeAll();
			});

		}
		
		//打开上传图片的弹窗
		function openLayer2(id){
			top.layer.open({
				type: 2,
				title: ['图片上传', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['500px', '500px'],
				content: "${ctx}/handler/handlerRegister/toUpImage?id="+id,
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					};
				}
			});
		}
		
		
	</script>
	<!-- 悬浮提示插件
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	 <script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script> -->
</head>
<body>
	<ul class="nav nav-tabs">
		<shiro:hasPermission name="handler:handlerShow:view"><li><a href="${ctx}/handler/handlerShow/">活动管理</a></li></shiro:hasPermission>
		<li class="active"><a href="${ctx}/handler/handlerRegister/">报名管理</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="handlerRegister" action="${ctx}/handler/handlerRegister/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		
		<ul class="ul-form">
			<li><label>流水号/订单号：</label>
				<form:input path="runningNumber" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>报名序号：</label>
				<form:input path="registerCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>赛事编号：</label>
				<form:input path="showCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>姓名/会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>培训学校：</label>
				<form:input path="schoolNameCn" htmlEscape="false" maxlength="120" class="input-medium"/>
			</li>
			<li><label>缴费状态：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>审核状态：</label>
				<form:select path="reviewState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="0" label="未审核"/>
					<form:option value="1" label="通过"/>
					<form:option value="2" label="未通过"/>
					<form:option value="3" label="已注销"/>
				</form:select>
			</li>
			<li><label>参赛级别：</label>
				<form:select path="showLevel" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="A" label="A"/>
					<form:option value="B" label="B"/>
					<form:option value="C" label="C"/>
					<form:option value="MASTER" label="教师级"/>
					<form:option value="none" label="无"/>
					<form:option value="专业选手组" label="专业选手组"/>
					<form:option value="预职业组" label="预职业组"/>
				</form:select>
			</li>
			<li><label>是否参赛：</label>
				<form:select path="showLeave" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="1" label="是"/>
					<form:option value="0" label="否"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询" onclick="return page();"/>
				<shiro:hasPermission name="handler:handlerRegister:edit"><button id="btnExport" type="button" class="btn btn-primary" >导出</button></shiro:hasPermission>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>报名序号</th>
				<th>会员号</th>
				<th>姓名</th>
				<th>性别</th>
				<th>移动电话</th>
				<th>培训学校</th>
				<th>比赛犬种</th>
				<th>赛事编号</th>
				<th>参赛级别</th>
				<th>缴费状态</th>
				<shiro:hasPermission name="handler:handlerRegister:audit"><th>照片</th></shiro:hasPermission>
				<shiro:hasPermission name="handler:handlerRegister:match"><th>是否参赛</th></shiro:hasPermission>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="handlerRegister">
			<tr>
				<td>
					${fns:escapeHtml(handlerRegister.registerCode)}
				</td>
				<td>
					<a href="${ctx}/sys/user/member/toMemberView?memberCode=${handlerRegister.memberCode}">
					${fns:escapeHtml(handlerRegister.memberCode)}
					</a>
				</td>
				<td>
					${fns:escapeHtml(handlerRegister.name)}
				</td>
				<td>
					${fns:getDictLabel(handlerRegister.gender, 'user_gender', '')}
				</td>
				<td>
					${fns:escapeHtml(handlerRegister.mobile)}
				</td>
				<td>
					${fns:unescapeHtml(handlerRegister.schoolNameCn)}
				</td>
				<td>
					${fns:escapeHtml(handlerRegister.desktopReviewerDog)}
					${fns:escapeHtml(handlerRegister.floorReviewerDog)}
					${fns:escapeHtml(handlerRegister.anyBreed)}
					${fns:escapeHtml(handlerRegister.groomerBreed)}
				</td>
				<td>
					${fns:escapeHtml(handlerRegister.showCode)}
				</td>
				<c:if test="${ handlerRegister.handlerShow.showType ne '10' &&  handlerRegister.handlerShow.showType ne '11'}">
					<td>
						${fns:getDictLabel(handlerRegister.showLevel, 'groomer_test_level', handlerRegister.showLevel)}
					</td>
				</c:if>
				<c:if test="${ handlerRegister.handlerShow.showType eq '10' }">
					<td>
						${fns:getDictLabel(handlerRegister.showLevel, 'handler_test_level_examiner', handlerRegister.showLevel)}
					</td>
				</c:if>
				<c:if test="${ handlerRegister.handlerShow.showType eq '11' }">
					<td>
						${fns:getDictLabel(handlerRegister.showLevel, 'groomer_examiner_course_level', handlerRegister.showLevel)}
					</td>
				</c:if>
				<td>
					<c:choose>
						<c:when test="${handlerRegister.paymentState=='1' && handlerRegister.showLevel=='C' && handlerRegister.handlerShow.showType=='0' }">
							<shiro:hasPermission name="finance:deductCost:deductCost">
								<a  style="color:red" onclick="util.pay('${fns:escapeHtml(handlerRegister.id)}','handler_register@C',1,'${fns:escapeHtml(handlerRegister.fee) }','${fns:escapeHtml(handlerRegister.memberCode)}')">
								${fns:getDictLabel(handlerRegister.paymentState, 'user_payment_state', '')}
								</a>
							</shiro:hasPermission>
						</c:when>
						<c:when test="${handlerRegister.paymentState=='1' && handlerRegister.showLevel=='B' && handlerRegister.handlerShow.showType=='0' }">
								<shiro:hasPermission name="finance:deductCost:deductCost">
								<a onclick="util.pay('${fns:escapeHtml(handlerRegister.id)}','handler_register@B',1,'${fns:escapeHtml(handlerRegister.fee) }','${fns:escapeHtml(handlerRegister.memberCode)}')">
								${fns:getDictLabel(handlerRegister.paymentState, 'user_payment_state', '')}
								</a>
								</shiro:hasPermission>
						</c:when>
						<c:when test="${handlerRegister.paymentState=='1' && handlerRegister.showLevel=='A' && handlerRegister.handlerShow.showType=='0' }">
								<shiro:hasPermission name="finance:deductCost:deductCost">
								<a  style="color:red" onclick="util.pay('${fns:escapeHtml(handlerRegister.id)}','handler_register@A',1,'${fns:escapeHtml(handlerRegister.fee) }','${fns:escapeHtml(handlerRegister.memberCode)}')">
								${fns:getDictLabel(handlerRegister.paymentState, 'user_payment_state', '')}
								</a>
								</shiro:hasPermission>
						</c:when>
						<c:when test="${handlerRegister.paymentState=='1' && handlerRegister.showLevel=='MASTER' && handlerRegister.handlerShow.showType=='0' }">
								<shiro:hasPermission name="finance:deductCost:deductCost">
								<a  style="color:red" onclick="util.pay('${fns:escapeHtml(handlerRegister.id)}','handler_register@M',1,'${fns:escapeHtml(handlerRegister.fee) }','${fns:escapeHtml(handlerRegister.memberCode)}')">
								${fns:getDictLabel(handlerRegister.paymentState, 'user_payment_state', '')}
								</a>
								</shiro:hasPermission>
						</c:when>
						<c:when test="${handlerRegister.paymentState=='1' && handlerRegister.handlerShow.showType=='1'}">
								<shiro:hasPermission name="finance:deductCost:deductCost">
								<a style="color:red" onclick="util.pay('${fns:escapeHtml(handlerRegister.id)}','handler_register@show',1,'${fns:escapeHtml(handlerRegister.fee)}','${fns:escapeHtml(handlerRegister.memberCode)}')">
								${fns:getDictLabel(handlerRegister.paymentState, 'user_payment_state', '')}
								</a>
								</shiro:hasPermission>
						</c:when>
						<c:when test="${handlerRegister.paymentState=='1' && handlerRegister.handlerShow.showType=='9'}">
								<shiro:hasPermission name="finance:deductCost:deductCost">
								<a style="color:red" onclick="util.pay('${fns:escapeHtml(handlerRegister.id)}','handler_register@YAZHOU',1,'${fns:escapeHtml(handlerRegister.fee)}','${fns:escapeHtml(handlerRegister.memberCode)}')">
								${fns:getDictLabel(handlerRegister.paymentState, 'user_payment_state', '')}
								</a>
								</shiro:hasPermission>
						</c:when>
						<c:when test="${handlerRegister.paymentState=='1' && handlerRegister.handlerShow.showType=='7'&& handlerRegister.showLevel=='A'}">
								<shiro:hasPermission name="finance:deductCost:deductCost">
								<a style="color:red" onclick="util.pay('${fns:escapeHtml(handlerRegister.id)}','handler_register@DietitianA',1,'${fns:escapeHtml(handlerRegister.fee)}','${fns:escapeHtml(handlerRegister.memberCode)}')">
								${fns:getDictLabel(handlerRegister.paymentState, 'user_payment_state', '')}
								</a>
								</shiro:hasPermission>
						</c:when>
						<c:when test="${handlerRegister.paymentState=='1' && handlerRegister.handlerShow.showType=='7'&& handlerRegister.showLevel=='B'}">
								<shiro:hasPermission name="finance:deductCost:deductCost">
								<a style="color:red" onclick="util.pay('${fns:escapeHtml(handlerRegister.id)}','handler_register@DietitianB',1,'${fns:escapeHtml(handlerRegister.fee)}','${fns:escapeHtml(handlerRegister.memberCode)}')">
								${fns:getDictLabel(handlerRegister.paymentState, 'user_payment_state', '')}
								</a>
								</shiro:hasPermission>
						</c:when>
							<c:when test="${handlerRegister.paymentState=='1' && handlerRegister.handlerShow.showType=='7'&& handlerRegister.showLevel=='C'}">
								<shiro:hasPermission name="finance:deductCost:deductCost">
								<a style="color:red" onclick="util.pay('${fns:escapeHtml(handlerRegister.id)}','handler_register@DietitianC',1,'${fns:escapeHtml(handlerRegister.fee)}','${fns:escapeHtml(handlerRegister.memberCode)}')">
								${fns:getDictLabel(handlerRegister.paymentState, 'user_payment_state', '')}
								</a>
								</shiro:hasPermission>
						</c:when>
						<c:when test="${handlerRegister.paymentState=='1' && handlerRegister.showLevel !='MASTER' && handlerRegister.handlerShow.showType=='12' }">
							<shiro:hasPermission name="finance:deductCost:deductCost">
								<a  style="color:red" onclick="util.pay('${fns:escapeHtml(handlerRegister.id)}','handler_register@PartnerExam',1,'${fns:escapeHtml(handlerRegister.fee)}','${fns:escapeHtml(handlerRegister.memberCode)}')">
										${fns:getDictLabel(handlerRegister.paymentState, 'user_payment_state', '')}
								</a>
							</shiro:hasPermission>
						</c:when>
						<c:when test="${handlerRegister.paymentState=='1' && handlerRegister.showLevel=='MASTER' && handlerRegister.handlerShow.showType=='12' }">
							<shiro:hasPermission name="finance:deductCost:deductCost">
								<a  style="color:red" onclick="util.pay('${fns:escapeHtml(handlerRegister.id)}','handler_register@PartnerExamM',1,'500.00','${fns:escapeHtml(handlerRegister.memberCode)}')">
										${fns:getDictLabel(handlerRegister.paymentState, 'user_payment_state', '')}
								</a>
							</shiro:hasPermission>
						</c:when>
						<c:when test="${handlerRegister.paymentState=='1' && handlerRegister.handlerShow.showType=='13' }">
							<shiro:hasPermission name="finance:deductCost:deductCost">
								<a  style="color:red" onclick="util.pay('${fns:escapeHtml(handlerRegister.id)}','handler_register@PartnerMatch',1,'${fns:escapeHtml(handlerRegister.fee)}','${fns:escapeHtml(handlerRegister.memberCode)}')">
										${fns:getDictLabel(handlerRegister.paymentState, 'user_payment_state', '')}
								</a>
							</shiro:hasPermission>
						</c:when>
						<c:otherwise>
							<font color="green">${fns:getDictLabel(handlerRegister.paymentState, 'user_payment_state', '')}</font>
						</c:otherwise>
					</c:choose>
				</td>
				<shiro:hasPermission name="handler:handlerRegister:audit">
				<td>
					<c:if test="${handlerRegister.handlerShow.showType ne '10'}">
					<c:choose>
						<c:when test="${handlerRegister.businessRefundState}">
							${fns:getDictLabel(handlerRegister.reviewState, 'review_state', '')}
						</c:when>
						<c:when test="${handlerRegister.paymentState=='2' && handlerRegister.reviewState=='0' && empty handlerRegister.avatar }">
							<a href="#" onclick="openLayer2('${fns:escapeHtml(handlerRegister.id)}')">上传</a>
						</c:when>
						<c:when test="${handlerRegister.paymentState=='2' && handlerRegister.reviewState=='0' &&not empty handlerRegister.avatar}">
							<a href="#" onclick="openLayer('${fns:escapeHtml(handlerRegister.id)}')">审核</a>
						</c:when>
						<c:when test="${handlerRegister.reviewState=='1'}">
							<font color="green">${fns:getDictLabel(handlerRegister.reviewState, 'review_state', '')}</font>
						</c:when>
						<c:when test="${handlerRegister.reviewState=='2'}">
							<a style="color:red" title="${fns:escapeHtml(handlerRegister.reviewRemarks)}">
							${fns:getDictLabel(handlerRegister.reviewState, 'review_state', '')}</a>
						</c:when>
						<c:when test="${handlerRegister.reviewState=='3'}">
							<a style="color:red" title="${fns:escapeHtml(handlerRegister.reviewRemarks)}">
									${fns:getDictLabel(handlerRegister.reviewState, 'review_state', '')}</a>
						</c:when>
					</c:choose>
					</c:if>
				</td>
				</shiro:hasPermission>
				
				<shiro:hasPermission name="handler:handlerRegister:match">
				<td title="${handlerRegister.remarks }">
					<c:choose>
						<c:when test="${handlerRegister.showLeave=='0' && handlerRegister.paymentState=='2' && !handlerRegister.businessRefundState}">
							<a  href="${ctx}/handler/handlerRegister/match?id=${fns:escapeHtml(handlerRegister.id)}&type=success">是</a>&nbsp;|&nbsp;
							<a href="#" onclick="showLayer('${fns:escapeHtml(handlerRegister.id)}')">否</a>
						</c:when>
						<c:when test="${handlerRegister.showLeave=='1'}">
							<font color="green">已参赛</font>
						</c:when>
						<c:when test="${handlerRegister.showLeave=='2'}">
							  <font color="red">未参赛</font>
						</c:when>
					</c:choose>
				</td>
				</shiro:hasPermission>
				<td>
					<c:if test="${ handlerRegister.handlerShow.showType ne '10' &&  handlerRegister.handlerShow.showType ne '11'
					&& handlerRegister.handlerShow.showType ne '12' &&  handlerRegister.handlerShow.showType ne '13'}">
					<a href="${ctx}/handler/handlerRegister/view?id=${fns:escapeHtml(handlerRegister.id)}">查看</a>
					<shiro:hasPermission name="handler:handlerRegister:edit">
    				<a href="${ctx}/handler/handlerRegister/form?id=${fns:escapeHtml(handlerRegister.id)}">编辑</a>
	   				</shiro:hasPermission>
	   				</c:if>
	   				<c:if test="${ handlerRegister.handlerShow.showType eq '10' || handlerRegister.handlerShow.showType eq '11'}">
					<a href="${ctx}/handler/handlerRegister/viewExaminer?id=${fns:escapeHtml(handlerRegister.id)}">查看</a>
					<shiro:hasPermission name="handler:handlerRegister:edit">
    				<a href="${ctx}/handler/handlerRegister/formExaminer?id=${fns:escapeHtml(handlerRegister.id)}">编辑</a>
	   				</shiro:hasPermission>
	   				</c:if>
					<c:if test="${ handlerRegister.handlerShow.showType eq '12' || handlerRegister.handlerShow.showType eq '13'}">
						<a href="${ctx}/handler/handlerRegister/viewPartnerDog?id=${fns:escapeHtml(handlerRegister.id)}">查看</a>
						<shiro:hasPermission name="handler:handlerRegister:edit">
							<c:if test="${!handlerRegister.businessRefundState}">
								<a href="${ctx}/handler/handlerRegister/formPartnerDog?id=${fns:escapeHtml(handlerRegister.id)}">编辑</a>
							</c:if>
						</shiro:hasPermission>
					</c:if>
	   				<shiro:hasPermission name="handler:handlerRegister:delete">
	   					<c:if test="${handlerRegister.paymentState=='1' }">
						<a href="${ctx}/handler/handlerRegister/delete?id=${fns:escapeHtml(handlerRegister.id)}" onclick="return confirmx('确认要删除该报名吗？', this.href)">删除</a>
	   					</c:if>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>