<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>血统证书打印</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript" src="${ctxStatic}/modules/common/LodopFuncs.js"></script>
    <object id="LODOP_OB" classid="clsid:2105C259-1E0C-4534-8141-A753534CB4CA" width=0 height=0>
    <embed id="LODOP_EM" type="application/x-print-lodop" width=0 height=0 pluginspage="${ctxStatic}/modules/common/install_lodop.exe"></embed>
    </object>
    <script type="text/javascript">
        var LODOP; 
	    var printLeftString = '${fns:getUser().printLeft}';
	    var printTopString = '${fns:getUser().printTop}';
	    var printLeft = parseInt(printLeftString);
	    var printTop = parseInt(printTopString);
        function myPrintSetup1() {
            CreatePage();
            LODOP.SET_PRINT_PAGESIZE(2,0,0,"A4");
            LODOP.SET_SHOW_MODE("BKIMG_IN_PREVIEW",1);
            LODOP.SET_PRINT_STYLEA(0, "fontsize", 10);
            LODOP.ADD_PRINT_SETUP_BKIMG("<img border='0' src='"+ctxStatic+"/modules/common/print_fy.jpg' width='1080px;' height='765px;'>");
            LODOP.PREVIEW();        
        }
        function CreatePage() {
        	var myDate = new Date();
            var printDate = myDate.getFullYear()+"年"+(myDate.getMonth()+1)+"月"+myDate.getDate()+"日";
            var fmdogBreedCertifiedCode = $("#fmdogBreedCertifiedCode").val();
            var dogId = $("#dogId").val();
            $.ajax({
                type: "POST",
                url:"${ctx}/dogbreed/dogBreedCertified/getPrintMessage?fmdogBreedCertifiedCode="+fmdogBreedCertifiedCode+"&dogId="+dogId,
                dataType:"json",
                async: false,
                error: function(request, textStatus, errorThrown) {
                    alert("系统错误，请联系管理员！");
                },
                success: function(json) {
                	var str = json.dnaResult;
                	strs = str.split(",");
                	var html = "<table width='310' border='1' cellpadding='3' cellspacing='0' style='margin-bottom:5px;font-size:14px;border:solid 1px black;border-collapse:collapse;'>"+
                	"<tr>"+
                    "<td width='25%'>PEZ01</td>"+
                    "<td width='25%'>FHC2045</td>"+
                    "<td width='25%'>FHC2010</td>"+
                    "<td width='25%'>PEZ05</td>"+
                    "</tr>"+
                    "<tr>"+
                    "<td>"+strs[0]+"</td>"+
                    "<td>"+strs[2]+"</td>"+
                    "<td>"+strs[4]+"</td>"+
                    "<td>"+strs[6]+"</td>"+
                    "</tr>"+
                    "<tr>"+
                    "<td>"+strs[1]+"</td>"+
                    "<td>"+strs[3]+"</td>"+
                    "<td>"+strs[5]+"</td>"+
                    "<td>"+strs[7]+"</td>"+
                    "</tr>"+
                    "</table>"+
                    "<table width='310' border='1' cellpadding='3' cellspacing='0' style='font-size:14px;border:solid 1px black;border-collapse:collapse;margin-bottom:5px;'>"+
                    "<tr>"+
                    "<td width='25%'>PEZ20</td>"+
                    "<td width='25%'>PEZ12</td>"+
                    "<td width='25%'>PEZ03</td>"+
                    "<td width='25%'>PEZ06</td>"+
                    "</tr>"+
                    "<tr>"+
                    "<td>"+strs[8]+"</td>"+
                    "<td>"+strs[10]+"</td>"+
                    "<td>"+strs[12]+"</td>"+
                    "<td>"+strs[14]+"</td>"+
                    "</tr>"+
                    "<tr>"+
                    "<td>"+strs[9]+"</td>"+
                    "<td>"+strs[11]+"</td>"+
                    "<td>"+strs[13]+"</td>"+
                    "<td>"+strs[15]+"</td>"+
                    "</tr>"+
                    "</table>"+
                    "<table width='310' border='1' cellpadding='3' cellspacing='0' style='font-size:14px;border:solid 1px black;border-collapse:collapse;margin-bottom:5px;'>"+
                    "<tr>"+
                    "<td width='25%'>PEZ08</td>"+
                    "<td width='25%'>FHC2079</td>"+
                    "<td width='25%'>PEZ16</td>"+
                    "<td width='25%'>&nbsp;</td>"+
                    "</tr>"+
                    "<tr>"+
                    "<td>"+strs[16]+"</td>"+
                    "<td>"+strs[18]+"</td>"+
                    "<td>"+strs[20]+"</td>"+
                    "<td>&nbsp;</td>"+
                    "</tr>"+
                    "<tr>"+
                    "<td>"+strs[17]+"</td>"+
                    "<td>"+strs[19]+"</td>"+
                    "<td>"+strs[21]+"</td>"+
                    "<td>&nbsp;</td>"+
                    "</tr>"+
                    "</table>";
                    $("#div").html(html);
                    LODOP=getLodop(document.getElementById('LODOP_OB'),document.getElementById('LODOP_EM'));  
                    LODOP.PRINT_INIT("犬只配种证明证书打印");
                    //设置默认字体样式：微软雅黑 9pt
                    LODOP.SET_PRINT_STYLE("FontName","微软雅黑");
                    LODOP.SET_PRINT_STYLE("FontSize",10);
                    //打印内容
                    LODOP.ADD_PRINT_TEXT(printTop+120,140+printLeft,300,16,$("#nameEn").val());
                    LODOP.ADD_PRINT_TEXT(printTop+175,140+printLeft,300,35,$("#dogType").val().replace('-','\n'));
                    LODOP.ADD_PRINT_TEXT(printTop+175,470+printLeft,300,16,$("#dogBreed").val());
                    LODOP.ADD_PRINT_TEXT(printTop+175,810+printLeft,300,16,$("#birthdate").val());
                    LODOP.ADD_PRINT_TEXT(printTop+220,140+printLeft,300,16,$("#breedDeadline").val());
                    LODOP.ADD_PRINT_TEXT(printTop+255,140+printLeft,300,16,$("#breedCertifiedCode").val());
                    LODOP.ADD_PRINT_TEXT(printTop+340,395+printLeft,300,16,$("#kinBreed").val());
                    LODOP.ADD_PRINT_TEXT(printTop+220,470+printLeft,300,16,json.maleDogName);
                    LODOP.ADD_PRINT_TEXT(printTop+220,810+printLeft,300,16,json.femaleDogName);
                    LODOP.ADD_PRINT_TEXT(printTop+255,470+printLeft,300,16,json.femaleDogOwner);
                    // LODOP.ADD_PRINT_TEXT(printTop+255,810+printLeft,300,16,json.addRess);
                    LODOP.ADD_PRINT_TEXT(printTop+290,140+printLeft,300,16,json.dnaCode);
                    var re = new RegExp(',', "g");
                    var reg = new RegExp('<br>', "g");
                    LODOP.ADD_PRINT_TEXT(printTop+340,730+printLeft,300,300,$("#breedResults").val().replace(re,'').replace(reg,"\n"));
                    LODOP.ADD_PRINT_TEXT(printTop+710,125+printLeft,300,16,printDate);
                    LODOP.ADD_PRINT_HTM(printTop+340,65+printLeft,320,300,document.getElementById("div").innerHTML);
                }
            });
        }
    </script>
    <style>
        *{
		-moz-box-sizing: border-box;
		}
		.title { 
		   font-family : Arial,Vernada,Tahoma, sans-serif;
		   font-size: 30px;
		   color : #00008B;
		   background-color : White; text-decoration:underline
		}
		.normal{
		    font-family : Arial,Vernada, Tahoma, Helvetica, sans-serif;
		    font-size: 12px;
		    color: #444444;
		    text-decoration: none;
		    line-height: 21px;}
		.hide_for_jatools_print{}
		.jc{position:absolute;overflow:hidden; }
		.jnc{position:absolute}
		.pb{overflow:hidden;position:relative;margin:5;width:1120;height:800;background-color:white;border-left:1px solid black;border-top:1px solid black; border-right:4px solid black;border-bottom:4px solid black;}
		.c16{margin-left:2px;margin-bottom:-2px;font-family: Arial;font-size: 16px;}
		.c12{margin-left:2px;margin-bottom:-2px;font-family: Arial;font-size: 14px;}
    </style>
</head>
<body>
    <ul class="nav nav-tabs">
        <li class="active">繁育血统证书打印</li>
    </ul><br/>
    <div style="display:none">
    <form:form modelAttribute="dogBreedCertified"   >
        <input id="dogId" name="dogId" type="text" value="${dogBreedCertified.dog.id }">
        <input id="breedDeadline" name="breedDeadline" type="text" value="${dogBreedCertified.breedDeadline }">
        <input id="nameEn" name="nameEn" type="text" value="${dogBreedCertified.dog.nameEn }">
        <input id="dogBreed" name="dogBreed" type="text" value="${dogBreedCertified.dog.dogBreed }">
        <input id="breedCertifiedCode" name="breedCertifiedCode" type="text" value="${dogBreedCertified.breedCertifiedCode }">
        <input id="kinBreed" name="kinBreed" type="text" value="${dogBreedCertified.kinBreed }">
        <input id="breedResults" name="breedResults" type="text" value="${dogBreedCertified.breedResults }">
        <input id="dogType" name="dogType" type="text" value="${dogBreedCertified.dog.dogType }">
        <input id="fmdogBreedCertifiedCode" name="fmdogBreedCertifiedCode" type="text" value="${dogBreedCertified.dog.fmdogBreedCertifiedCode }">
        <input id="birthdate" name="birthdate" type="text" value="<fmt:formatDate value="${dogBreedCertified.dog.birthdate}" pattern="yyyy/MM/dd"/>">
    </form:form>
    </div>
    <input type="button" value="打印正面" onclick="myPrintSetup1()"/>
    <input type="button" value="打印背面" onclick="myPrintSetup2()"/>
    <div id="div" style="display: none"></div>
    <p id="tt01">请使用A3打印机打印！下图为证书样本。</p>
    <p>
    <img src="${ctxStatic}/modules/common/print_fy.jpg" width="1482" height="942" title="证书正面"  style="border:#CCC 1px solid; margin-top:10px;"/></p>
    <div class="form-actions">
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="window.location.replace('${ctx}/dogbreed/dogBreedCertified/list')"/>
    </div>
</body>
</html>