<%@ page contentType="text/html;charset=UTF-8"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
<title>犬只DNA存档补寄采样包</title>
<meta name="decorator" content="default" />
<style type="text/css">
	body {
		margin-top: 20px;
	}
	
	.jbox-body .jbox-icon {
		top: 50px !important;
	}
	
	.div-label {
		height: 26px;
		line-height: 26px;
		word-wrap: break-word;
	}
	
	.div-tag {
		color: #d46b08;
		background: #fff7e6;
		min-width: 200px;
		border: 1px solid #ffd591;
		border-radius: 2px;
		text-align: center;
		height: 26px;
		line-height: 26px;
	}
	
	.text-center {
		text-align: center !important;
	}
	
	.div-remark {
		overflow: hidden;
		white-space: nowrap;
		text-overflow: ellipsis;
		width: 170px;
	}
	
	.accordion-heading, .table th {
		white-space: nowrap;
		background-color: white !important;
		background-image: -webkit-linear-gradient(top, white, white) !important;
		background-repeat: repeat-x;
	}
	
	.accordion-heading, .table tr {
		white-space: nowrap;
		background-color: white !important;
		background-image: -webkit-linear-gradient(top, white, white) !important;
		background-repeat: repeat-x;
	}
	
	.form-horizontal .form-actions {
	   padding-left: 0px!important;
	   text-align: center;
	}
</style>
<style>
   .errorMsg{
       height: 500px;
       color: #333;
       margin: auto;
       padding: 1em;
       display: table;
       user-select: none;
       box-sizing: border-box;
       font: lighter 20px "微软雅黑";
   }
   .errorMsg a{
       color: #1ab394;
       text-decoration: none;
   }
   .errorMsg h1{
       margin-top: -20px;
       font-size: 3.5em;
       color:#1ab394;
   }
   .errorMsg .p{
       margin-top: 40px;
       color:red;
       font-weight:700;
   }
   .errorMsg .main{
       margin: 0 auto;
       text-align: center;
       display: table-cell;
       vertical-align: middle;
   }
</style>
<script src="${ctxStatic}/jquery-validation/1.11.0/lib/jquery.form.js" type="text/javascript"></script>
<script type="text/javascript">
	function loadFun(btnId){
		top.layer.load();
		if(!btnId){
			$("#"+btnId).prop("disabled",true);	
		}
	}
	function closeLoadFun(btnId){
		top.layer.closeAll('loading');
		if(!btnId){
			$("#"+btnId).prop("disabled",false);
		}
	}
	$(document).ready(function() {
		parent.isYes = false;
		//保存事件
		$("#btnSubmit").click(function() {
			let samplingMemberName = $("#samplingMemberNameDiv").html().trim();
			if (samplingMemberName == '') {
				$.jBox.error("请先查询采样包归属人！","系统提示");
				return;
			}
			$.jBox.confirm("确认要补寄吗？","系统提示",function(v,h,f){
				if(v=="ok"){
					reissueSampling();
				}
			},{buttonsFocus:1});
		});
	});
	
	function reissueSampling(){
		loadFun('btnSubmit');
		$("#inputForm").ajaxSubmit({
			dataType : 'json',
			beforeSubmit : function() {
				if (!$("#inputForm").valid()|| $(".error:visible").length > 0) {
					return false;
				} else {
					return true;
				}
			},
			success : function(json) {
				closeLoadFun('btnSubmit');
				let data = eval(json);
				if (data.rc == 0) {
					layer.msg(data.data);
					parent.isYes = true;
					parent.layer.closeAll();
				} else {
					layer.msg(data.msg);
				}
			},
			error : function(err) {
				closeLoadFun('btnSubmit');
				layer.msg("操作失败!");
			}
		});
	}

	function showSamplingBindRecord() {
		if ($("#samplingBindRecord").is(":hidden")) {
			$("#samplingBindRecord").show(200);
		} else {
			$("#samplingBindRecord").hide(200);
		}
	}
	function findBySamplingCode() {
		var samplingCode = $("#samplingCode").val();
		if (samplingCode != '') {
			loadFun("findBySamplingCodeBtn");
			$.ajax({
				type : "GET",
				url : "${ctx}/sampling/sampling/samplingCode?samplingCode=" + samplingCode,
				success : function(json) {
					closeLoadFun("findBySamplingCodeBtn");
					let data = eval(json);
					if (data.rc == 0) {
						if (data.data.bindType == 1) {
							$.jBox.error("请输入已存在且未使用的采样包！", "系统提示");
							$("#samplingCode").val("");
							$("#samplingMemberNameDiv").html("");
						} else {
							$("#samplingMemberNameDiv").html(data.data.memberName ? data.data.memberName : '无');
						}
					} else {
						layer.msg(data.msg);
					}
				},
				error: function (res) {
					closeLoadFun("findBySamplingCodeBtn");
					layer.msg("操作失败!");
				}
			});
		} else {
			$.jBox.error("请输入已存在且未使用的采样包！", "系统提示");
		}
	}

	function closeLayer() {
		parent.layer.closeAll();
	}
</script>
</head>
<body>
<c:choose>
    <c:when test="${not empty errorMsg}">
    	<div class="errorMsg">
	    	<div class="main">
			    <h1>:(</h1>
			    <p class="p">${errorMsg}~</p>
			    <input style="margin-top:20px;" class="btn" type="button" onclick="parent.layer.closeAll();" value="关闭"/>
			</div>
		</div>
    </c:when>
    <c:otherwise>
		<form:form id="inputForm" modelAttribute="dogDnaArchive" action="${ctx}/dnaarchive/dogDnaArchive/reissue" method="post" class="form-horizontal">
			<form:hidden path="id" />
			<div class="control-group">
				<label class="control-label">血统证书号：</label>
				<div class="controls">
					<div class="div-label">${empty dogDnaArchive.pedigreeCertified? '-' : dogDnaArchive.pedigreeCertified}
					</div>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">国外证书号：</label>
				<div class="controls">
					<div class="div-label">${empty dogDnaArchive.overseasPedigreeCertified? '-' : dogDnaArchive.overseasPedigreeCertified}
					</div>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">出生纸编号：</label>
				<div class="controls">
					<div class="div-label">${empty dogDnaArchive.birthCode? '-' : dogDnaArchive.birthCode}
					</div>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">犬主人：</label>
				<div class="controls">
					<div class="div-label">${dogDnaArchive.memberName}</div>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">申请日期：</label>
				<div class="controls">
					<div class="div-label">
						<fmt:formatDate value="${dogDnaArchive.createDate}"
							pattern="yyyy-MM-dd HH:mm:ss" />
					</div>
				</div>
			</div>
			<div id="samplingBindRecord" class="control-group"
				style="padding: 10px 40px;">
				<table id="contentTable"
					class="table table-striped table-bordered table-condensed">
					<thead>
						<tr>
							<th class="text-center" colspan="4"
								style="color: #f50; font-size: 14px; padding: 5px;">采样包补寄记录</th>
						</tr>
						<tr>
							<th class="text-center">采样包编号</th>
							<th class="text-center">绑定时间</th>
							<th class="text-center">采样包状态</th>
							<th class="input-medium">备注</th>
						</tr>
					</thead>
					<c:if test="${empty bindSamplingRecord || fn:length(bindSamplingRecord) == 0}">
							<tr>
								<td colspan="4" class="text-center">暂无补寄记录</td>
							</tr>				
					</c:if>
					<c:if test="${not empty bindSamplingRecord && fn:length(bindSamplingRecord) > 0}">
						<c:forEach items="${bindSamplingRecord}" var="sampling">
							<tr>
								<td class="text-center">${sampling.samplingCode}</td>
								<td class="text-center"><fmt:formatDate
										value="${sampling.bindTime}" pattern="yyyy-MM-dd HH:mm:ss" /></td>
								<td class="text-center"><c:choose>
										<c:when test="${sampling.flowState < 2}">
											${fns:getDictLabel(sampling.bindType, 'bind_type', '')}
										</c:when>
										<c:otherwise>
											${fns:getDictLabel(sampling.flowState, 'sampling_flow_state', '')}
										</c:otherwise>
									</c:choose></td>
								<td>
									<div title="${sampling.remarks}" class="div-remark">
										${sampling.remarks}</div>
								</td>
							</tr>
						</c:forEach>
					</c:if>
				</table>
			</div>
			<div class="control-group">
				<label class="control-label">现采样包编号：</label>
				<div class="controls">
					<div class="div-label" style="display: flex;">
						<!-- <div class="div-tag"> -->
						${dogDnaArchive.samplingCode}
						<!-- </div> -->
						<!-- <div style="margin-left:30px;display: flex;">
							<a href="#" onclick="showSamplingBindRecord();">采样包绑定记录</a>
						</div> -->
					</div>
				</div>
			</div>
	
			<div class="control-group">
				<label class="control-label">
					<span class="help-inline" style="margin-right:2px;"><font color="red">*</font> </span>
					采样包编号：
				</label>
				<div class="controls">
					<input type="text" id="samplingCode" name="samplingCode" class="input-xlarge" maxlength="64" /> 
					<button id="findBySamplingCodeBtn" type="button" class="btn btn-primary" onclick="findBySamplingCode()">查询</button>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">采样包归属人：</label>
				<div class="controls">
					<div class="div-label" id="samplingMemberNameDiv"></div>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">原采样包备注：</label>
				<div class="controls">
					<form:textarea path="remarks" htmlEscape="false" rows="4"
						maxlength="255" class="input-xlarge " />
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">会员余额：</label>
				<div class="controls">
					<div class="div-label">¥ ${member.accountBalance}</div>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">扣费项目：</label>
				<div class="controls">
					<div class="div-label" style="width:90%;height: 100%;">
						<c:forEach items="${paymentChargingItemList}" var="item" varStatus="index">
							${item.name}
							<c:if test="${index.last==false}">
								,
							</c:if>
						</c:forEach>
					</div>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">扣费金额：</label>
				<div class="controls">
					<div class="div-label">¥ ${orderTotal}</div>
				</div>
			</div>
			<div class="form-actions">
				<shiro:hasPermission name="dnaarchive:dogDnaArchive:rebind">
					<input id="btnSubmit" class="btn btn-primary" type="button" value="保 存" />&nbsp;
				</shiro:hasPermission>
				<input id="btnCancel" class="btn" type="button" value="返 回" onclick="closeLayer()" />
			</div>
		</form:form>
	</c:otherwise>
</c:choose>
</body>
</html>