<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展犬只部位评价管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/contest/contestCritic/">犬展犬只部位评价列表</a></li>
		<shiro:hasPermission name="contest:contestCritic:edit"><li><a href="${ctx}/contest/contestCritic/form">犬展犬只部位评价添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="contestCritic" action="${ctx}/contest/contestCritic/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>编号：</label>
				<form:input path="contestCriticNo" htmlEscape="false" maxlength="11" class="input-medium"/>
			</li>
			<li><label>名称：</label>
				<form:input path="name" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li><label>语言：</label>
				<form:select path="languageNo" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${languageList}" itemLabel="name" itemValue="languageNo" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>编号</th>
				<th>名称</th>
				<th>语言</th>
				<shiro:hasPermission name="contest:contestCritic:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="contestCritic">
			<tr>
				<td><a href="${ctx}/contest/contestCritic/form?id=${contestCritic.id}">
					${contestCritic.contestCriticNo}
				</a></td>
				<td>
					${contestCritic.name}
				</td>
				<td>
					${contestCritic.languageNo}
				</td>
				<shiro:hasPermission name="contest:contestCritic:edit"><td>
    				<a href="${ctx}/contest/contestCritic/form?id=${contestCritic.id}">修改</a>
					<a href="${ctx}/contest/contestCritic/delete?id=${contestCritic.id}" onclick="return confirmx('确认要删除该犬展犬只部位评价吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>