package com.cku.schools.mrschool.web;

import com.cku.oa.groomer.dao.GroomerCourseDao;
import com.cku.oa.trainschool.entity.TeacherLecturer;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.cku.oa.trainschool.service.TrainingInstitutionService;
import com.cku.schools.mrschool.service.SchoolsTeacherService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@Controller
@RequestMapping("/schools/schoolsTeacher")
public class SchoolTeacherController extends BaseController {


    @Autowired
    private SchoolsTeacherService schoolsTeacherService;
    @Autowired
    private TrainingInstitutionService trainingInstitutionService;
    @Autowired
    private GroomerCourseDao groomerCourseDao;
    /**
     *
     * @Author chaixueteng
     * @2016年10月9日下午2:55:
     */
    @RequestMapping(value="/list")
    public String account(TeacherLecturer teacherLecturer, Model model, HttpServletRequest request, HttpServletResponse response){
        TrainingInstitution ti = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
        teacherLecturer.setSchoolId(ti.getId());
        Page<TeacherLecturer> page = schoolsTeacherService.findPage(new Page<TeacherLecturer>(request, response), teacherLecturer);
        model.addAttribute("page", page);
        return "schools/mrschool/schoolsTeacherList";
    }
    @RequestMapping(value="/form")
    public String form(TeacherLecturer teacherLecturer, Model model){
        if(teacherLecturer!=null && null!=teacherLecturer.getId()){
            teacherLecturer = schoolsTeacherService.get(teacherLecturer.getId());
        }
        model.addAttribute("teacherLecturer", teacherLecturer);
        return "schools/mrschool/schoolTeacherAdd";
    }

    @RequestMapping(value="/save")
    public String save(TeacherLecturer teacherLecturer){

        //获取合作机构
        TrainingInstitution ti = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
        teacherLecturer.setSchoolId(ti.getId());
        teacherLecturer.setIntroduce(StringEscapeUtils.unescapeHtml4(teacherLecturer.getIntroduce()));
        schoolsTeacherService.save(teacherLecturer);
        return "redirect:/schools/schoolsTeacher/list";
    }

    @RequestMapping(value="/del")
    public String del(TeacherLecturer teacherLecturer){
        schoolsTeacherService.delete(teacherLecturer);
//        删除课程里面的讲师信息
        groomerCourseDao.delCourseTeacher(teacherLecturer.getId());
        return "redirect:/schools/schoolsTeacher/list";
    }

    @ResponseBody
    @RequestMapping(value = {"iSrepeat", ""})
    public Object iSrepeat(TeacherLecturer teacherLecturer, HttpServletRequest request, HttpServletResponse response)throws IOException {
        //查重
        HashMap<String,String> map = new HashMap<String,String>();
        try {
            schoolsTeacherService.ISrepeat(teacherLecturer);
            map.put("rc", "0");
        } catch (Exception e) {
            map.put("rc", "1");
            map.put("msg", e.getMessage());
        }
        return map;
    }
    @ResponseBody
    @RequestMapping(value = "findTeacher")
    public Object findTeacher(String teacherName) {
        Map<String, String> map = new HashMap<String, String>();
        TeacherLecturer teacher = schoolsTeacherService.findTeacher(teacherName);
        if(teacher != null){
            map.put("rc", "0");
            map.put("id", teacher.getId());
            map.put("name", teacher.getTeacherName());
        }else{
            map.put("rc", "1");
            map.put("msg", "查无此讲师信息!");
        }
        return map;
    }
}
