package com.cku.restful.v1.sys.service;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.util.HttpClientUtil;
import com.cku.util.HttpResult;
import com.thinkgem.jeesite.common.config.Global;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * Created by lyyz on 2018/10/29.
 */
@Service
@Transactional(readOnly = true)


public class OpenNewPetPassService {

    private static final String SESSION_SRV_URL = Global.getConfig("cabPassportServiceUrl")+"/cab/petClass/cabPassport?cabPassport=";

    @Autowired
    private DogBirthCertificateService dogBirthCertificateService;

    public RESTResponse getCabPassport(HttpServletRequest request) {
        String result = "false";
        String cabPassport = request.getParameter("cabPassport");

        if(StringUtils.isBlank(cabPassport)){
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"护照号不能为空");
        }
        if(cabPassport.length()!=9){
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"护照号格式不正确");
        }

        DogBirthCertificate dogBirthCertificate = dogBirthCertificateService.getByCabPassport(cabPassport);
        if(dogBirthCertificate==null){
            HttpResult hr = null;
            try {
                hr = HttpClientUtil.get(null, SESSION_SRV_URL+cabPassport, null);
            } catch (IOException e) {
                e.printStackTrace();
                result = "false";
            }
            if(!"".equals(hr.getResponseBody())&& hr.getResponseBody()!=null){
                JSONObject jo = JSONObject.fromObject(hr.getResponseBody());
                if(jo!=null && !"".equals(jo)){
                    result = "true";
                }
            }

        }else{
            result = "true";
        }

        return new RESTResponse("data", result);
    }
}
