package com.cku.restful.v1.open;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.oa.notice.service.NoticeService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

/**
 * 公告查询Controller
 *
 * @author xx
 * @version 2021-01-18
 */

@Controller
@RequestMapping(value = "/api/v1/open/notice")
public class OpenNoticeController extends BaseRestController {
	@Autowired
	private NoticeService noticeService;

	/**
	 * 首页 每次展示最新的五个通知的标题
	 * 
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/getTitleList", method = RequestMethod.GET)
	@ResponseBody
	public void getTitleList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = noticeService.getTitleList(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 详细内容
	 * 
	 * @param id
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/getNoticeDetail/{id}", method = RequestMethod.GET)
	@ResponseBody
	public void getNoticeDetail(@PathVariable("id") String id, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = noticeService.getNoticeDetail(id);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 同类型公告标题
	 * 
	 * @param id
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/getTitleListBySameSort/{id}", method = RequestMethod.GET)
	@ResponseBody
	public void getTitleListBySameSort(@PathVariable("id") String id, HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = noticeService.getTitleListBySameSort(id);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 得到通知下面所有分组
	 * 
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/getSorts", method = RequestMethod.GET)
	@ResponseBody
	public void getSorts(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = noticeService.getSorts();
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 分类下文章列表
	 * 
	 * @param sortId
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/getTitleListBySortId", method = RequestMethod.GET)
	@ResponseBody
	public void getTitleListBySortId(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String sortId = request.getParameter("sortId");
		RESTResponse result = noticeService.getTitleListBySortId(sortId, request, response);
		ServletUtils.writeResponse(response, result);
	}

}