package com.cku.restful.v1.dog.web;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.dog.service.RestDogPedigreeCertifiedRedoService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 证书补做Controller
 *
 * @author lgl
 * @version 2016-08-11
 */
@Controller
@RequestMapping(value = "/api/v1/dog")
public class RestDogPedigreeCertifiedRedoController extends BaseRestController {

	@Autowired
	private RestDogPedigreeCertifiedRedoService restDogPedigreeCertifiedRedoService;

	@RequestMapping(value = "/dogpedigreecertifiedredo", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restDogPedigreeCertifiedRedoService
				.getList(request);
		ServletUtils.writeResponse(response, result);
	}
//	会员中心没有证书补做删除或撤销接口
//	@RequestMapping(value = "/dogpedigreecertifiedredo/{id}", method = RequestMethod.DELETE)
//	@ResponseBody
//	public void delete(@PathVariable("id") String id,
//			HttpServletResponse response) throws IOException {
//		RESTResponse result = restDogPedigreeCertifiedRedoService.delete(id);
//		ServletUtils.writeResponse(response, result);
//	}

	@RequestMapping(value = "/dogpedigreecertifiedredo", method = RequestMethod.POST)
	@ResponseBody
	public void post(@RequestBody String json, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restDogPedigreeCertifiedRedoService.post(json);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/dogpedigreecertifiedredo/getPrice", method = RequestMethod.GET)
	@ResponseBody
	public void getPrice(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restDogPedigreeCertifiedRedoService
				.getPrice(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 校验呼名
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/dogpedigreecertifiedredo/checkCallName", method = RequestMethod.GET)
	@ResponseBody
	public void checkCallName(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restDogPedigreeCertifiedRedoService
				.checkCallName(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：订单详细中业务数据查询
	 * @author: zhuoHeng
	 * @version: 2017年1月9日 上午10:09:56
	 */
	@RequestMapping(value = "/dogpedigreecertifiedredo/orderDetail", method = RequestMethod.GET)
	@ResponseBody
	public void orderDetail(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		String id = request.getParameter("id");
		RESTResponse result = restDogPedigreeCertifiedRedoService.orderDetail(id);
		ServletUtils.writeResponse(response, result);
	}
}