/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dog.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.breeder.service.StudDogService;
import com.cku.oa.dog.dao.DogColorMarkDao;
import com.cku.oa.dog.dao.DogSemenDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogFrozenSemen;
import com.cku.oa.dog.entity.DogSemen;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogDnaService;
import com.cku.oa.dog.service.DogFrozenSemenService;
import com.cku.oa.dog.service.DogSemenService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.util.ImgUtil;
import com.cku.oa.tcb.service.TcbKennelService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/**
 * 配种证明Service
 *
 * @author zhuoHeng
 * @version 2016-08-02
 */
@Service
@Transactional(readOnly = true)
public class RestDogFrozenSemenService {

	private static final String PAYMENTCHARGINGITEM_SHENBAO = "dog_frozen_semen@0";
	private static final String PAYMENTCHARGINGITEM_BAOBEI = "dog_frozen_semen@1";

	@Autowired
	private DogService dogService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private PaymentCartService paymentCartService;
	@Autowired
	public TcbKennelService tcbKennelService;
	@Autowired
	public DogColorMarkDao dogColorMarkDao;
	@Autowired
	public DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	public DogFrozenSemenService dogFrozenSemenService;
	@Autowired
	public DogSemenDao dogSemenDao;
	@Autowired
	public DogSemenService dogSemenService;
	@Autowired
	public DogDnaService dogDnaService;
	@Autowired
	public LoginServerService loginServerService;

	@Autowired
	private StudDogService studDogService;

	public RESTResponse get(String id) {
		Member member = UserUtils.getLoginMember();
		DogFrozenSemen po = dogFrozenSemenService.get(id);
		if (po == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		if (!po.getMemberCode().equals(member.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		JSONObject data = new JSONObject();
		data.put("id", getString(po.getId()));
		data.put("semenBatchCode", getString(po.getSemenBatchCode()));
		dogSemenService.setDogInfo(po.getDogId(), data);
		data.put("semenNumber", getString(po.getSemenNumber()));
		JSONArray ja = new JSONArray();
		List<DogSemen> dogSemenList = dogSemenDao.getBySemenBatchCode(po.getSemenBatchCode());
		for (DogSemen dogSemen : dogSemenList) {
			JSONObject jo = new JSONObject();
			jo.put("id", getString(dogSemen.getId()));
			jo.put("originalSemenCode", getString(dogSemen.getOriginalSemenCode()));
			jo.put("semenCode", getString(dogSemen.getSemenCode()));
			ja.add(jo);
		}
		data.put("dogSemenList", ja);
		return new RESTResponse("data", data);
	}

	public RESTResponse getList(HttpServletRequest request) {

		Member member = UserUtils.getLoginMember();

		// 获取参数
		String pedigreeCertified = request.getParameter("pedigreeCertified");
		String businessType = request.getParameter("businessType");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");

		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}

		DogFrozenSemen example = new DogFrozenSemen();
		// 设置分页参数
		Page<DogFrozenSemen> page = new Page<DogFrozenSemen>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 设置查询条件
		example.setMemberCode(member.getMemberCode());
		example.setPage(page);
		if (StringUtils.isNotBlank(pedigreeCertified)) {
			example.setPedigreeCertifiedAndDogChipLike(pedigreeCertified);
		}
		if (StringUtils.isNotBlank(businessType)) {
			example.setBusinessType(businessType);
		}
		// 根据当前登录是否杜高会员来判断个人狗列表是杜高犬还是CKU犬
		if (StringUtils.isBlank(example.getDogBreed())) {
			// 根据当前登录端查询犬种
			example.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			example.getSqlMap().put("dogBreedMap", " ='" + example.getDogBreed() + "'");
		}
		// 查询并组装返回对象
		Page<DogFrozenSemen> result = dogFrozenSemenService.findPage(page, example);
		List<DogFrozenSemen> dogFrozenSemenList = result.getList();
		List<JSONObject> list = new ArrayList<JSONObject>();
		for (DogFrozenSemen po : dogFrozenSemenList) {
			JSONObject vo = new JSONObject();
			vo.put("id", getString(po.getId()));
			vo.put("semenBatchCode", getString(po.getSemenBatchCode()));
			dogSemenService.setDogInfo(po.getDogId(), vo);
			vo.put("memberName", getString(po.getMemberName()));
			String businessTypeString = "";
			if ("0".equals(po.getBusinessType())) {
				businessTypeString = "申报";
			} else if ("1".equals(po.getBusinessType())) {
				businessTypeString = "报备";
			}
			vo.put("businessType", getString(businessTypeString));
			vo.put("semenNumber", getString(po.getSemenNumber()));
			String acquisitionTime = "";
			if (po.getAcquisitionTime() != null) {
				acquisitionTime = com.cku.util.DateUtils.dateToStr(po.getAcquisitionTime());
			}
			vo.put("acquisitionTime", getString(acquisitionTime));
			vo.put("createDate", getString(com.cku.util.DateUtils.dateToStr(po.getCreateDate())));
			vo.put("businessState", getString(po.getBusinessState()));
			vo.put("reviewRemarks", getString(po.getReviewRemarks()));
			list.add(vo);
		}
		long count = result.getCount();
		return new RESTResponse("list", new PageBeanResult<JSONObject>(list, count));
	}

	@Transactional(readOnly = false)
	public RESTResponse post(String json) {
		// 获取参数
		JSONObject jo = JSONObject.fromObject(json);
		// 参数校验
		validateParameter(jo);
		// 构造持久对象
		DogFrozenSemen po = buildPo(jo);
		// 业务校验
		dogFrozenSemenService.validateBusiness(po);
		// 写入业务表
		dogFrozenSemenService.save(po);
		if ("1".equals(jo.getString("businessType"))) {
			// 写入犬只精子表
			dogFrozenSemenService.saveDogSemen(po, jo.getJSONArray("originalSemenCode"));
		}
		// 写入购物车
		PaymentCart paymentCart = buildPaymentCart(po);
		paymentCartService.addToCart(paymentCart, "1014");
		return new RESTResponse("data", paymentCart.getId());
	}

	@Transactional(readOnly = false)
	public RESTResponse put(String json) {
		// 获取参数
		JSONObject jo = JSONObject.fromObject(json);
		// 参数校验
		putValidateParameter(jo);
		Member member = UserUtils.getLoginMember();
		DogFrozenSemen po = dogFrozenSemenService.get(jo.getString("id"));
		if (po == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		if (!member.getMemberCode().equals(po.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		// 业务状态为“未通过/待审核”，可以编辑”精子数量”和”原精子编号”
		if ("1".equals(po.getReviewState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该业务记录已通过审核，不允许修改");
		}
		if (!"1".equals(po.getBusinessType())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "只有种犬报备可以编辑");
		}
		// 1查标记原精子记录为删除
		dogSemenDao.deleteBySemenBatchCode(po.getSemenBatchCode());
		// 2写入犬只精子表
		dogFrozenSemenService.saveDogSemen(po, jo.getJSONArray("originalSemenCode"));
		// 修改数量
		po.setSemenNumber(jo.getJSONArray("originalSemenCode").size() + "");
		// 修改后改为未审核状态
		po.setReviewState("0");
		// 写入业务表
		dogFrozenSemenService.save(po);
		return new RESTResponse();
	}

	private void putValidateParameter(JSONObject jo) {
		if (!jo.containsKey("id")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id为空");
		}
		if (!jo.containsKey("originalSemenCode")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "原精子编号为空");
		}
		if (StringUtils.isBlank(jo.getString("id"))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id为空");
		}
		if (jo.getJSONArray("originalSemenCode") == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "原精子编号为空");
		}
	}

	/**
	 * @description: 参数校验
	 * @author: laiguanglong
	 * @date: 2016年9月13日 下午4:09:54
	 */
	private void validateParameter(JSONObject jo) {
		if (!jo.containsKey("dogId")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "dogId为空");
		}
		if (!jo.containsKey("businessType")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "业务类型为空");
		}
		if (StringUtils.isBlank(jo.getString("dogId"))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "dogId为空");
		}
		if (StringUtils.isBlank(jo.getString("businessType"))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "业务类型为空");
		}
		if (!"0".equals(jo.getString("businessType")) && !"1".equals(jo.getString("businessType"))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "业务类型只能为0或1");
		}
		if ("1".equals(jo.getString("businessType"))) {
			if (!jo.containsKey("originalSemenCode")) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "原精子编号为空");
			}
			if (jo.getJSONArray("originalSemenCode") == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "原精子编号为空");
			}
			if (StringUtils.isBlank(jo.getString("acquisitionTime"))) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "采集时间为空");
			}
		}
	}

	/**
	 * @description: 构造持久对象
	 * @author: laiguanglong
	 * @date: 2016年9月13日 下午5:56:52
	 */
	private DogFrozenSemen buildPo(JSONObject jo) {
		Dog dog = dogService.get(jo.getString("dogId"));
		Member member = UserUtils.getLoginMember();
		if (dog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "dogId有误");
		}
		DogFrozenSemen po = new DogFrozenSemen();
		po.setSemenBatchCode(SysCodeUtil.getSemenBatchCode());
		po.setDogId(dog.getId());
		po.setPedigreeCertified(dog.getPedigreeCertifiedCode());
		po.setDogChip(dog.getIdentificationFlag());
		po.setDogBreed(dog.getDogBreed());
		po.setDogName(dog.getNameEn());
		po.setMemberCode(member.getMemberCode());
		po.setMemberName(member.getName());
		po.setBusinessType(jo.getString("businessType"));
		if ("1".equals(jo.getString("businessType"))) {
			po.setSemenNumber(jo.getJSONArray("originalSemenCode").size() + "");
			Date acquisitionTime = null;
			try {
				acquisitionTime = new SimpleDateFormat("yyyy-MM-dd").parse(jo.getString("acquisitionTime"));
			} catch (Exception e) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "采集时间格式有误");
			}
			po.setAcquisitionTime(acquisitionTime);
		}
		return po;
	}

	private PaymentCart buildPaymentCart(DogFrozenSemen po) {
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem paymentChargingItem = getPaymentChargingItem(po.getBusinessType());
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(paymentChargingItem.getPrice());
		paymentCart.setTotalPrice(paymentChargingItem.getPrice());
		paymentCart.setBusinessTable("dog_frozen_semen");
		paymentCart.setBusinessIds(po.getId());
		return paymentCart;
	}

	public RESTResponse getPrice(HttpServletRequest request) {
		// 获取参数
		String businessType = request.getParameter("businessType");
		// 参数校验
		if (StringUtils.isBlank(businessType)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "业务类型为空");
		}
		if (!"0".equals(businessType) && !"1".equals(businessType)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "业务类型只能为0或1");
		}
		PaymentChargingItem paymentChargingItem = getPaymentChargingItem(businessType);
		JSONObject jo = new JSONObject();
		jo.put("price", paymentChargingItem.getPrice());
		return new RESTResponse("data", jo);
	}

	private PaymentChargingItem getPaymentChargingItem(String businessType) {
		String shortName = "";
		if ("0".equals(businessType)) {
			shortName = PAYMENTCHARGINGITEM_SHENBAO;
		} else if ("1".equals(businessType)) {
			shortName = PAYMENTCHARGINGITEM_BAOBEI;
		}
		return paymentChargingItemService.getByShortName(shortName);
	}

	public RESTResponse checkByPedigreeCertifiedCode(HttpServletRequest request) {
		String pedigreeCertifiedCode = request.getParameter("pedigreeCertifiedCode");
		String businessType = request.getParameter("businessType");
		if (StringUtils.isBlank(pedigreeCertifiedCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号为空");
		}
		if (StringUtils.isBlank(businessType)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "业务类型为空");
		}
		if (!"0".equals(businessType) && !"1".equals(businessType)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "业务类型只能为0或1");
		}
		Member member = UserUtils.getLoginMember();
		Dog dog = dogService.getByPedigreeCertifiedCode(pedigreeCertifiedCode);
		if (dog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号有误");
		}
		loginServerService.validDogType(dog);
		dogFrozenSemenService.checkDog(dog, member, businessType);
		JSONObject data = new JSONObject();
		dogSemenService.setDogInfo(dog.getId(), data);
		data.put("isHaveDogDna", dogDnaService.isHaveDogDna(dog.getId()));
		// 几个月 头像
		data.put("studDogCoverImg", getString(ImgUtil.getImgUrl(request, dog.getStudDogCoverImgId())));
		data.put("age", getString(studDogService.getAge(dog.getBirthdate())));
		data.put("gender", dog.getGender());
		return new RESTResponse("data", data);
	}

	private String getString(String str) {
		return str == null ? "" : str;
	}
}