package com.cku.oa.showRefereeDelegate.comparator;


import com.cku.oa.showRefereeDelegate.entity.Referee;

import java.util.Comparator;

/**
 * @author yuanshuai
 * @date 2021/2/4 15:56
 */
public class RefereeLevelTwoComparator implements Comparator<Referee> {
	@Override
	public int compare(Referee o1, Referee o2) {
		//1.待分配场次
		int compare = Integer.compare(o2.getJoinCount() - o2.getDelegateCount(), o1.getJoinCount() - o1.getDelegateCount());
		//2.级别
		if (compare == 0) {
			compare = Integer.compare(o1.getLevel().getCode(), o2.getLevel().getCode());
		}
		//3.权重
		if (compare == 0) {
			compare = Integer.compare(o2.getWeight(), o1.getWeight());
		}
		//4.随机值
		if (compare == 0) {
			compare = Integer.compare(o2.getSort(), o1.getSort());
		}
		return compare;
	}
}
