/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.handler.service;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

import com.cku.logUtil.JSONObjectUtils;
import com.cku.oa.constant.Constants;
import com.cku.oa.groomer.entity.GroomerRegister;
import com.cku.oa.groomer.entity.GroomerShow;
import com.cku.oa.groomer.service.GroomerShowRefereeService;
import com.cku.oa.handler.dao.HandlerQualificationCertificateDao;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.handler.dao.HandlerRegisterDao;
import com.cku.oa.handler.entity.HandlerQualificationCertificate;
import com.cku.oa.handler.entity.HandlerRegister;
import com.cku.oa.handler.entity.HandlerShow;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.entity.user.CardTypeEnum;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.RemindService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.AgeUtil;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.oa.sys.zalog.SysContext;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.common.utils.excel.ImportExcel;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 报名Service
 * 
 * @author 柴雪腾
 * @version 2016-08-08
 */
@Service
@Transactional(readOnly = true)
public class HandlerRegisterService extends CrudService<HandlerRegisterDao, HandlerRegister> {

	@Autowired
	public HandlerShowService handlerShowService;
	@Autowired
	public HandlerQualificationCertificateService handlerQualificationCertificateService;
	@Autowired
	public RemindService remindService;
	@Autowired
	public DogService dogService;
	@Autowired
	public DogTypeService dogTypeService;

	@Autowired
	public HandlerDiplomaService handlerDiplomaService;
	@Autowired
	public MemberService memberService;

	@Autowired
	public HandlerQualificationCertificateDao handlerQualificationCertificateDao;

	@Autowired
	public GroomerShowRefereeService showRefereeService;

	public HandlerRegister get(String id) {
		return super.get(id);
	}

	public List<HandlerRegister> findList(HandlerRegister handlerRegister) {
		return super.findList(handlerRegister);
	}

	public Page<HandlerRegister> findPage(Page<HandlerRegister> page, HandlerRegister handlerRegister) {
		return super.findPage(page, handlerRegister);
	}

	@Transactional(readOnly = false)
	public void save(HandlerRegister handlerRegister) {
		
		if (handlerRegister.getIsNewRecord()){
			handlerShowService.updateRegisterNum(handlerRegister.getShowCode(), 1);
		}else{
			HandlerRegister old = dao.get(handlerRegister.getId());
			// 取消报名
			if("3".equals(handlerRegister.getReviewState()) &&  !"3".equals(old.getReviewRemarks())) {
				handlerShowService.updateRegisterNum(handlerRegister.getShowCode(), -1);
			}
			// 修改为报名
			if("1".equals(handlerRegister.getReviewState()) && !"1".equals(old.getReviewState())) {
				HandlerShow handlerShow = handlerShowService.getShow(handlerRegister.getShowCode());
				if ("10".equals(handlerShow.getShowType())) {
					Integer max = 0, registerNum = 0;
					if (null != handlerShow.getMaxNumber()) {
						max = handlerShow.getMaxNumber();
					}
					if (null != handlerShow.getRegisterNumber()) {
						registerNum = handlerShow.getRegisterNumber();
					}
					if (max <= registerNum) {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "报名已达上限");
					}
					handlerShowService.updateRegisterNum(handlerRegister.getShowCode(), 1);
				}
			}
		}
		
	
		
		super.save(handlerRegister);
	}

	@Transactional(readOnly = false)
	public void delete(HandlerRegister handlerRegister) {
		super.delete(handlerRegister);
	}

	/**
	 * 查询培训机构和符合报名的级别
	 * 
	 * @Author chaixueteng
	 * @2016年8月10日下午2:50:56
	 */
	public static final String MSG = "您的证书级别不符合考试所需级别!";

	public Map<String, Object> getMemberMessage(String memberCode, String level, String handlerShowId)
			throws ZAException {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("rc", "0");
		Member member = memberService.getByMemberCode(memberCode);
		Date birthday = member.getBirthday();
		HandlerShow handlerShow = null;
		if (StringUtils.isNotBlank(handlerShowId)) {
			handlerShow = handlerShowService.get(handlerShowId);
		}
		if (!MemberUtil.isActiveMember(member)) {
			throw new ZAException(-1, "会员无效！");
		} else if (handlerShow != null && "7".equals(handlerShow.getShowType())) {
			// 银卡及银卡以上会员才可报名
			if (!MemberUtil.isActiveMember(member)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "有效爱宠银卡及以上会员办理!");
			}
			if (CardTypeEnum.DEFAULT_CARD.code() == UserUtils.getMemberCardType(member.getMemberCode())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "有效爱宠银卡及以上会员办理！");
			}
		} else if (handlerShow != null && "12".equals(handlerShow.getShowType())) {
			if (!MemberUtil.isCkuActiveMember(member)) {
				throw new ZAException(-1, "CKU会员无效！");
			}
			String testLevel = handlerShow.getTestLevel();
			String[] testLevels = testLevel.split(",");
			HandlerQualificationCertificate partnerDogLevel = handlerQualificationCertificateService.getPartnerDogLevel(memberCode);
			if (partnerDogLevel == null) {
				map.put("showLevel", "C");
				map.put("shortName", "handler_register@PartnerExam");
			} else {
				String showLevel = partnerDogLevel.getCertificateLevelEn();
				// 实现报名自动选择美容师上一级的赛事
				if (showLevel.equals("C")) {// C--B
					map.put("showLevel", "B");
					map.put("shortName", "handler_register@PartnerExam");
				} else if (showLevel.equals("B")) {// B-->A
					map.put("showLevel", "A");
					map.put("shortName", "handler_register@PartnerExam");
				} else if (showLevel.equals("A")) {// A-->教师
					map.put("showLevel", "MASTER");
					map.put("shortName", "handler_register@PartnerExamM");
				}
			}
			Boolean flag = Boolean.FALSE;
			for (String s : testLevels) {
				String stringLevel = String.valueOf(map.get("showLevel"));
				if (s.equals(stringLevel)) {
					flag = Boolean.TRUE;
				}
			}
			if (!flag) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该活动的活动级别没有您可参与的级别!");
			}
		} else if (handlerShow != null && "13".equals(handlerShow.getShowType())) {
			if (!MemberUtil.isCkuActiveMember(member)) {
				throw new ZAException(-1, "CKU会员无效！");
			}
			String testLevel = handlerShow.getTestLevel();
			String[] testLevels = testLevel.split(",");
			HandlerQualificationCertificate partnerDogLevel = handlerQualificationCertificateService.getPartnerDogLevel(memberCode);
			if (Objects.isNull(partnerDogLevel)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "无任何级别训练师资格证书，无法报名!");
			}
			if ("MASTER".equals(partnerDogLevel.getCertificateLevelEn())) {
				map.put("showLevel", "MASTER");
			} else if ("A".equals(partnerDogLevel.getCertificateLevelEn())) {
				map.put("showLevel", "A");
			} else if ("B".equals(partnerDogLevel.getCertificateLevelEn())) {
				map.put("showLevel", "B");
			} else if ("C".equals(partnerDogLevel.getCertificateLevelEn())) {
				map.put("showLevel", "C");
			}
			map.put("shortName", "handler_register@PartnerMatch");
			Boolean flag = Boolean.FALSE;
			for (String s : testLevels) {
				String stringLevel = String.valueOf(map.get("showLevel"));
				if (s.equals(stringLevel)) {
					flag = Boolean.TRUE;
				}
			}
			if (!flag) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该活动的活动级别没有您可参与的级别!");
			}
		} else {
			if (!"none".equals(level)) {
				// 根据会员号查询资格证书等级
				HandlerQualificationCertificate hqc = handlerQualificationCertificateService.getLevel(memberCode);
				// 结业等级
				String diplomaLevel = handlerDiplomaService.getLevel(memberCode);
				if (diplomaLevel != null && hqc != null) {
					String memberLevel = hqc.getCertificateLevelEn().trim();
					Date issueDate = hqc.getIssueDate();
					Calendar curr = Calendar.getInstance();
					if ("C".equals(level)) {// C级考试
						if (!"C".equals(diplomaLevel) && !"精英培训班".equals(diplomaLevel) && !"B".equals(diplomaLevel)
								&& !"A".equals(diplomaLevel)) {
							throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, MSG);
						}
					} else if ("B".equals(level)) {// B级考试
						if (!"B".equals(diplomaLevel) && !"精英培训班".equals(diplomaLevel) && !"C".equals(memberLevel)) {
							throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, MSG);
						}
					} else if ("A".equals(level)) {// A级考试
						if (!"A".equals(diplomaLevel) && !"精英培训班".equals(diplomaLevel) && !"B".equals(memberLevel)) {
							throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, MSG);
						}
					} else if ("MASTER".equals(level)) {
						if ("A".equals(memberLevel)) {
							if (birthday == null) {
								throw new ZAException(-1, "会员出生日期为空!");
							}
							int age = AgeUtil.getAge(birthday);
							if (age < 30) {
								throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "年龄不满30周岁!");
							}
							curr.set(Calendar.YEAR, curr.get(Calendar.YEAR) - 1);
							Date date = curr.getTime();
							if (issueDate == null) {
								throw new ZAException(-1, "证书签发日期为空!");
							}
							if (date.before(issueDate)) {
								throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "申领A级证书不满一年!");
							}
						} else if ("MASTER".equals(memberLevel)) {
							throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您的级别已经最高了,没有符合您的考试可选!");
						} else {
							throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, MSG);
						}
					}

				} else if (hqc == null && diplomaLevel != null) {
					if ("C".equals(level)) {
						if (!"C".equals(diplomaLevel) && !"精英培训班".equals(diplomaLevel) && !"B".equals(diplomaLevel)
								&& !"A".equals(diplomaLevel)) {
							throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, MSG);
						}
					} else if ("B".equals(level)) {
						if (!"B".equals(diplomaLevel) && !"精英培训班".equals(diplomaLevel) && !"A".equals(diplomaLevel)) {
							throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, MSG);
						}
					} else if ("A".equals(level)) {
						if (!"A".equals(diplomaLevel) && !"精英培训班".equals(diplomaLevel)) {
							throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, MSG);
						}
					} else {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, MSG);
					}
				} else if (hqc != null && diplomaLevel == null) {
					String memberLevel = hqc.getCertificateLevelEn().trim();
					Date issueDate = hqc.getIssueDate();
					Calendar curr = Calendar.getInstance();
					if ("C".equals(level)) {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, MSG);
					} else if ("B".equals(level)) {
						if (!"C".equals(memberLevel)) {
							throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, MSG);
						}
					} else if ("A".equals(level)) {
						if (!"B".equals(memberLevel)) {
							throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, MSG);
						}
					} else if ("MASTER".equals(level)) {
						if (!"A".equals(memberLevel)) {
							throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, MSG);
						}
						if ("A".equals(memberLevel)) {
							if (birthday == null) {
								throw new ZAException(-1, "会员出生日期为空!");
							}
							int age = AgeUtil.getAge(birthday);
							if (age < 30) {
								throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "年龄不满30周岁!");
							}
							curr.set(Calendar.YEAR, curr.get(Calendar.YEAR) - 1);
							Date date = curr.getTime();
							if (issueDate == null) {
								throw new ZAException(-1, "证书签发日期为空!");
							}
							if (date.before(issueDate)) {
								throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "申领A级证书不满一年!");
							}
						} else if ("MASTER".equals(memberLevel)) {
							throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您的级别已经最高了,没有符合您的考试可选!");
						}
					}
				} else {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您没有参加过相关培训课程,没有证书!");
				}
				// 查询培训学校
				String schoolNameCn = dao.getSchoolNameCn(memberCode);
				map.put("schoolNameCn", schoolNameCn);
			}
		}
		return map;
	}

	/**
	 * 校验会员报名牵犬师大赛的验证
	 * 
	 * @Author chaixueteng
	 * @2016年8月10日下午2:50:56
	 */
	public static final String MSGs = "您的证书级别不符合考试所需级别!";

	public Map<String, Object> validApple(String memberCode, String id) throws ZAException {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("rc", "0");
		Member member = memberService.getByMemberCode(memberCode);
		HandlerShow handlerShow = handlerShowService.get(id);
		if (handlerShow == null) {
			throw new ZAException(-1, "活动无效！");
		} else {
			map.put("showCode", handlerShow.getShowCode());
		}
		HandlerRegister handlerRegister = new HandlerRegister();
		handlerRegister.setMemberCode(memberCode);
		handlerRegister.setShowCode(handlerShow.getShowCode());
		List<HandlerRegister> findList = super.findList(handlerRegister);
		if (findList.size() > 0) {
			throw new ZAException(-1, "请勿重复报名！");
		}
		map.put("group", "预职业组");
		if (!MemberUtil.isActiveMember(member)) {
			throw new ZAException(-1, "CKU会员无效！");
		} else {
			// 根据会员号查询资格证书等级
			HandlerQualificationCertificate hqc = handlerQualificationCertificateService.getLevel(memberCode);
			if (hqc == null) {
				map.put("group", "预职业组");
			} else {
				map.put("group", "专业选手组");
			}
		}
		return map;
	}

	/**
	 * 获取会员的参赛级别
	 * 
	 * @throws ZAException
	 * @Author chaixueteng
	 * @2016年7月25日下午3:49:27
	 */
	public String autoSelectLevel(String memberLevel) throws ZAException {
		// 实现报名自动选择美容师上一级的赛事
		if (memberLevel.equals("C")) {// C--B
			return "B";
		} else if (memberLevel.equals("B")) {// B-->A
			return "A";
		} else if (memberLevel.equals("A")) {// A-->教师
			return "MASTER";
		} else if (memberLevel.equals("MASTER")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您的级别已经最高了");
		}
		return memberLevel;
	}

	/**
	 * 线上报名
	 * 
	 * @Author chaixueteng
	 * @2016年8月10日下午4:24:51
	 */
	@Transactional(readOnly = false)
	public void mobileSave(HandlerRegister handlerRegister) {
		// 设置默认值
		handlerRegister.preInsert();
		handlerRegister.setShowLeave("0");
		handlerRegister.setLeaveCancel("0");
		handlerRegister.setReviewState("0");
		handlerRegister.setPaymentState("1");
		handlerRegister.setProccessState("0");
		handlerRegister.setRegisterCode(SysCodeUtil.getHandlerActivitySignCode("BW"));
		handlerRegister.setGrade(null);
		handlerRegister.setReferee(null);
		String level = handlerRegister.getShowLevel().trim();
		String showCode = handlerRegister.getShowCode();
		HandlerShow show = handlerShowService.getShow(showCode);
		if ("7".equals(show.getShowType()) && ("none".equals(level) || "MASTER".equals(level)))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "宠物营养师考试，级别只能选A/B/C");
		if ("12".equals(show.getShowType())) {
			if ("A".equals(level) || "B".equals(level) || "C".equals(level)) {
				handlerRegister.setPaymentItemId("0650a285501943369e561a1f05891349");
			} else if ("MASTER".equals(level)) {
				handlerRegister.setPaymentItemId("973b8836a2ed4884a895d5bcea9291a9");
			}
		} else if ("13".equals(show.getShowType())) {
			if ("none".equals(level)) {
				handlerRegister.setPaymentItemId("9e82db321c7e45dc95ae36f9526442f7");
			}
		} else {
			if (!"none".equals(level)) {// 不同的参赛级别 添加付费项目 做统计
				if ("A".equals(level)) {
					handlerRegister.setPaymentItemId("171");// A
				} else if ("B".equals(level)) {
					handlerRegister.setPaymentItemId("170");// B
				} else if ("C".equals(level)) {
					handlerRegister.setPaymentItemId("92");// C
				} else if ("MASTER".equals(level)) {
					handlerRegister.setPaymentItemId("186");// 教师
				}
			} else {
				handlerRegister.setPaymentItemId("172");// 精英大赛
			}
		}
		dao.mobilesave(handlerRegister);
		Date date = new Date();
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy年M月d日 H时:m分钟");
		remindService.addRemind(
				"您的于" + simpleDateFormat.format(date) + "报名" + show.getShowName().trim() + "活动，请您务必于当日24时前完成缴费，过期订单失效哦",
				handlerRegister.getMemberCode());
		remindService.addMemberRemind("您的于" + simpleDateFormat.format(date) + "报名" + show.getShowName().trim()
				+ "活动，请您务必于当日24时前完成缴费，过期订单失效哦!电话报名的可忽略此消息", handlerRegister.getMemberCode());
	}

	@Transactional(readOnly = false)
	public void mobileExaminerFrom(HandlerRegister handlerRegister) {
		// 设置默认值
		handlerRegister.preInsert();
		handlerRegister.setShowLeave("0");
		handlerRegister.setLeaveCancel("0");
		handlerRegister.setReviewState("1");
		handlerRegister.setPaymentState("2");
		handlerRegister.setProccessState("0");
		handlerRegister.setRegisterCode(SysCodeUtil.getHandlerActivitySignCode("BW"));
		handlerRegister.setGrade(null);
		handlerRegister.setReferee(null);
		handlerRegister.setShowGroup(
				StringUtils.isEmpty(handlerRegister.getShowGroup()) ? "" : handlerRegister.getShowGroup());
		dao.mobilesave(handlerRegister);
		
		HandlerShow handlerShow = handlerShowService.getShow(handlerRegister.getShowCode());
		if ("10".equals(handlerShow.getShowType())) {
			Integer max = 0, registerNum = 0;
			if (null != handlerShow.getMaxNumber()) {
				max = handlerShow.getMaxNumber();
			}
			if (null != handlerShow.getRegisterNumber()) {
				registerNum = handlerShow.getRegisterNumber();
			}
			if (max <= registerNum) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "报名已达上限");
			}
			handlerShowService.updateRegisterNum(handlerRegister.getShowCode(), 1);
		}
	}

	/**
	 * 成绩管理
	 * 
	 * @Author chaixueteng
	 * @2016年8月10日下午4:58:43
	 */
	public Page<HandlerRegister> findGradePage(Page<HandlerRegister> page, HandlerRegister handlerRegister) {
		handlerRegister.setPage(page);
		return page.setList(dao.findGradeList(handlerRegister));
	}

	/**
	 * 保存并审核图片
	 * 
	 * @Author chaixueteng
	 * @2016年8月18日下午1:32:49
	 */
	@Transactional(readOnly = false)
	public void saveImage(HandlerRegister handlerRegister) {
		try {
			String memberCode = handlerRegister.getMemberCode();
			String state = handlerRegister.getReviewState();
			String remarks = handlerRegister.getReviewRemarks();
			String avatar = handlerRegister.getMember().getAvatar();
			if (StringUtils.isBlank(avatar)) {
				throw new ZAException(-1, "请上传正确的照片!");
			}
			String id = handlerRegister.getId();
			HandlerRegister hr = get(id);
			SysContext sysContext = new SysContext(hr.getPaymentState(), hr.getReviewState(), hr.getProccessState());
			HandlerRegister HR = new HandlerRegister(id);
			HR.setAvatar(avatar);
			if ("1".equals(state)) {
				HR.setReviewState("1");
				HR.setReviewTime(new Date());
				sysContext.confirmSuccess(sysContext, "报名证件照", hr.getMemberCode(), "handler_register", hr.getId(),
						hr.getRunningNumber(), (str) -> {

						});
				// 审核通过 同步会员证件照
				// memberService.synImage(memberCode,avatar);
			} else {
				HR.setReviewState("2");
				HR.setReviewTime(new Date());
				HR.setReviewRemarks(remarks);
				sysContext.confirmFail(sysContext, "报名证件照", hr.getMemberCode(), "handler_register", hr.getId(),
						hr.getRunningNumber(), remarks, (str) -> {

						});
			}
			dao.saveImage(HR);
			String reviewState = HR.getReviewState();
			if ("1".equals(reviewState)) {
				remindService.addMemberRemind("您报名的活动编号为:" + hr.getShowCode() + "的参赛证件照审核已成功。", memberCode);
			} else if ("2".equals(reviewState)) {
				remindService.addMemberRemind(
						"您报名的活动编号为:" + hr.getShowCode() + "的参赛证件照审核未通过。未通过原因:" + HR.getReviewRemarks(), memberCode);
			}
		} catch (Exception e) {
			throw e;
		}
	}

	/**
	 * 成绩导入
	 * 
	 * @throws Exception
	 * @Author chaixueteng
	 * @2016年7月26日上午10:32:18
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public void importShows(MultipartFile file) throws Exception {
		try {
			ImportExcel ei = new ImportExcel(file, 0, 0);
			List<HandlerRegister> list = ei.getDataList(HandlerRegister.class);
			for (HandlerRegister gr : list) {
				HandlerRegister register = get(gr.getId());
				if (Objects.isNull(register)) {
					throw new ZAException(ZAErrorCode.ZA_ERROR, "Id不存在,请检查数据");
				}
				if ("3".equals(register.getReviewState())) {
					throw new ZAException(ZAErrorCode.ZA_ERROR, "Id为" + register.getId() + "的数据，已经退款，无法导入成绩！");
				}
				gr.setGrade(DictUtils.getDictValue(gr.getGrade(), "handler_grade", null));
				String refereeNameEn = showRefereeService.findHandlerRefereeNameEn(gr.getReferee().trim());
				if (StringUtils.isBlank(refereeNameEn)) {
					throw new ZAException(ZAErrorCode.ZA_ERROR, "该" + gr.getReferee() +"审查员不存在,请检查后再试！");
				}
				gr.setReferee(refereeNameEn);
				/*
				 * if (gr.getSchoolNameCn().equals("")&&gr.getSchoolNameCn()==null) {
				 * gr.setSchoolNameCn("无"); }
				 * gr.setShowDogBreed("".equals(gr.getShowDogBreed())?"无":gr.getShowDogBreed());
				 */
				gr.setShowLevel(DictUtils.getDictValue(gr.getShowLevel(), "handler_test_level", "0"));
				gr.setLeaveCancel(DictUtils.getDictValue(gr.getLeaveCancel(), "yes_no", "0"));
				saveGrade(gr);
			}
		} catch (Exception e) {
			throw new Exception(e);
		}

	}

	/**
	 * 报名信息导出
	 * 
	 * @throws IOException
	 * @Author chaixueteng
	 * @2016年8月19日上午11:44:04
	 */
	public void export(HandlerRegister handlerRegister, HttpServletResponse response) throws IOException {
		List<HandlerRegister> hrList = dao.getRegisterList(handlerRegister);
		for (HandlerRegister hr : hrList) {
			hr.setGender("male".equals(hr.getGender()) ? "男" : "女");
			hr.setPaymentState("2".equals(hr.getPaymentState()) ? "已缴费" : "未缴费");
			hr.setDelFlag("0".equals(hr.getDelFlag()) ? "未删" : "已删");
			hr.setShowLevel(DictUtils.getDictLabel(hr.getShowLevel(), "groomer_test_level", ""));
			hr.setLeaveCancel("0".equals(hr.getLeaveCancel()) ? "" : "是");
			hr.setGrade(DictUtils.getDictLabel(hr.getGrade(), "handler_grade", ""));
		}
		new ExportExcel("", HandlerRegister.class, 1).setDataList(hrList).write(response, "报名信息表.xlsx").dispose();

	}

	/**
	 * 确认到场
	 * 
	 * @Author chaixueteng
	 * @2016年8月24日上午10:27:33
	 */
	@Transactional(readOnly = false)
	public void match(String id, String type, String remarks) {
		HandlerRegister handlerRegister = new HandlerRegister(id);
		if ("success".equals(type)) {
			handlerRegister.setShowLeave("1");
		} else {
			handlerRegister.setShowLeave("2");
			handlerRegister.setRemarks(remarks);
		}
		dao.match(handlerRegister);
	}

	/**
	 * 保存成绩,生成资格证书
	 * 
	 * @throws ZAException
	 * @Author chaixueteng
	 * @2016年7月22日下午4:52:07
	 */
	@Transactional(readOnly = false)
	public void saveGrade(HandlerRegister handlerRegister) throws ZAException {
		Date takeCertificateDate = handlerRegister.getTakeCertificateDate();
		String grade = handlerRegister.getGrade();
		String id = handlerRegister.getId();
		HandlerRegister hrs = super.get(id);
		String name = hrs.getHandlerShow().getShowName();
		if (grade != null) {
			dao.inputGrade(handlerRegister);
			if ("12".equals(hrs.getHandlerShow().getShowType())) {
				// 考试通过才会有资格证书
				if ("2".equals(grade) || "3".equals(grade) || "7".equals(grade) || "8".equals(grade)) {
					HandlerQualificationCertificate hqc = new HandlerQualificationCertificate();
					hqc.preInsert();
					hqc.setCertificateCode(null);
					hqc.setRegisterId(id);
					hqc.setMemberCode(handlerRegister.getMemberCode());
					hqc.setPrintState("0");
					hqc.setReviewState("0");
					hqc.setPaymentState("1");
					hqc.setProccessState("0");
					hqc.setTakeCertificateDate(takeCertificateDate);
					hqc.setReviewer(handlerRegister.getReferee());
					String level = handlerRegister.getShowLevel();
					hqc.setCertificateLevelEn(level);
					if (level.trim().equals("MASTER")) {
						hqc.setCertificateLevelCn("教师");
					} else {
						hqc.setCertificateLevelCn(level);
					}
					//训练师类型证书
					hqc.setCertificateType(Constants.STRING_NUM_ONE);
					if (handlerQualificationCertificateDao.eqCertificateLevel(handlerRegister.getMemberCode(), hqc.getCertificateLevelEn(), hqc.getCertificateType())
							.size() <= 0) {
						handlerQualificationCertificateService.saveCertificate(hqc);
					}
					remindService.addRemind("您的" + name + "考试通过，请在180天之内申请领取资格证书，过期无效。",
							handlerRegister.getMemberCode());
					remindService.addMemberRemind("您的" + name + "考试通过，请在180天之内申请领取资格证书，过期无效。",
							handlerRegister.getMemberCode());
				} else {
					remindService.addRemind("您的" + name + "考试未通过，再接再厉哦。", handlerRegister.getMemberCode());
					remindService.addMemberRemind("您的" + name + "考试未通过，再接再厉哦。", handlerRegister.getMemberCode());

				}
			} else if (!"9".equals(hrs.getHandlerShow().getShowType()) && !"13".equals(hrs.getHandlerShow().getShowType())) {
				// 考试通过才会有资格证书
				if (!"0".equals(grade) && !"1".equals(grade)) {
					HandlerQualificationCertificate hqc = new HandlerQualificationCertificate();
					hqc.preInsert();
					hqc.setCertificateCode(null);
					hqc.setRegisterId(id);
					hqc.setMemberCode(handlerRegister.getMemberCode());
					hqc.setPrintState("0");
					hqc.setReviewState("0");
					hqc.setPaymentState("1");
					hqc.setProccessState("0");
					hqc.setTakeCertificateDate(takeCertificateDate);
					hqc.setReviewer(handlerRegister.getReferee());
					String level = handlerRegister.getShowLevel();
					hqc.setCertificateLevelEn(level);
					if (level.trim().equals("MASTER")) {
						hqc.setCertificateLevelCn("教师");
					} else {
						hqc.setCertificateLevelCn(level);
					}
					//牵犬师类型证书
					hqc.setCertificateType(Constants.STRING_ZERO);
					handlerQualificationCertificateService.saveCertificate(hqc);
					remindService.addRemind("您的" + name + "考试通过，请在180天之内申请领取资格证书，过期无效。",
							handlerRegister.getMemberCode());
					remindService.addMemberRemind("您的" + name + "考试通过，请在180天之内申请领取资格证书，过期无效。",
							handlerRegister.getMemberCode());
				} else {
					remindService.addRemind("您的" + name + "考试未通过，再接再厉哦。", handlerRegister.getMemberCode());
					remindService.addMemberRemind("您的" + name + "考试未通过，再接再厉哦。", handlerRegister.getMemberCode());

				}
			}
		}
	}

	/**
	 * 报名未审核数
	 * 
	 * @Author chaixueteng
	 * @2016年8月31日下午2:50:58
	 */
	public int getRegisterCount() {
		return dao.getRegisterCount();
	}

	/**
	 * 重复报名验证
	 * 
	 * @Author chaixueteng
	 * @2016年9月6日下午5:38:11
	 */
	public String registerCheck(String memberCode, String showCode) {
		List<HandlerRegister> list = dao.getByRegister(memberCode, showCode);
		if (list.size() > 0) {
			return "{\"rc\":true}";
		} else {
			return "{\"rc\":false}";
		}
	}

	public String registerExaminerCheck(String memberCode, String showCode) {
		List<HandlerRegister> list = dao.registerExaminerCheck(memberCode, showCode);
		if (list.size() > 0) {
			return "{\"rc\":true}";
		} else {
			return "{\"rc\":false}";
		}
	}

	/**
	 *
	 * @description: 牵犬师活动报名业务校验
	 * @author: laiguanglong
	 * @date: 2016年9月19日 上午10:11:23
	 */
	public void validateExaminerBusiness(HandlerRegister po) {
		if (StringUtils.isEmpty(po.getShowLevel())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "活动级别为空");
		}

		if (StringUtils.isEmpty(po.getShowGroup()) && "4".equals(po.getShowLevel())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "活动组别为空");
		}

		// 校验重复订单
		HandlerRegister example = new HandlerRegister();
		example.setMemberCode(po.getMemberCode());
		example.setShowCode(po.getShowCode());
		example.setReviewState("1");
		String showCode = po.getShowCode();
		HandlerShow show = handlerShowService.getShow(showCode);
		Integer max = 0, registerNum = 0;
		if (null != show.getMaxNumber()) {
			max = show.getMaxNumber();
		}
		if (null != show.getRegisterNumber()) {
			registerNum = show.getRegisterNumber();
		}
		if (max <= registerNum) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "报名人数已达上限");
		}
		Date registerEndTime = show.getRegisterEndTime();
		if (registerEndTime.getTime() <= new Date().getTime()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "活动报名已截止");
		}
		List<HandlerRegister> list = findList(example);
		if (list.size() != 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您已报名过该场活动，请勿重复报名！");
		}
	}

	public void validateBusiness(HandlerRegister po, HandlerShow show) {
		// 校验重复订单
		HandlerRegister example = new HandlerRegister();
		example.setMemberCode(po.getMemberCode());
		example.setShowCode(po.getShowCode());
		Date registerEndTime = show.getRegisterEndTime();
		if (registerEndTime.getTime() <= new Date().getTime()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "活动报名已截止");
		}
	/*	if ("app".equals(source)) {
			example.setReviewStateExclud("3");
		}*/
		List<HandlerRegister> list = findList(example);
		if (list.size() != 0) {
			String paymentState = list.get(0).getPaymentState();
			if ("2".equals(paymentState)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请勿重复报名");
			} else {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "有未缴费订单");
			}
		}
	}

	/**
	 *
	 * @Description：获取登录人的历史报名信息
	 * @author: zhuoHeng
	 * @version: 2016年12月14日 上午9:34:27
	 */
	public List<HandlerRegister> getHandlerRegister(String memberCode) {
		List<HandlerRegister> list = dao.getHandlerRegister(memberCode);
		return list;
	}

	public List<HandlerRegister> getExaminerHandlerRegister(String memberCode) {
		List<HandlerRegister> list = dao.getExaminerHandlerRegister(memberCode);
		return list;
	}

	/**
	 *
	 * @Description：重置美容报名审核状态（宠爱王国使用） @author: zhuoHeng
	 * @version: 2016年12月15日 上午10:08:59
	 */
	@Transactional(readOnly = false)
	public void changeReviewState(String id) {
		dao.changeReviewState(id);
	}

	@Transactional(readOnly = false)
	public void changeExaminerReviewState(String id) {
		dao.changeExaminerReviewState(id);
	}

	/**
	 * 报名信息上传证件照
	 * 
	 * @Author chaixueteng
	 * @2016年12月16日上午10:21:04
	 */
	@Transactional(readOnly = false)
	public void toReImage(HandlerRegister handlerRegister) throws Exception {
		try {
			String memberCode = handlerRegister.getMemberCode();
			String state = handlerRegister.getReviewState();
			String remarks = handlerRegister.getReviewRemarks();
			String avatar = handlerRegister.getAvatar();
			if (StringUtils.isBlank(avatar)) {
				throw new ZAException(-1, "请上传正确的照片!");
			}
			String id = handlerRegister.getId();
			HandlerRegister hr = get(id);
			SysContext sysContext = new SysContext(hr.getPaymentState(), hr.getReviewState(), hr.getProccessState());
			HandlerRegister HR = new HandlerRegister(id);
			HR.setAvatar(avatar);
			if ("1".equals(state)) {
				HR.setReviewState("1");
				HR.setReviewTime(new Date());
				sysContext.confirmSuccess(sysContext, "报名证件照", hr.getMemberCode(), "handler_register", hr.getId(),
						hr.getRunningNumber(), (str) -> {

						});
				// 审核通过 同步会员证件照
				memberService.synImage(memberCode, avatar);
			} else {
				HR.setReviewState("2");
				HR.setReviewTime(new Date());
				HR.setReviewRemarks(remarks);
				sysContext.confirmFail(sysContext, "报名证件照", remarks, hr.getMemberCode(), "handler_register", hr.getId(),
						hr.getRunningNumber(), (str) -> {

						});
			}
			dao.saveImage(HR);
			String reviewState = HR.getReviewState();
			if ("1".equals(reviewState)) {
				remindService.addMemberRemind("您报名的活动编号为:" + hr.getShowCode() + "的参赛证件照审核已成功。", memberCode);
			} else {
				remindService.addMemberRemind(
						"您报名的活动编号为:" + hr.getShowCode() + "的参赛证件照审核未通过。未通过原因:" + HR.getReviewRemarks(), memberCode);
			}
		} catch (Exception e) {
			throw new ZAException(-1, "审核失败!");
		}
	}

	/**
	 * @description: 培训部活动报名业务校验
	 * @author: hjx
	 */
	public void validateBusiness(HandlerRegister po, HandlerShow handlerShow, String source) {

		Boolean flag = Boolean.FALSE;
		for (String level : handlerShow.getTestLevel().split(",")) {
			if (level.equals(po.getShowLevel())) {
				flag = Boolean.TRUE;
			}
		}
		if (!flag) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "本场活动无此报名级别！");
		}
		// 校验重复订单
		HandlerRegister example = new HandlerRegister();
		example.setMemberCode(po.getMemberCode());
		example.setShowCode(po.getShowCode());
		if ("app".equals(source)) {
			example.setReviewStateExclud("3");
		}
		List<HandlerRegister> list = findList(example);
		if (!CollectionUtils.isEmpty(list)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员" + po.getMemberCode() + "已报名活动" + po.getShowCode());
		}

		if ("app".equals(source)) {
			Date registerEndTime = handlerShow.getRegisterEndTime();
			if (registerEndTime.getTime() <= new Date().getTime()) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "活动报名已截止");
			}
			if ("12".equals(handlerShow.getShowType()) || "13".equals(handlerShow.getShowType())) {
				if (StringUtils.isBlank(po.getShowLevel()) || "none".equals(po.getShowLevel())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "报名级别不能为空！");
				}
			}
		}
		if ("oa".equals(source)) {
			//伴侣犬训练师资格证书
			if ("12".equals(handlerShow.getShowType())) {
				if (StringUtils.isBlank(po.getShowLevel()) || "none".equals(po.getShowLevel())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "报名级别不能为空！");
				}
				HandlerQualificationCertificate partnerDogLevel = handlerQualificationCertificateService.getPartnerDogLevel(po.getMemberCode());
				if (Objects.isNull(partnerDogLevel)) {
					if (!po.getShowLevel().equals("C")) {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "报名级别有误，请核对好后重试！");
					}
				} else {
					logger.info("报名校验，根据会员号查询伴侣犬资格证书信息 : {}", JSONObjectUtils.toJsonString(partnerDogLevel));
					String level = autoSelectLevel(partnerDogLevel.getCertificateLevelEn());
					if (!po.getShowLevel().equals(level)) {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "报名级别有误，请核对好后重试！");
					}
				}
			}

			//伴侣犬训练师大赛
			if ("13".equals(handlerShow.getShowType())) {
				if (StringUtils.isBlank(po.getShowLevel()) || "none".equals(po.getShowLevel())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "报名级别不能为空！");
				}
				HandlerQualificationCertificate partnerDogLevel = handlerQualificationCertificateService.getPartnerDogLevel(po.getMemberCode());
				logger.info("报名校验，根据会员号查询伴侣犬资格证书信息 : {}", JSONObjectUtils.toJsonString(partnerDogLevel));
				if (Objects.isNull(partnerDogLevel)) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "需要拥有该等级的资格证书！");
				}
				if ("MASTER".equals(partnerDogLevel.getCertificateLevelEn())) {

				} else if ("A".equals(partnerDogLevel.getCertificateLevelEn())) {
					if ("MASTER".equals(po.getShowLevel())) {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "需要拥有该等级的资格证书！");
					}
				} else if ("B".equals(partnerDogLevel.getCertificateLevelEn())) {
					if ("MASTER".equals(po.getShowLevel()) || "A".equals(po.getShowLevel()) ) {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "需要拥有该等级的资格证书！");
					}
				} else if ("C".equals(partnerDogLevel.getCertificateLevelEn())) {
					if (!"C".equals(po.getShowLevel())) {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "需要拥有该等级的资格证书！");
					}
				}
			}
		}

	}
	/**
	 *
	 * @Description：获取登录人的历史报名信息(训练师)
	 * @author: hjx
	 */
	public List<HandlerRegister> getHandlerTrainerRegister(String memberCode) {
		List<HandlerRegister> list = dao.getHandlerTrainerRegister(memberCode);
		return list;
	}
}