package com.cku.oa.finance.web;


import com.cku.oa.finance.dao.SaPaymentDetailTotalDao;

import com.cku.oa.finance.entity.MemberAccount;

import com.cku.oa.finance.dao.MemberAccountDao;
import com.cku.oa.finance.entity.MemberAccount;

import com.cku.oa.finance.entity.MemberBalance;
import com.cku.oa.finance.service.MemberBalanceService;
import com.cku.oa.finance.service.PaymentOnAccountService;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.user.Member;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: lyy
 * Date: 2016/7/27
 * Time: 11:59
 * 会员余额controller
 */
@Controller
@RequestMapping(value = "${adminPath}/finance/memberBalance")
public class MemberBalanceController  extends BaseController {
    @Autowired
    private MemberBalanceService memberBalanceService;
    @Autowired
	private PaymentOnAccountService paymentOnAccountService;
    @Autowired
    private SaPaymentDetailTotalDao saPaymentDetailTotalDao;

    @Autowired
    private MemberDao memberDao;
    @Autowired
    private MemberAccountDao memberAccountDao;

    @RequiresPermissions("finance:memberBalance:view ")
    @RequestMapping(value = {"getListByMemberCode", ""})
    public String getListByMemberCode(MemberBalance memberBalance, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<MemberBalance> page=null;
        String totalMemberBalance="";
        BigDecimal result1=new BigDecimal(0);
        if(null!=memberBalance.getEndPaymentTime()){
            Calendar cal=Calendar.getInstance();
            cal.setTime( memberBalance.getEndPaymentTime());
            cal.add(Calendar.HOUR,23);
            cal.add(Calendar.MINUTE,59);
            cal.add(Calendar.SECOND,59);
            memberBalance.setEndPaymentTime(cal.getTime());
            //查询当前余额
            totalMemberBalance= memberBalanceService.totalMemberBalance(memberBalance);
            //
            MemberAccount c1=new MemberAccount();
           /* c1.setMemberCode(memberBalance.getMemberCode());*/
            c1.setPaymentTimeStart(memberBalance.getEndPaymentTime());
            double chongZhiMoney1=memberAccountDao.getChongZhiMoney(c1);
            //第三部，查询截止订单日期  用户用 用户余额支付的
            double hufeiMoney1=memberAccountDao.getHuaMoney(c1);
            // 进行加减运算
            BigDecimal b11 = new BigDecimal(totalMemberBalance);
            BigDecimal b22 = new BigDecimal(chongZhiMoney1);
            BigDecimal b33 = new BigDecimal(hufeiMoney1);
             result1= b11.subtract(b22).add(b33).setScale(2,BigDecimal.ROUND_HALF_UP);

            page= memberBalanceService.getListByMemberCodePageHistory(new Page<MemberBalance>(request, response), memberBalance);
            //遍历查余额
            for(MemberBalance m:page.getList()){
                //查询当前余额
                Member member=memberDao.getByMemberCode(m.getMemberCode());
                //查询 截止订单日期 用户充值金额。
                MemberAccount c=new MemberAccount();
                c.setMemberCode(m.getMemberCode());
                c.setPaymentTimeStart(memberBalance.getEndPaymentTime());
                double chongZhiMoney=memberAccountDao.getChongZhiMoney(c);
                //第三部，查询截止订单日期  用户用 用户余额支付的
                double hufeiMoney=memberAccountDao.getHuaMoney(c);
                // 进行加减运算
                BigDecimal b1 = new BigDecimal(member.getAccountBalance());
                BigDecimal b2 = new BigDecimal(chongZhiMoney);
                BigDecimal b3 = new BigDecimal(hufeiMoney);
                BigDecimal result= b1.subtract(b2).add(b3).setScale(2,BigDecimal.ROUND_HALF_UP);
                m.setMemberBalance(result.toString());
            }
        }else{
          totalMemberBalance= memberBalanceService.totalMemberBalance(memberBalance);
          page= memberBalanceService.getListByMemberCodePage(new Page<MemberBalance>(request, response), memberBalance);
        }
        //查询未转入的资金挂账余额
        String totalMoney =  paymentOnAccountService.findTotalMoney();
//        查询未完成业务余额
        String allUncompletedIncome = saPaymentDetailTotalDao.getAllUncompletedIncome();
        List<MemberBalance> list = page.getList();
        for(MemberBalance data : list){
            data.setTotalIncome(new BigDecimal(data.getMemberBalance()).add(new BigDecimal(data.getUncompletedIncome()))+"");
        }
        MemberBalance mb = new MemberBalance();
        mb.setMemberName("资金挂账");
        mb.setMemberCode("资金挂账");
        mb.setMemberBalance(totalMoney);
        mb.setUncompletedIncome("0");
        mb.setTotalIncome(totalMoney);
        list.add(mb);
        page.setList(list);
        model.addAttribute("page", page);
        BigDecimal total= null;
        if(null!=totalMemberBalance){
        	total = new BigDecimal(result1.toString()).add(new BigDecimal(totalMoney));
        }else{
//            total = Double.parseDouble(totalMoney);
            total = new BigDecimal(totalMoney);
        }

        model.addAttribute("totalMemberBalance",total);
        if(StringUtils.isNotBlank(allUncompletedIncome)){
            model.addAttribute("allUncompletedIncome",allUncompletedIncome);
            model.addAttribute("totalIncome",new BigDecimal(allUncompletedIncome).add(total)+"");
        }else{
            model.addAttribute("allUncompletedIncome",0);
            model.addAttribute("totalIncome",total);
        }
        return "oa/finance/memberBalanceDetailList";
    }
    @RequiresPermissions("finance:memberBalance:view")
    @RequestMapping(value = "getListStatistics")
    public String getListStatistics(MemberBalance memberBalance,HttpServletRequest request, HttpServletResponse response, Model model) {
        List<MemberBalance> list = memberBalanceService.getListStatistics(memberBalance);
        model.addAttribute("list", list);
        BigDecimal var0 = new BigDecimal(list.get(0).getTotalPrice());
        BigDecimal var1 = new BigDecimal(list.get(1).getTotalPrice());
        BigDecimal inner1 = var0.subtract(var1);
        model.addAttribute("count",inner1.toString());
        return "oa/finance/memberBalanceStatisticsList";
    }
    @RequestMapping(value = "export")
    public String export(MemberBalance memberBalance, HttpServletResponse response, RedirectAttributes redirectAttributes) {
        try {
            Calendar cal=Calendar.getInstance();
            cal.setTime( memberBalance.getEndPaymentTime());
            cal.add(Calendar.HOUR,23);
            cal.add(Calendar.MINUTE,59);
            cal.add(Calendar.SECOND,59);
            memberBalance.setEndPaymentTime(cal.getTime());
            memberBalanceService.export(memberBalance,response);
        } catch (Exception e) {
            addMessage(redirectAttributes, "导出资格收支明细失败！失败信息："+e.getMessage());
        }
        return null;
    }
}
