/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.service;

import java.util.Date;
import java.util.List;

import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.finance.entity.PaymentOrderProject;
import com.cku.oa.finance.dao.PaymentOrderProjectDao;

/**
 * 订单项目Service
 * @author lyy
 * @version 2016-08-04
 */
@Service
@Transactional(readOnly = true)
public class PaymentOrderProjectService extends CrudService<PaymentOrderProjectDao, PaymentOrderProject> {

	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;

	public PaymentOrderProject get(String id) {
		return super.get(id);
	}
	
	public List<PaymentOrderProject> findList(PaymentOrderProject paymentOrderProject) {
		return super.findList(paymentOrderProject);
	}
	public List<PaymentOrderDetail> statistical(PaymentOrderProject paymentOrderProject){
		return paymentOrderDetailDao.statistical(paymentOrderProject.getId());
	}
	public List<PaymentOrderProject> findListById(PaymentOrderProject paymentOrderProject){
		return dao.findListById(paymentOrderProject);
	}
	public Page<PaymentOrderProject> findPage(Page<PaymentOrderProject> page, PaymentOrderProject paymentOrderProject) {
		return super.findPage(page, paymentOrderProject);
	}
	
	@Transactional(readOnly = false)
	public void save(PaymentOrderProject paymentOrderProject) {
//		String dateStr = DateUtils.formatDate(paymentOrderProject.getStartDate(),"yyMMdd");
//		paymentOrderProject.setName(dateStr+paymentOrderProject.getAddress());
		paymentOrderProject.setIsTop("0");
		paymentOrderProject.setIsValid("1");
		paymentOrderProject.setAddTime(new Date());
		super.save(paymentOrderProject);
	}
	
	@Transactional(readOnly = false)
	public void delete(PaymentOrderProject paymentOrderProject) {
		super.delete(paymentOrderProject);
	}
	@Transactional(readOnly = false)
	public void changeStatus(PaymentOrderProject paymentOrderProject){
		String type = paymentOrderProject.getType();

		if("isValid".equals(type)){
			paymentOrderProject.setIsValid("0".equals(paymentOrderProject.getIsValid())?"1":"0");
		}
		if("isTop".equals(type)){
			paymentOrderProject.setIsTop("0".equals(paymentOrderProject.getIsTop())?"1":"0");
		}
		dao.changeStatus(paymentOrderProject);
	}
	
}