/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import java.util.Date;

import com.thinkgem.jeesite.common.persistence.DataEntity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 犬只DNA存档采样包补寄Entity
 * 
 * @author Sunny
 * @version 2023-06-29
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class DogDnaArchiveReissueSampling extends DataEntity<DogDnaArchiveReissueSampling> {

	private static final long serialVersionUID = 1L;

	private String dnaArchiveId; // DNA存档ID

	private String samplingCode; // 采样包编号

	private String oldSamplingCode; // 原采样包编号

	private String operator; // 操作人

	private String runningNumber; // 流水号

	private Integer source; // 来源，0：业务补寄，1：录订单

	private Double price; // 价格

	private String paymentMemberCode; // 付款会员号

	private String paymentMemberName; // 付款会员名

	private String paymentState; // 付款的状态

	private Date paymentTime; // 付款时间
	
	private String businessIds; // 业务表ID
	
	private String chargingItemId; // 收费项ID
	
	private DogDnaArchive dogDnaArchive; // 补寄对应的DNA存档记录

}