/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.dog.entity.DogPedigreeCertifiedChange;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 证书换发DAO接口
 * 
 * @author lgl
 * @version 2016-08-11
 */
@MyBatisDao
public interface DogPedigreeCertifiedChangeDao extends CrudDao<DogPedigreeCertifiedChange> {
	int listCount(DogPedigreeCertifiedChange dogPedigreeCertifiedChange);

	DogPedigreeCertifiedChange getByOverseasPedigreeCertified(String overseasPedigreeCertified);

	// 修改关联关系
	void updateByEn(@Param("pedigreeCertifiedCodeEn") String pedigreeCertifiedCodeEn,
			@Param("fmdogBreedCertifiedCode") String fmdogBreedCertifiedCode);

	// 生成配种证明添加到证书焕发里
	void updateFm(@Param("fmdogBreedCertifiedCode") String fmdogBreedCertifiedCode, @Param("changeId") String changeId);

	// 得到外国证书号
	List<DogPedigreeCertifiedChange> getOverCertified();

	// 根据芯片号查找国外证书记录
	DogPedigreeCertifiedChange getByDogChipCode(@Param("dogChip") String dogChip);

	// 更具国外证书号查询
	DogPedigreeCertifiedChange getByPedigreeCertified(String overseasPedigreeCertified);

	DogPedigreeCertifiedChange getByDogIdOrDogChip(@Param("dogId") String dogId, @Param("dogChip") String dogChip);
}