/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.breeder.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 繁育人BannerEntity
 *
 * @author lgl
 * @version 2017-10-11
 */
public class Banner extends DataEntity<Banner> {

    private static final long serialVersionUID = 1L;
    private String module;        // 模块
    private String title;        // 标题
    private String img;        // 背景图片
    private String url;        // 跳转地址
    private String type;        // 跳转类型：0url
    private String visibleFlag;        // 是否可见。0不可见；1可见
    private Date startTime;        // 显示开始时间
    private Date endTime;        // 显示结束时间
    private String sort;        // 排序

    private String programId;       //小程序Id

    public Banner() {
        super();
    }

    public Banner(String id) {
        super(id);
    }

    @Length(min = 1, max = 50, message = "模块长度必须介于 1 和 50 之间")
    public String getModule() {
        return module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    @Length(min = 1, max = 100, message = "标题长度必须介于 1 和 100 之间")
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Length(min = 1, max = 50, message = "背景图片长度必须介于 1 和 50 之间")
    public String getImg() {
        return img;
    }

    public void setImg(String img) {
        this.img = img;
    }

    @Length(min = 1, max = 300, message = "跳转地址长度必须介于 1 和 300 之间")
    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Length(min = 1, max = 2, message = "跳转类型：0url长度必须介于 1 和 2 之间")
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Length(min = 1, max = 1, message = "是否可见。0不可见；1可见长度必须介于 1 和 1 之间")
    public String getVisibleFlag() {
        return visibleFlag;
    }

    public void setVisibleFlag(String visibleFlag) {
        this.visibleFlag = visibleFlag;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @NotNull(message = "显示开始时间不能为空")
    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @NotNull(message = "显示结束时间不能为空")
    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Length(min = 1, max = 3, message = "排序必须介于 1 和 3 之间")
    public String getSort() {
        return sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getProgramId() {
        return programId;
    }

    public void setProgramId(String programId) {
        this.programId = programId;
    }
}