<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>修改绑定关系</title>
	<meta name="decorator" content="default"/>
	
	<style type="text/css">
		body {
			min-height:300px;
		}
	</style>
	<script type="text/javascript">
	function bindRelation(){
 		var params = {"id":"${member.id}","memberCode":"${member.memberCode}"};
 		params.loginMobile = $.trim($("#loginMobile").val());
 		params.loginName = $.trim($("#loginName").val());
 		if($.trim(params.id) == 0){
 			top.layer.msg("请输入会员号！");
 			return false;
 		}
 		if(params.memberCode != $("#memberCode").val()){
 			top.layer.msg("会员号与查询会员号不一致，更换会员号后请点击查询重新载入！");
 			return false;
 		}
		$.ajax({
		  type:"post",
		  url:"${ctx}/sys/user/member/edit/bind/relation",
		  data:params,
		  dataType:"json",
		  success:function(data){
			  if(data.rc == 0){
				  top.layer.msg(data.data);
					//1.5秒之后刷新页面
				   setTimeout(function(){
						if(parent.document.getElementById("mainFrame").contentWindow.bindUserCallback != undefined){
							parent.document.getElementById("mainFrame").contentWindow.bindUserCallback(data);
						}
						var index = parent.layer.getFrameIndex(window.name); //获取窗口索引
						parent.layer.close(index);
				   },1500);
			  }
			  else{
				  top.layer.msg(data.msg);	  
			  }
		  }
		 })
		return false;
	}
	
	function cancel(){
		var index = parent.layer.getFrameIndex(window.name); //获取窗口索引
		parent.layer.close(index);
	}
	
	function findMember(){
		var memberCode = $.trim($("#memberCode").val());
		if(memberCode.length==0){
			//$.jBox.alert("请输入会员号！","提示");
			top.layer.msg("请输入会员号！");
			return;
		}
		window.location.href = "${ctx}/sys/user/member/edit/bind/form?memberCode="+memberCode;
	}
	
	function unbund(fieldId,fieldName){
		$.jBox.confirm("确认要解绑"+fieldName+"吗？","系统提示",function(v,h,f){
			if(v=="ok"){
				if(fieldId == "loginMobile"){
					$("#loginMobile").val("");
					$("#loginMobile").removeAttr("readonly");
					$("#btnUnbundLoginMobile").hide();
				}
				else{
					$("#loginName").val("");
					$("#loginMobile").val("");
					$("#loginName").removeAttr("readonly");
					$("#loginMobile").removeAttr("readonly");
					$("#btnUnbundLoginName").hide();
					$("#btnUnbundLoginMobile").hide();
				}
			}
		},{buttonsFocus:1});
		
	}
	
	function initLoginName(value){
		if($.trim($("#loginName").val()) == 0){
			$("#loginName").val(value)
		}
	}
</script>
</head>
<body>
	<div id="bindForm" style="padding-top:20px;">
		<form id="inputForm"  action="#" method="post" class="form-horizontal">
			<div class="control-group">
				<label class="control-label">会员编号：</label>
				<div class="controls">
					<input type="text" id="memberCode" name="memberCode" class="input-xlarge" value="${member.memberCode}"/>
					<span class="help-inline" style="margin-right:5px;"><font color="red">*</font></span>
					<button class=" btn btn-primary" onclick="findMember();return false;">查询</button>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">会员姓名：</label>
				<div class="controls">
					<input type="text" id="name" name="name" class="input-xlarge " value="${member.name}" readonly="readonly"/>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">绑定登录手机号：</label>
				<div class="controls">
					<c:if test="${empty member.loginMobile}">
						<input type="text" id="loginMobile" name="loginMobile" maxlength="11" onblur="initLoginName(this.value);" value="${member.loginMobile}" class="input-xlarge required"/>
					</c:if>
					<c:if test="${!empty member.loginMobile}">
						<input type="text" id="loginMobile" name="loginMobile" maxlength="11" value="${member.loginMobile}" class="input-xlarge required" readonly="readonly"/>
						<button id="btnUnbundLoginMobile"  type="button" class=" btn btn-primary" onclick="unbund('loginMobile','登录手机号');">解绑</button>
					</c:if>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">网站登录账号：</label>
				<div class="controls">
					<c:if test="${empty member.loginName}">
						<input type="text" id="loginName" name="loginName" maxlength="11" value="${member.loginName}" class="input-xlarge"/>
					</c:if>
					<c:if test="${!empty member.loginName}">
						<input type="text" id="loginName" name="loginName" maxlength="11" value="${member.loginName}" class="input-xlarge" readonly="readonly"/>
						<button id="btnUnbundLoginName" type="button" class=" btn btn-primary" onclick="unbund('loginName','网站登录账号');">解绑</button>
					</c:if>
				</div>
			</div>
			<div class="control-group" style="text-align:left;">
				<div class="help-inline"><font color="red">1、录入的网站登录账号在系统不存在时，会以录入的账号创建登录账号，密码与重置密码一致</font> </div><br>
				<div class="help-inline"><font color="red">2、新创建网站账号应录入手机号</font> </div><br>
				<div class="help-inline"><font color="red">3、解绑网站账号，同时会解绑登录手机号，换绑账号，请先解绑在录入要绑定的账号或手机号</font> </div><br>
				<div class="help-inline"><font color="red">4、登录手机号，绑定不同身份的会员，要满足会员身份证一致</font> </div>
			</div>
			<center>
			<button class="btn btn-primary" style="width:100px;" onclick="bindRelation();return false;">确定</button> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
			<button class="btn btn-default" style="width:100px;" onclick="cancel();return false;">取消</button></center>
		</form>
	</div>
</body>
</html>