<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>保存配置成功管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/sys/coupon/sysCouponDef/">保存配置成功列表</a></li>
		<shiro:hasPermission name="sys:coupon:sysCouponDef:edit"><li><a href="${ctx}/sys/coupon/sysCouponDef/form">保存配置成功添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="sysCouponDef" action="${ctx}/sys/coupon/sysCouponDef/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>优惠劵名称</th>
				<th>参展券类型</th>
				<th>面值</th>
				<th>时效</th>
				<th>用于对象</th>
				<th>修改时间</th>
				<th>备注信息</th>
				<shiro:hasPermission name="sys:coupon:sysCouponDef:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="sysCouponDef">
			<tr>
				<td>
					${sysCouponDef.couponName}
				</td>
				<td>
					${sysCouponDef.couponType}
				</td>
				<td>
					${sysCouponDef.facePrice}
				</td>
				<td>
					${sysCouponDef.effectivePeriod}
				</td>
				<td>
					${sysCouponDef.explains}
				</td>
				<td><a href="${ctx}/sys/coupon/sysCouponDef/form?id=${sysCouponDef.id}">
					<fmt:formatDate value="${sysCouponDef.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</a></td>
				<td>
					${sysCouponDef.remarks}
				</td>
				<shiro:hasPermission name="sys:coupon:sysCouponDef:edit"><td>
    				<a href="${ctx}/sys/coupon/sysCouponDef/form?id=${sysCouponDef.id}">修改</a>
					<a href="${ctx}/sys/coupon/sysCouponDef/delete?id=${sysCouponDef.id}" onclick="return confirmx('确认要删除该保存配置成功吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>