<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>香港赛事成绩表管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
		
		});
		//悬浮提示插件
		$(document).tooltip();
		function btnRefreshRanking(year){
				top.$.jBox.confirm("确认要刷新该年份排行榜吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						loading('正在刷新，请稍等...');
						 $.ajax({
								type: "GET",
				                dataType:"json",
				                url:"${ctx}/results/showResultsHk/rankingByYear?year="+year,
				                async: true,
				                error: function(request, textStatus, errorThrown) {
				                	closeLoading();
				                    alert("请求失败!");
				                   
				                },
				                success: function(data) {
				                	if(data.rc == 1){
										closeLoading();
										alert("统计失败："+data.msg);
				                	}else{
				                		 closeLoading();
				                		 alert("统计成功！");
				                		 $("#searchForm").submit();
				                	}
				                }
							});
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
		};
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li ><a href="${ctx}/results/showResultsHk/">香港赛事成绩表列表</a></li>
		<shiro:hasPermission name="results:showResultsHk:edit"><li><a href="${ctx}/results/showResultsHk/form">香港赛事成绩表添加</a></li></shiro:hasPermission>
		<shiro:hasPermission name="results:showResultsHk:edit"><li class="active"><a href="${ctx}/results/showResultsHk/ranking">香港积分榜统计</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="showResultsHk" action="${ctx}/results/showResultsHk/ranking" method="post" class="breadcrumb form-search">
		
		<ul class="ul-form">
			<li><label>年份：</label>
				<form:input path="year" htmlEscape="false" maxlength="4" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>年份</th>
				<th>上次统计时间</th>
				<shiro:hasPermission name="results:showResultsHk:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${list}" var="showResultsHk">
			<tr>
				<td>
					${showResultsHk.year}
				</td>
				<td>
					<fmt:formatDate value="${showResultsHk.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<shiro:hasPermission name="results:showResultsHk:edit"><td>
					<a onclick="btnRefreshRanking('${showResultsHk.year}')">统计本年</a>
					
					<%-- <a href="${ctx}/results/showResultsHk/rankingByYear?year=${year}" onclick="return confirmx('确认要统计本年排行榜吗？', this.href)">统计本年</a> --%>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>