<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展成绩播报管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/show/showReportInfo/">犬展成绩播报列表</a></li>
		<shiro:hasPermission name="show:showReportInfo:edit"><li><a href="${ctx}/show/showReportInfo/editForm">犬展成绩播报添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="showReportInfo" action="${ctx}/show/showReportInfo/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>犬展编号：</label>
				<form:input path="showCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>犬展编号</th>
				<th>犬展起止时间</th>
				<th>犬展结束时间</th>
				<th>浏览</th>
				<th>添加人</th>
				<th>添加时间</th>
				<shiro:hasPermission name="show:showReportInfo:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="showReportInfo">
			<tr>
				<td><a href="${ctx}/show/showReportInfo/form?id=${showReportInfo.id}">
					${showReportInfo.showCode}
				</a></td>
				<td>
						<fmt:formatDate value="${showReportInfo.startTime}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
						<fmt:formatDate value="${showReportInfo.endTime}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${showReportInfo.lookCount}
				</td>
				<td>
					${showReportInfo.createBy.name}
				</td>
				<td>
					<fmt:formatDate value="${showReportInfo.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					<a href="${ctx}/show/showReportInfo/form?id=${showReportInfo.id}">查看</a>
					<shiro:hasPermission name="show:showReportInfo:edit">
    				<a href="${ctx}/show/showReportInfo/editForm?id=${showReportInfo.id}">修改</a>
					<a href="${ctx}/show/showReportInfo/delete?id=${showReportInfo.id}" onclick="return confirmx('确认要删除该犬展成绩播报吗？', this.href)">删除</a>
				</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>