<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>会员统计报表管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
					form.submit();
				},
				rules:{
					memberEndDateStart:{
						required:true
					},
					isAdded:{
						required:true
					},
					memberEndDateEnd:{
						required:true
					}
				}, 
				 messages:{
					memberEndDateStart:{
						required:"开始时间不能为空"
					},
					isAdded:{
						required:"导出类型不能为空"
					},
					memberEndDateEnd:{
						required:"结束时间不能为空"
					}
				}, 
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<form:form id="inputForm" modelAttribute="member" action="${ctx}/report/reportMemberArea/memberExport" method="post" class="breadcrumb form-search">
		<sys:message content="${message}"/>		
		<ul class="ul-form">
			<div class="control-group">
				<label>导出类型：</label>
				<form:select path="isAdded" class="input-medium">
					<form:option value="0">新增</form:option>
					<form:option value="1">到期</form:option>
				</form:select>
			    <font color="red">*</font>
			</div>
			<div class="control-group">
				<label>开始时间：</label>
				<input name="memberEndDateStart" type="text"  maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${member.memberEndDateStart}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			    <font color="red">*</font>
			</div>
			<div class="control-group">
				<label>结束时间：</label>
				<input name="memberEndDateEnd" type="text"  maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${member.memberEndDateEnd}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			    <font color="red">*</font>
			</div>
			
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="导出"/></li>
		</ul>
	</form:form>
</body>
</html>