<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬舍所有人名称变更信息管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();

			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					save();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				},

			});
		});
		function save(){
			var frm = $("#inputForm");
			var dataPara = util.getFormJson(frm);
			$.ajax({
				url: '${ctx}/kennel/kennelRename/orderSave',
				type: 'POST',
				data: dataPara,
				success: function(data){
		 				if(data.rc==0){
 							alert("订单录入成功！");
 							parent.isYes = true;
 							parent.layer.closeAll();
 						}else{
 							alert("提交失败,错误信息："+data.msg);
 						} 
				}
			});
		}
		function closeLayer(){
			parent.isYes = false;
			parent.layer.closeAll();
		};
	</script>
</head>
<body>
	<form:form id="inputForm" modelAttribute="kennelRename" action="" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<form:hidden path="paymentChargingItemId"/>
		<form:hidden path="runningNumber"/>
		<sys:message content="${message}"/>	
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input path="memberCode" htmlEscape="false" maxlength="64" readonly="true" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员名称：</label>
			<div class="controls">
				<form:input path="member.name"  htmlEscape="false" maxlength="64" readonly="true" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员类别：</label>
			<div class="controls">
				<form:select path="member.memberType" class="input-small" disabled="true">
					<form:options items="${fns:getDictList('user_member_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员截止日期：</label>
			<div class="controls">
				<input  readonly="readonly"  type="text"  maxlength="20" class="input-medium  "
				value="<fmt:formatDate value="${kennelRename.member.memberEndDate}" pattern="yyyy-MM-dd"/>" />
			</div>
		</div>
		<div style = "clear:both;"></div>
		<div class="control-group">
			<label class="control-label">犬舍中文名：</label>
			<div class="controls">
				<form:input path="originalNameCn" htmlEscape="false" maxlength="100" readonly="true" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬舍英文名：</label>
			<div class="controls">
				<form:input path="originalNameEn" htmlEscape="false" maxlength="100" readonly="true" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">新犬舍中文名：</label>
			<div class="controls">
				<form:input path="newNameCn" htmlEscape="false" maxlength="100" required="true" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">新犬舍英文名：</label>
			<div class="controls">
				<form:input path="newNameEn" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>	
		<div class="control-group">
			<label class="control-label">新犬舍备用英文名：</label>
			<div class="controls">
				<form:input path="fciKennelBackup" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>	
		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary"  type="submit" value="保 存"/>&nbsp;
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="closeLayer()"/>
		</div>
		<div style = "clear:both;"></div>
	</form:form>
</body>
</html>