<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>鼻纹管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<form:form id="searchForm" modelAttribute="dogNose" action="${ctx}/dogNose/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
		    <li><label style="width: 140px">登记卡/血统证书号:</label>
                <form:input path="dogBirthCertificate.pedigreeCertified" htmlEscape="false" maxlength="64" class="input-medium"/>
            </li>
			<li><label>会员号/姓名:</label>
				<form:input path="member.memberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>

			<li><label>申请日期:</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${dogNose.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${dogNose.endCreateDate}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>鼻纹编号</th>
				<th>血统证书号</th>
				<th>登记卡编号</th>
				<th>犬主人</th>
				<th>登记时间</th>
				<th>鼻纹状态</th>
				<th>管理</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogNose">
			<tr>
				<td>

					<a href="${ctx}/dogNose/from?id=${dogNose.id}">${fns:escapeHtml(dogNose.noseCode) }</a>
					<%--<c:if test="${dogNose.delFlag=='1'}">${fns:escapeHtml(dogNose.noseCode) }</c:if>--%>
				</a></td>
				<td>
						${fns:escapeHtml(dogNose.dogBirthCertificate.pedigreeCertified) }

				</td>
				<td>
					${fns:escapeHtml(dogNose.dogBirthCertificate.birthCerRegCode)}
				</td>
				<td>
					${fns:escapeHtml(dogNose.member.name) }
				</td>
				<td>
					<fmt:formatDate value="${dogNose.createDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<c:if test="${dogNose.delFlag=='0'}">已通过</c:if>
					<c:if test="${dogNose.delFlag=='1'}">已注销</c:if>
				</td>
				<td>
					<c:if test="${dogNose.delFlag=='0'}"><a href="${ctx}/dogNose/edit?id=${dogNose.id}">编辑</a></c:if>
					<%--<a href="${ctx}/dogNose/from?id=${dogNose.id}">查看</a>--%>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>