<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>鼻纹管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">

	</script>
</head>
<body>

	<form:form id="inputForm"  action="${ctx}/dogNose/save" method="post" class="form-horizontal">
		<sys:message content="${message}"/>
		<div class="control-group" style="float: left">
			<label class="control-label">血统证书号：</label>
			<div class="controls">
                    ${fns:escapeHtml(dogNose.dogBirthCertificate.pedigreeCertified) }
			</div>
		</div>
        <div class="control-group">
            <label class="control-label">登记卡编号：</label>
            <div class="controls">
                    ${fns:escapeHtml(dogNose.dogBirthCertificate.birthCerRegCode) }
            </div>
        </div>
		<div class="control-group" style="float: left">
            <label class="control-label">犬主人：</label>
            <div class="controls">
                    ${fns:escapeHtml(dogNose.member.name) }
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">犬主人会员号：</label>
            <div class="controls">
                    ${fns:escapeHtml(dogNose.member.memberCode) }
            </div>
        </div>
		<div class="control-group" style="float: left">
            <label class="control-label">鼻纹编号：</label>
            <div class="controls">
                    ${fns:escapeHtml(dogNose.noseCode) }
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">登记时间：</label>
            <div class="controls">
                <fmt:formatDate value="${dogNose.createDate}" pattern="yyyy-MM-dd"/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">鼻纹状态：</label>

            <div class="controls" disabled="true">
                <select name="delFlag">
                    <option value="1" ${'1'==dogNose.delFlag?'selected':''} >已注销</option>
                    <option value="0" ${'0'==dogNose.delFlag?'selected':''}>已通过</option>
                </select>
            </div>

        </div>
        <div class="control-group">
            <label class="control-label">备注说明：</label>
            <div class="controls">
                <textarea name="remarks" htmlEscape="false"  rows="4" maxlength="255" class="input-xxlarge " disabled="true">${dogNose.remarks}</textarea>
            </div>
        </div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>