<%@ tag language="java" pageEncoding="UTF-8"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<%@ attribute name="name" type="java.lang.String" required="true" description="元素名称"%>
<%@ attribute name="value" type="java.lang.String" required="false" description="元素值"%>
<%@ attribute name="excludeValue" type="java.lang.String" required="false" description="排除元素值"%>
<%@ attribute name="type" type="java.lang.String" required="true" description="数据字典类型"%>
<%@ attribute name="cssClass" type="java.lang.String" required="false" description="样式表"%>
<%@ attribute name="readonly" type="java.lang.Boolean" required="false" description="是否只读"%>
<%@ attribute name="rangeItems" type="java.lang.String" required="false" description="可显示范围，逗号分隔"%>
<%@ attribute name="remarks" type="java.lang.String" required="false" description="备注信息"%>
<script type="text/javascript">
	$(document).ready(function() {
		if("${excludeValue}" != ""){
			var excludeValueArr = "${excludeValue}".split(",");
			excludeValueArr.forEach(function (item,index,array){
				$("#${name}"+item).hide();
			});
		}
	});
</script>
<c:forEach items="${fns:getDictList(type)}" var="item" varStatus="status">
	<c:if test="${empty rangeItems}">
		<span id="${name}${item.value}">
			<input id="${name}${status.index}" name="${name}" type="radio" value="${item.value}" ${value eq item.value ? "checked":""} class="${cssClass} ${readonly?' disabled':''}">
			<label for="${name}${status.index}">${item.label}</label>
		</span>
	</c:if>
 	<c:if test='${not empty rangeItems && fns:splitContains(rangeItems,item.value,",")}'>
		<span id="${name}${item.value}">
			<input id="${name}${status.index}" name="${name}" type="radio" value="${item.value}" ${value eq item.value ? "checked":""} class="${cssClass} ${readonly?' disabled':''}">
			<label for="${name}${status.index}">${item.label}</label>
		</span>
	</c:if>
</c:forEach>
<c:if test="${not empty remarks}">
	<label style="color:red;">&nbsp;&nbsp;${remarks}</label>
</c:if>