package com.cku.restful.v2.order.vo.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 下单相关信息
 *
 * @author yuanshuai
 * @date 2023年6月15日17:50:49
 */
@Data
@ApiModel
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode
public class OrderApplyInfoResponse implements Serializable {
    private static final long serialVersionUID = 3618611308287091467L;

    @ApiModelProperty("业务ID")
    private String businessId;

    @ApiModelProperty("商品信息")
    private List<OrderSkuResponse> skuList;

    @ApiModelProperty("交易金额")
    private BigDecimal totalPrice;

    /**
     * 计算总价
     *
     * @author yuanshuai
     * @date 2023/6/18 15:51
     */
    public OrderApplyInfoResponse calcTotalPrice() {
        if (CollectionUtils.isEmpty(skuList)) {
            this.totalPrice = BigDecimal.ZERO;
        } else {
            this.totalPrice = skuList.stream()
                    .map(sku -> {
                        sku.setTotalPrice(sku.getUnitPrice().multiply(BigDecimal.valueOf(sku.getNum())));
                        return sku.getTotalPrice();
                    })
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return this;
    }


}
