package com.cku.restful.v1.dog.web;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.dog.service.RestDogBatchService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Created by lyyz on 2019/6/10.
 * 血统证书整窝办理
 */
@Controller
@RequestMapping(value = "/api/v1/dog/dogBatch")
public class RestDogBatchController extends BaseRestController {
    /**
     * 根据配种编号获取 配种基本信息
     * 配种证明编号，配种日期，公犬主人，血统证书号，母犬主人，血统证书号
     *
     * @param request
     * @param response
     * @throws IOException
     */
    @Autowired
    private RestDogBatchService restDogBatchService;

    @RequestMapping(value = "/get", method = RequestMethod.GET)
    @ResponseBody
    public void get(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletUtils.writeResponse(response, restDogBatchService.getByBreedCertifiedCode(request));
    }

    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ResponseBody
    public void postDogBatch(@RequestBody String json, HttpServletResponse response) throws IOException {
        ServletUtils.writeResponse(response, restDogBatchService.post(json));
    }

    @RequestMapping(value = "/getPrice", method = RequestMethod.GET)
    @ResponseBody
    public void getPrice(HttpServletRequest request,
                         HttpServletResponse response) throws IOException {
        RESTResponse result = restDogBatchService.getPrice(request);
        ServletUtils.writeResponse(response, result);
    }

}
