package com.cku.restful.v1.dog.vo;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import org.hibernate.validator.constraints.NotEmpty;

import com.cku.restful.v1.sys.model.RestCouponGroup;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel
public class RestDogBirthCertificatePostVO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	@ApiModelProperty("配种证明号")
	@NotEmpty(message = "配种证明号不能为空")
	private String fmdogBreedCertifiedCode;

	@ApiModelProperty("是否电子版")
	@NotEmpty(message = "是否电子版不能为空")
	private String ecertFlag;
	
	@ApiModelProperty("出生日期")
	@NotEmpty(message = "出生日期不能为空")
	private Date dogBirthday;
	
	@ApiModelProperty("是否加急 1加急 0不加急")
	@NotEmpty(message = "是否加急不能为空")
	private Integer urgent;
	
	@ApiModelProperty("护照类型 0实体 1电子 默认实体")
	@NotEmpty(message = "护照类型不能为空")
	private Integer cabPassportType;
	
	@ApiModelProperty("登记卡列表")
	@NotEmpty(message = "登记卡列表不能为空")
	private List<DogBirthCertificateVO> dogBirthCertificateArray;

	@ApiModelProperty(value = "已选优惠券组对象")
	private RestCouponGroup checkedCoupon;

	private String secondBreederMemberCode;

	private String secondBreeder;
	

}
