/**
 * Copyright &copy; 2012-2014 <a href="https:github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dog.model;

import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.sys.model.RestCouponGroup;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 新生犬登记Entity
 *
 * @author zhuoHeng
 * @version 2016-08-04
 */
@Data
@ApiModel
public class RestDogChip extends BaseRefundDto {

	private static final long serialVersionUID = 4827952673844377322L;

	private String id;

	@ApiModelProperty(value = "出生纸编号")
	private String birthCode;

	@ApiModelProperty(value = "DNA留存方式:血样留存0；DNA位点分析1")
	private String dnaSaveWay;

	@ApiModelProperty(value = "DNA双亲比对标记位：0否；1是")
	private String isDnaParentsCompare;

	@ApiModelProperty(value = "创建日期")
	private String createDate;

	@ApiModelProperty(value = "医院名称")
	private String hospitalName;

	@ApiModelProperty(value = "审核状态")
	private String reviewState;

	@ApiModelProperty(value = "审核的意见")
	private String reviewRemarks; 

	@ApiModelProperty(value = "出生证明识别码")
	private String snCode; 

	@ApiModelProperty(value = "新生犬主会员号")
	private String newDogOwnerCode; 

	@ApiModelProperty(value = "医院编号")
	private String hospitalCode; 

	@ApiModelProperty(value = "流程状态")
	private String processState; 

	@ApiModelProperty(value = "撤销状态")
	private String isCanceled;

	@ApiModelProperty(value = "存在芯片")
	private boolean hasChip;

	@ApiModelProperty(value = "是否能撤销")
	private boolean canCanceled;

	@ApiModelProperty(value = "血统证书号")
	private String pedigreeCertified; 

	@ApiModelProperty(value = "身份识别标志")
	private String identificationFlag; 

	@ApiModelProperty(value = "临时用户名")
	private String tempUserName; 

	@ApiModelProperty(value = "业务状态")
	private String businessState; 

	@ApiModelProperty(value = "英文姓名")
	private String dogEnName; 

	@ApiModelProperty(value = "种类")
	private String dogBreed; 

	@ApiModelProperty(value = "性别")
	private String dogGender; 

	@ApiModelProperty(value = "出生日期")
	private String dogBirthday; 

	@ApiModelProperty(value = "颜色及标志")
	private String colorFlag; 

	@ApiModelProperty(value = "繁殖人")
	private String breeder; 

	@ApiModelProperty(value = "")
	private String fmdogBreedCertifiedCode;

	@ApiModelProperty(value = "电子证书标记位：0否；1是")
	private String ecertFlag; 

	@ApiModelProperty(value = "呼名")
	private String callName; 

	@ApiModelProperty(value = "是否整窝办理：是：1 、否：0")
	private String isAll; 

	@ApiModelProperty(value = "是否申请了退款")
	private boolean canEdit; 

	@ApiModelProperty(value = "申请贴纸标识:0不申请;1申请")
	private String stickerFlag;

	@ApiModelProperty(value = "1:新会员")
	private String newMemberFlag;

	@ApiModelProperty(value = "")
	private Member newMember;

	@ApiModelProperty(value = "流水号")
	private String runningNumber; 

	@ApiModelProperty(value = "订单ID")
	private String orderId;

	@ApiModelProperty(value = "付款的状态")
	private String paymentState; 

	@ApiModelProperty(value = "单价")
	private String price;

	@ApiModelProperty(value = "业务名称")
	private String businessName;

	@ApiModelProperty(value = "犬只鼻纹")
	private boolean dogNose;

	@ApiModelProperty(value = "犬只ID")
	private String dogId;

	@ApiModelProperty(value = "")
	private String haddleWay;

	@ApiModelProperty(value = "已选优惠券组对象")
	private RestCouponGroup checkedCoupon;

}