package com.cku.restful.v1.cab.sys.service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.auth0.jwt.exceptions.TokenExpiredException;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.sys.dao.OrgDao;
import com.cku.oa.sys.entity.Org;
import com.cku.partner.sys.model.PartnerAddress;
import com.cku.partner.sys.model.PartnerLoginUserInfo;
import com.cku.partner.sys.model.PartnerUserProfile;
import com.cku.util.Debugger;
import com.cku.util.HttpClientUtil;
import com.cku.util.HttpResult;
import com.cku.util.SysConfig;
import com.cku.util.TokenUtil;
import com.google.gson.Gson;
import com.thinkgem.jeesite.common.utils.SpringContextHolder;

import net.sf.json.JSONObject;

public class UserService {
	
	private static final Logger logger = LoggerFactory.getLogger(UserService.class);

	private static OrgDao orgDao = SpringContextHolder.getBean(OrgDao.class);
	
	/**
	 * 
	 * @Description：验证token有效性，返回token匹配的cku用户id
	 * @author: zhuoHeng
	 * @version: 2016年11月8日 下午2:58:40
	 */
	public static Map validate(String token,String club)
	{
		logger.debug("跟踪/user/validate.do日志：开始");
		String sessionSrvUrl = SysConfig.getInstance().getProperty("cab_validate_url");
		HttpResult hr;
		Map<String, String> map = new HashMap<String, String>();
		String ckuUserId = "";
		String loginType = "";
		try {
			hr = HttpClientUtil.get(null, sessionSrvUrl + "/user/validate.do?token=" + token + "&club=" + club, null);
			Debugger.doAssert(hr.getResultCode() == 200, ZAErrorCode.ZA_ERC_INVALID_STATUS, "%s", hr.getResponseBody());
			JSONObject jo = JSONObject.fromObject(hr.getResponseBody());
			long rc = jo.getLong("rc");
			
			Debugger.doAssert(rc == 0, ZAErrorCode.ZA_ERC_INVALID_STATUS, jo.getString("msg"));
			ckuUserId = (String) jo.getJSONObject("token").get("ckuUserId");
			loginType = (String) jo.getJSONObject("token").get("loginType");
			map.put("ckuUserId", ckuUserId);
			map.put("loginType", loginType);
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_ERC_INVALID_STATUS, "用户信息验证失败,验证地址："+sessionSrvUrl);
		}
		logger.debug("跟踪/user/validate.do日志：结束");
		return map;
	}
	
	private static final Gson GSON = new Gson();
	public static PartnerLoginUserInfo validatePartner(String token) {
		PartnerUserProfile userProfile = new PartnerUserProfile();
		try {
			String subject = TokenUtil.parseJwt(token).getSubject();
			logger.info("解析token数据"+subject);
			userProfile =  GSON.fromJson(subject,PartnerUserProfile.class);
			if(!"org".equals(userProfile.getClientName())) {
				throw new ZAException(ZAErrorCode.ZA_ERC_INVALID_STATUS,ZAErrorCode.ZA_ERC_INVALID_STATUS_MSG);
			}
			Org sysOrg = orgDao.selectByOrgId(userProfile.getId());
			if(new Date().after(sysOrg.getEndDate())) {
				throw new ZAException(ZAErrorCode.ZA_ERC_INVALID_STATUS,"对不起您的帐号已经过期，请联系CKU处理");
			}
			PartnerLoginUserInfo info = new PartnerLoginUserInfo();
			PartnerAddress address = new PartnerAddress();
			address.setProvince(sysOrg.getProvince());
			address.setCity(sysOrg.getCity());
			address.setStreet(sysOrg.getStreet());
			address.setAddress(sysOrg.getAddress());
			info.setAddress(address);
			info.setContactName(sysOrg.getContact());
			info.setContactTel(sysOrg.getTel());
			info.setDeposit(sysOrg.getDeposit());
			info.setEndDate(sysOrg.getEndDate());
			info.setId(sysOrg.getId());
			info.setMemberCode(sysOrg.getMemberCode());
			info.setName(sysOrg.getName());
			info.setType(sysOrg.getOrgType());
			info.setUserId(sysOrg.getUserId());
			info.setAccountBalance(sysOrg.getAccountBalance());
			info.setTuijianren(sysOrg.getTuijiansren());
			return info;
		}
		catch(TokenExpiredException ex) {
			logger.info("================解析token失败，Token过期================" + ex.getMessage());
			throw new ZAException(ZAErrorCode.ZA_ERC_INVALID_STATUS,ZAErrorCode.ZA_ERC_INVALID_STATUS_MSG);
		}
		catch(ZAException ex) {
			logger.info("================================" + ex.getMessage());
			throw ex;
		}
		catch(Exception ex) {
			logger.info("================================" + ex.getMessage());
			throw new ZAException(ZAErrorCode.ZA_ERROR,"服务器处理数据发生异常");
		}
	}
}
