package com.cku.restful.v1.breeder.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.cku.restful.v1.breeder.service.RestBreederService;
import com.cku.restful.v1.dog.service.RestDogService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

/**
 * @description: 我的犬只模块
 * @author: laiguanglong
 * @date: 2017/10/9 9:56
 */
@Controller
@RequestMapping(value = "/api/v1/breeder/myDog")
public class RestMyDogController extends BaseRestController {

	@Autowired
	private RestBreederService restBreederService;

	@Autowired
	private RestDogService restDogService;

	/**
	 * @description: 我的犬只列表接口
	 * @author: laiguanglong
	 * @date: 2017/10/9 15:15
	 */
	@ApiOperation(value = "我的血统犬-列表", tags = { "我的血统犬-zxy" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "pageSize", value = "展示条数"),
			@ApiImplicitParam(name = "pageNo", value = "当前页"),
			@ApiImplicitParam(name = "token", paramType = "query", value = "token"),
			@ApiImplicitParam(name = "type", value = "unsold-未出售/sold-已出售") })
	@ApiResponses({ @ApiResponse(code = 0, message = "{    \n" + "	\"rc\": 0,\n" + "	    \"msg\": \"OK\",\n"
			+ "	    \"list\": [        {            \n" + "		\"id\": \"b04492e4d8204957ac77d3e307511d70\",\n"
			+ "		            \"pedigreeCertifiedCode\": \"CKU-111493598/20\",\n"
			+ "		            \"dogBreed\": \"金毛寻回猎犬\",\n" + "		            \"gender\": \"1\",\n"
			+ "		            \"nickname\": \"\",\n" + "		            \"dogName\": \"爵爷\",\n"
			+ "		            \"age\": \"3个月\",\n" + "		            \"studDogId\": \"\",\n"
			+ "		            \"studDogState\": \"\",\n" + "		            \"studDogCoverImg\": \"\",\n"
			+ "		            \"ageOneToTen\": \"0\",\n" + "		            \"city\": \"北京市\",\n"
			+ "		            \"noseCode\": \"\"        \n" + "	}    ],\n" + "	    \"total\": 10\n" + "}") })
	@RequestMapping(value = "", method = RequestMethod.GET)
	public void getList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, restBreederService.getMyDogList(request));
	}

	/**
	 * @description: 我的犬只列表接口
	 * @author: laiguanglong
	 * @date: 2017/10/9 15:15
	 */
	@RequestMapping(value = "", method = RequestMethod.PUT)
	public void put(@RequestBody String json, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, restBreederService.putMyDog(json));
	}

	/**
	 * @description: 我的犬只犬种列表接口
	 * @author: laiguanglong
	 * @date: 2017/10/9 15:15
	 */
	@RequestMapping(value = "/getDogBreedList", method = RequestMethod.GET)
	public void getDogBreedList(HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, restBreederService.getDogBreedList());
	}

	/**
	 * @description: 我的犬只列表-添加鼻纹
	 * @author: laiguanglong
	 * @date: 2017/10/9 15:15
	 */
	@RequestMapping(value = "/addDogNose", method = RequestMethod.PUT)
	public void addDogNose(@RequestBody String json, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, restBreederService.addDogNose(json));
	}

	/**
	 * @description: 我的犬只列表-电子证书
	 */
	@ApiOperation(value = "App- 我的犬只列表-电子证书", tags = {
			"App- 我的犬只列表-电子证书-xuxue" }, notes = "备注信息太多，建议看接口文档 https://docs.qq.com/doc/DRUxQZ05ySUJjZnVp")
	@ApiImplicitParams({ @ApiImplicitParam(name = "id ", value = "犬只ID", paramType = "query"),
			@ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({ @ApiResponse(code = 200, message = "{\n" + "   \"rc\": 0,\n" + "   \"msg\": \"OK\",\n"
			+ "   \"data\": {\n" + "      \"certificateType\": “ZA_XT”, — 证书类型（见下方备注）\n"
			+ "      \"dogMemberName\": \"张辉”,  — 犬主人  \n" + "      \"dogMemberNameEn\":  “”,  — 犬主人（英文名）\n"
			+ "      \"breeder\": \"\",  — 繁殖人\n" + "      \"breederEn\": “\", — 繁殖人英文名\n"
			+ "      \"kennleName\": “\", — 出生犬舍\n" + "      \"puppyBirthNum\": \"1公0母”,  — 本胎出生数量\n"
			+ "       \"puppyRegisterNum\": \"1公0母”, — 本胎登记数量\n" + "       \"colorDesc\": \"黑褐色”,   — 毛色（中文）\n"
			+ "       \"color\": \"BLKTN”,  — 毛色（英文）\n" + "       \"dogBirthday\": \"2017年1月1日”, — 出生年月日\n"
			+ "       \"createDate\": \"2019/6/10”,  — 签发日期\n" + "       \"dogGrade\": “”, — 犬只等级\n"
			+ "       \"identification\": \"953010001981433”, — 身份识别号码\n"
			+ "       \"pedigreeCertified\": \"CKUTM-230471422/19”, — 血统证书号（鉴定证书号码）\n"
			+ "       \"dogGender\": \"公”,  — 性别\n" + "       \"dogGenderDesc\": \"Male”,  — 性别英文\n"
			+ "       \"pedigreeCertifiedEn\": \"DG-427046-2017”, — 国外血统证书号\n"
			+ "       \"dogName\": \"HIGHLANDER STARS SMARTLY TOBY”,  — 犬名\n"
			+ "       \"dogBreedDesc\": \"西藏獒犬”,  —犬种中文名\n" + "       \"dogBreed\": \"Tibetan Mastiff”,  — 犬种英文名\n"
			+ "       \"kennelEnName\": \"\",— 犬舍英文名\n" + "       \"dog1\": {\n"
			+ "           \"pedigreeCertified\": \"DG-386008-2013”, — 血统证书号\n" + "           \"color\": “\", — 毛色\n"
			+ "           \"showLevel\": \"\",\n" + "           \"dogName\": \"HIGHLANDER STARS SMARTLY”, — 犬名\n"
			+ "           \"createDate\": “” — 签发日期\n" + "       },\n" + "      \"dog2\": {\n"
			+ "           \"pedigreeCertified\": \"DG-410032-2015\",\n" + "           \"color\": \"\",\n"
			+ "           \"showLevel\": \"\",\n" + "           \"dogName\": \"HIGHLANDER STARS SWEET BABY\",\n"
			+ "           \"createDate\": \"\"\n" + "       },\n" + "     \"dog3\": {\n"
			+ "           \"pedigreeCertified\": \"DG-378701-2012\",\n" + "           \"color\": \"RD\",\n"
			+ "           \"showLevel\": \"\",\n" + "           \"dogName\": \"BIG BOY OF ASIA PUPPY\",\n"
			+ "           \"createDate\": \"\"\n" + "       },\n" + "       \"dog4\": {\n"
			+ "           \"pedigreeCertified\": \"DG-377070-2012\",\n" + "           \"color\": \"BLKTN\",\n"
			+ "           \"showLevel\": \"\",\n" + "           \"dogName\": \"MAURA\",\n"
			+ "           \"createDate\": \"\"\n" + "       },\n" + "      \"dog5\": {\n"
			+ "           \"pedigreeCertified\": \"DG-378701-2012\",\n" + "           \"color\": \"RD\",\n"
			+ "           \"showLevel\": \"\",\n" + "           \"dogName\": \"BIG BOY OF ASIA PUPPY\",\n"
			+ "           \"createDate\": \"\"\n" + "       },\n" + "       \"dog6\": {\n"
			+ "           \"pedigreeCertified\": \"DG-386001-2013\",\n" + "           \"color\": \"RD\",\n"
			+ "           \"showLevel\": \"\",\n" + "           \"dogName\": \"HIGHLANDER STARS SWEETIE\",\n"
			+ "           \"createDate\": \"\"\n" + "       },\n" + "        \"dog7\": {\n"
			+ "           \"pedigreeCertified\": \"KCTH 0252121000\",\n" + "           \"color\": \"\",\n"
			+ "           \"showLevel\": \"\",\n" + "           \"dogName\": \"PLUTTO\",\n"
			+ "           \"createDate\": \"\"\n" + "       },\n" + "    \"dog8\": {\n"
			+ "           \"pedigreeCertified\": \"KCTH 02521210\",\n" + "           \"color\": \"BLKTN\",\n"
			+ "           \"showLevel\": \"\",\n" + "           \"dogName\": \"IUNNA\",\n"
			+ "           \"createDate\": \"\"\n" + "       },\n" + "       \"dog9\": {\n"
			+ "           \"pedigreeCertified\": \"0094\",\n" + "           \"color\": \"\",\n"
			+ "           \"showLevel\": \"\",\n" + "           \"dogName\": \"IUDJIN\",\n"
			+ "           \"createDate\": \"\"\n" + "       },\n" + "       \"dog10\": {\n"
			+ "           \"pedigreeCertified\": \"A-550001\",\n" + "           \"color\": \"\",\n"
			+ "           \"showLevel\": \"\",\n" + "           \"dogName\": \"MAZDA\",\n"
			+ "           \"createDate\": \"\"\n" + "       },\n" + "      \"dog11\": {\n"
			+ "           \"pedigreeCertified\": \"KCTH 0252121000\",\n" + "           \"color\": \"\",\n"
			+ "           \"showLevel\": \"\",\n" + "           \"dogName\": \"PLUTTO\",\n"
			+ "           \"createDate\": \"\"\n" + "       },\n" + "       \"dog12\": {\n"
			+ "           \"pedigreeCertified\": \"KCTH 02521210\",\n" + "           \"color\": \"BLKTN\",\n"
			+ "           \"showLevel\": \"\",\n" + "           \"dogName\": \"IUNNA\",\n"
			+ "           \"createDate\": \"\"\n" + "       },\n" + "       \"dog13\": {\n"
			+ "           \"pedigreeCertified\": \"DG-378701-2012\",\n" + "           \"color\": \"RD\",\n"
			+ "           \"showLevel\": \"\",\n" + "           \"dogName\": \"BIG BOY OF ASIA PUPPY\",\n"
			+ "           \"createDate\": \"\"\n" + "       },\n" + "       \"dog14\": {\n"
			+ "           \"pedigreeCertified\": \"DG-377070-2012\",\n" + "           \"color\": \"BLKTN\",\n"
			+ "           \"showLevel\": \"\",\n" + "           \"dogName\": \"MAURA\",\n"
			+ "           \"createDate\": \"\"\n" + "       },\n" + "       \"paperKennelEnName\": \"\",\n"
			+ "       \"callName\": \"\",\n" + "       \"paperDogName\": \"HIGHLANDER STARS SMARTLY TOBY”\n" + "   }\n"
			+ "}\n" + "") })
	@RequestMapping(value = "/certificateInfo", method = RequestMethod.GET)
	public void certificateInfo(HttpServletRequest request, HttpServletResponse response) throws Exception {
		ServletUtils.writeResponse(response, restDogService.certificateInfo(request.getParameter("id")));
	}

	@RequestMapping(value = "/updatePicture", method = RequestMethod.PUT)
	public void updatePicture(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		ServletUtils.writeResponse(response, restDogService.updatePicture(json));
	}

}