package com.cku.partner.club.web;

import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.finance.service.PaymentRecordService;
import com.cku.oa.org.service.OrgSamplingService;
import com.cku.oa.org.vo.OrgSamplingDetailListVo;
import com.cku.oa.org.vo.OrgSamplingGroupVo;
import com.cku.oa.statistics.dao.ClubStatisticsDao;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.OrgChip;
import com.cku.oa.sys.service.OrgChipService;
import com.cku.oa.sys.service.OrgService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.Collections3;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

/**
 * 账户管理
 *user chaixueteng
 *2016年10月9日
 */
@Controller
@RequestMapping(value="/partner/accountManagement")
public class accountManagementController extends BaseController{
	@Autowired
	public OrgChipService orgChipService;
	@Autowired
	public PaymentRecordService paymentRecordService;
	@Autowired
	public PaymentOrderService paymentOrderService;
	@Autowired
	public PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	public OrgService orgService;
	@Autowired
	public ClubStatisticsDao clubStatisticsDao;
	@Autowired
	private OrgSamplingService orgSamplingService;


	@ModelAttribute
	public Org get(@RequestParam(required=false) String id) {
		Org entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = orgService.get(id);
		}
		if (entity == null){
			entity = new Org();
		}
		return entity;
	}

	/**
	 * 账户管理
	 * @Author chaixueteng
	 * @2016年10月9日下午2:55:43
	 */
	@RequestMapping(value="/account")
	public String account(Org org,Model model){
		model.addAttribute("club", org);
		model.addAttribute("province",UserUtils.getProvince());
		return "partner/club/accountManagement";
	}

	/**
	 * 账户充值
	 * @Author chaixueteng
	 * @2016年10月9日下午2:55:43
	 */
	@RequestMapping(value="/recharge")
	public String recharge(Model model){
		model.addAttribute("paymentOrder", new PaymentOrder());
		return "partner/club/clubRecharge";
	}

	/**
	 * 我的邮寄信息
	 * @Author chaixueteng
	 * @2016年10月9日下午2:55:43
	 */
	@RequestMapping(value="/myPost")
	public String myPost(OrgChip orgChip, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<OrgChip> page =orgChipService.findChipPage(new Page<OrgChip>(request, response), orgChip) ;
		model.addAttribute("page", page);
		return "partner/club/orgChipGroup";
	}
	/**
	 * 芯片记录
	 * @Author chaixueteng
	 * @2016年10月11日下午6:11:58
	 */
	@RequestMapping(value="/orgChip")
	public String list(OrgChip orgChip, HttpServletRequest request, HttpServletResponse response, Model model) {
		orgChip.setRemarks(null);
		orgChip.setInvalid(null);
		orgChip.setChipCode(null);
		orgChip.setAddress(null);
		Page<OrgChip> page = orgChipService.findPage(new Page<OrgChip>(request, response), orgChip);
		model.addAttribute("page", page);
		return "partner/club/orgChipList";
	}

	/**
	 * 我的充值记录
	 * @Author chaixueteng
	 * @2016年10月9日下午4:40:28
	 */
	@RequestMapping(value="/myRecord")
	public String myRecord(PaymentOrder paymentOrder, HttpServletRequest request, HttpServletResponse response, Model model){
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String memberCode = org.getMemberCode();
		paymentOrder.setMemberCode(memberCode);
		paymentOrder.setPaymentState("2");
		paymentOrder.setIsRecharge("1");
		Page<PaymentOrder> page = paymentOrderService.findPage(new Page<PaymentOrder>(request, response), paymentOrder);
		model.addAttribute("page", page);
		return "partner/club/paymentRecordList";
	}

	/**
	 * 我的消费记录
	 * @Author chaixueteng
	 * @2016年10月9日下午4:40:28
	 */
	@RequestMapping(value="/myConsume")
	public String myConsume(PaymentOrder paymentOrder, HttpServletRequest request, HttpServletResponse response, Model model){
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		paymentOrder.setMemberCode(null);
		paymentOrder.setPaymentState("2");
		paymentOrder.setIsRecharge("0");
		paymentOrder.setCreateBy(org.getUser());
		Page<PaymentOrder> page = paymentOrderService.findPage(new Page<PaymentOrder>(request, response), paymentOrder);
		model.addAttribute("page", page);
		return "partner/club/paymentOrderList";
	}
	/**
	 * 消费记录详情
	 * @Author chaixueteng
	 * @2016年10月9日下午6:30:55
	 */
	@RequestMapping(value="/orderDetil")
	public String orderDetil(String	 id,Model model){
		PaymentOrder paymentOrder = paymentOrderService.get(id);
		model.addAttribute("paymentOrder", paymentOrder);
		return "partner/club/paymentOrderDetail";
	}



	/**
	 * 修改邮寄地址
	 * @Author chaixueteng
	 * @2016年10月11日上午11:40:28
	 */
	@RequestMapping(value="/updateAddress")
	@ResponseBody
	public String updateAddress(HttpServletRequest request, HttpServletResponse response){
		String id = request.getParameter("id");
		String province = request.getParameter("province");
		String city = request.getParameter("city");
		String street = request.getParameter("street");
		Org org=new Org();
		org.setId(id);
		org.setProvince(province);
		org.setCity(city);
		org.setStreet(street);
		org.setAddress(province+city+street);
		orgService.update(org);
		String address = org.getAddress();
		return "{\"rc\":true,\"address\":\""+address+"\"}";
	}

	@RequestMapping(value="/updateAdminCode")
	@ResponseBody
	public String updateAdminCode(HttpServletRequest request, HttpServletResponse response){
		String id = request.getParameter("id");
		String adminCode = request.getParameter("adminCode");
		Org org=new Org();
		org.setId(id);
		org.setAdminCode(adminCode);
		orgService.updateAdminCode(org);
		String adCode = org.getAddress();
		return "{\"rc\":true,\"adminCode\":\""+adCode+"\"}";
	}



	@RequestMapping(value = "myIncome")
	public String myIncome(HttpServletRequest request,HttpServletResponse response,Model model) throws ParseException {
			String startDate = request.getParameter("startDate");
			String endDate = request.getParameter("endDate");
		    String nowDate=request.getParameter("nowDate");
			Org org = (Org) UserUtils.getSession().getAttribute("org");
			Calendar cal = Calendar.getInstance();
			int year = cal.get(Calendar.YEAR);
			int month = cal.get(Calendar.MONTH )+1;
			int day = cal.get(Calendar.DAY_OF_MONTH);
			if(nowDate==null)
			{
				nowDate="";
			}
			if(!nowDate.equals(""))
			{
				if(nowDate.equals("year"))
				{
					startDate = String.valueOf(year)+"-01-01 00:00:00:";
					endDate = String.valueOf(year)+"-12-31 23:59:59";
				}else if(nowDate.equals("month")){
					startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-01 00:00:00";
					endDate = String.valueOf(year)+"-"+String.valueOf(month+1)+"-01 23:59:59";
				}
			}else{
				if(startDate == null || startDate.equals(""))
					startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 00:00:00";
				if(endDate == null || endDate.equals(""))
					endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
			}
			List<Map> results =  clubStatisticsDao.myIncome(startDate,endDate, org.getName(),"");
			if(!Collections3.isEmpty(results)){
				model.addAttribute("results",results.get(0));
			}
			model.addAttribute("size",results.size());
			model.addAttribute("startDate",startDate);
			model.addAttribute("endDate",endDate);
			Page<Object> page = new Page<Object>(request, response);//从页面的参数中获取当前的页码等信息
			 //你这个功能根本不需要分页，我就不给你差总条数了，自己看着办吧。
			page.setCount(results.size());
			page.initialize();//重新计算页码信息
			model.addAttribute("page",page);
			return "partner/club/clubStatisticsList";
	}
	@RequestMapping(value = "income")
	public String income(HttpServletRequest request,HttpServletResponse response,Model model) throws ParseException {
			String startDate = request.getParameter("startDate");
			String endDate = request.getParameter("endDate");
		    String nowDate=request.getParameter("nowDate");
		    String memberCode=request.getParameter("memberCode");
		    String tuijiansren=request.getParameter("tuijiansren");
			Org org = (Org) UserUtils.getSession().getAttribute("org");
			Calendar cal = Calendar.getInstance();
			int year = cal.get(Calendar.YEAR);
			int month = cal.get(Calendar.MONTH )+1;
			int day = cal.get(Calendar.DAY_OF_MONTH);
			if(nowDate==null)
			{
				nowDate="";
			}
			if(!nowDate.equals(""))
			{
				if(nowDate.equals("year"))
				{
					startDate = String.valueOf(year)+"-01-01 00:00:00:";
					endDate = String.valueOf(year)+"-12-31 23:59:59";
				}else if(nowDate.equals("month")){
					startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-01 00:00:00";
					endDate = String.valueOf(year)+"-"+String.valueOf(month+1)+"-01 23:59:59";
				}
			}else{
				if(startDate == null || startDate.equals(""))
					startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 00:00:00";
				if(endDate == null || endDate.equals(""))
					endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
			}
			List<Map> results = new ArrayList<>();
			if(StringUtils.isNotBlank(tuijiansren)){
				results =  clubStatisticsDao.income(startDate,endDate, "","","",tuijiansren);
			}else if(StringUtils.isNotBlank(memberCode) && !org.getMemberCode().equals(memberCode)){
				results =  clubStatisticsDao.income(startDate,endDate, "",memberCode,"","");
			}else{
				results =  clubStatisticsDao.income(startDate,endDate, org.getName(),memberCode,org.getOrgType(),"");
			}
			for (Map map : results){
				Map certified = clubStatisticsDao.getCertified(startDate,endDate,(String) map.get("member_code"),(String) map.get("org_type"));
				if(certified != null){
					map.put("certified_price",certified.get("total_price"));
					map.put("certified_count",certified.get("COUNT"));
				}else{
					map.put("certified_price","0.00");
					map.put("certified_count","0");
				}
			}
			if(!Collections3.isEmpty(results)){
				if(StringUtils.isNotBlank(tuijiansren)){
					model.addAttribute("results",results);
				}else{
					model.addAttribute("results",results.get(0));
				}
			}
			model.addAttribute("size",results.size());
			model.addAttribute("orgType",org.getOrgType());
			model.addAttribute("orgId",org.getId());
			model.addAttribute("startDate",startDate);
			model.addAttribute("endDate",endDate);
			Page<Object> page = new Page<Object>(request, response);//从页面的参数中获取当前的页码等信息
			 //你这个功能根本不需要分页，我就不给你差总条数了，自己看着办吧。
			page.setCount(results.size());
			page.initialize();//重新计算页码信息
			model.addAttribute("page",page);
		if(StringUtils.isNotBlank(tuijiansren)){
			return "partner/club/otherStatisticsList";
		}else{
			return "partner/club/statisticsList";
		}
	}
	
	
	
	@RequestMapping(value = "sampling/groupList")
	public String samplingGroupList(OrgSamplingGroupVo groupVo,HttpServletRequest request,HttpServletResponse response,Model model) throws ParseException {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		model.addAttribute("orgId",org.getId());
		groupVo.setOrgId(org.getId());
		Page<OrgSamplingGroupVo> page = orgSamplingService.findGroupPage(new Page<>(request, response), groupVo);
		model.addAttribute("page",page);
		return "partner/club/samplingGroupList";
	}
	
	@RequestMapping(value = "sampling/list")
	public String samplingList(OrgSamplingDetailListVo listVo,HttpServletRequest request,HttpServletResponse response,Model model) throws ParseException {
		
        model.addAttribute("batchNum", listVo.getBatchNum());
        Org org = (Org) UserUtils.getSession().getAttribute("org");
        listVo.setOrgId(org.getId());
		Page<OrgSamplingDetailListVo> page = orgSamplingService.findDetailListPage(new Page<>(request, response), listVo);
		model.addAttribute("page", page);
		return "partner/club/samplingList";
	}
}
