package com.cku.partner.club.service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogChip;
import com.cku.oa.dog.entity.DogChipChange;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.entity.DogNewborn;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogBloodSaveService;
import com.cku.oa.dog.service.DogChipChangeService;
import com.cku.oa.dog.service.DogChipService;
import com.cku.oa.dog.service.DogDnaArchiveService;
import com.cku.oa.dog.service.DogNewbornService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.sampling.enums.SamplingDogSourceTypeEnum;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.service.OrgChipService;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 *user chaixueteng
 *2016年10月13日
 */
@Service
@Transactional(readOnly = true)
public class HospitalService {
	
	@Autowired
	private DogBirthCertificateDao dogBirthCertificateDao;
	@Autowired
	private DogChipService dogChipService;
	@Autowired
	private DogService dogService;
	@Autowired
	private DogChipChangeService dogChipChangeService;
	@Autowired
	private OrgChipService orgChipService;
	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	private DogNewbornService dogNewbornService;
	@Autowired
	private DogBloodSaveService dogBloodSaveService;
	@Autowired
	private DogDnaArchiveService dogDnaArchiveService;
	
	/**
	 * 根据出生纸编号 和标示码查询
	 * @Author chaixueteng
	 * @2016年10月13日下午2:49:54
	 */
	public Map<String, String> searchChipMessage(String birthCode, String snCode)throws ZAException {
		Map<String,String> map=new HashMap<String,String>();
		DogChip dogChip = dogChipService.getByBirthCode(birthCode);
		if (dogChip==null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登记卡未申请!");
		}else{
			String paymentState = dogChip.getPaymentState();
			if (!"2".equals(paymentState)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登记血统证书未缴费！！！");
			}
			String isCanceled = dogChip.getIsCanceled();
			if(StringUtils.isNotBlank(isCanceled)&&"1".equals(isCanceled)){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该血统证书申请已撤销！！！");
			}
			String reviewState = dogChip.getReviewState();
			String reviewRemarks = dogChip.getReviewRemarks();
			if (!"1".equals(reviewState)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书申请审核未通过！！！ "+reviewRemarks);
			}
			DogBirthCertificate birth = dogBirthCertificateService.getByBirthCodeAndSnCode(birthCode,snCode);
			if (birth==null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登记卡编号与识别码不匹配，请核对后重新输入!");
			}else{
				String identificationFlag = birth.getIdentificationFlag();
				if(StringUtils.isNotBlank(identificationFlag)){
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该登记卡已录入芯片号!");
				}
				DogNewborn dogNewborn = dogNewbornService.getBybreedCertifiedCode(birth.getFmdogBreedCertifiedCode());
				map.put("breedCnName", birth.getBreeder());
				map.put("pedigreeCertified", birth.getPedigreeCertified());
				map.put("birthCerRegCode", birth.getBirthCerRegCode());
				map.put("dogEnName", birth.getDogEnName());
				map.put("identificationFlag", birth.getIdentificationFlag());
				String birthday = DateUtils.formatDate(birth.getDogBirthday(), "yyyy-MM-dd");
				map.put("dogBirthday", birthday);
				map.put("fdogPedigreeCertified", birth.getFdogPedigreeCertified());
				map.put("mdogPedigreeCertified", birth.getMdogPedigreeCertified());
				Dog dog = dogService.getByPedigreeCertifiedCode(birth.getFdogPedigreeCertified());
				Dog dog2 = dogService.getByPedigreeCertifiedCode(birth.getMdogPedigreeCertified());
				if(dog!=null){
					map.put("fDogNameEn", dog.getNameEn());
				}
				if(dog2!=null){
					map.put("mDogNameEn", dog2.getNameEn());
				}
				map.put("sameBatchNum", birth.getSameBatchNum());
				map.put("gender", birth.getDogGender());
				map.put("printType", dogNewborn.getPrintType());
				map.put("colorFlag", birth.getColorFlag());
				String dnaSaveWay = dogChip.getDnaSaveWay();//位点分析
				if ("1".equals(dnaSaveWay)) {
					map.put("dna", "1");
				}else if("0".equals(dnaSaveWay)){//血样留存
					map.put("dna", "0");
				}else{//未有血样留存记录的
					map.put("dna", "2");
				}
				map.put("parent",dogChip.getIsDnaParentsCompare());
			}
		}
		return map;
	}
	
	
	/**
	 * 录入芯片
	 * @Author chaixueteng
	 * @2016年10月13日下午4:10:58
	 */
	@Transactional(readOnly = false)
	public void add(String birthCerRegCode,String identificationFlag,String dna) {
		//血样留存标记为已采血
		dogChipService.setBloodSaveFlag(birthCerRegCode);
		//如果已经生成犬只了 就替换掉犬只的芯片号
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		String dogid=null;
		String memberCode=null;
		String identificationFlag2 =null;
		Dog dog=dogService.getByBirthCertificateLevelCode(birthCerRegCode);
		if (dog!=null) {
			dogid = dog.getId();
			memberCode = dog.getMemberCode();
			identificationFlag2 = dog.getIdentificationFlag();
			dog.setIdentificationFlag(identificationFlag);
			dogService.save(dog);
		}
		DogChip dogChip = dogChipService.getByBirthCode(birthCerRegCode);
		//添加芯片变更记录
		DogChipChange dogChipChange = new DogChipChange();
		dogChipChange.setDogId(dogid);
		dogChipChange.setBirthCode(birthCerRegCode);
		dogChipChange.setChipCodeOld(identificationFlag2);
		dogChipChange.setChipCodeNew(identificationFlag);
		dogChipChange.setPaymentMemberCode(memberCode);
		dogChipChange.setReviewState("1");
		dogChipChange.setReviewTime(new Date());
		dogChipChange.setRunningNumber(dogChip.getRunningNumber());
		dogChipChange.setPaymentState("2");
		dogChipChange.setPaymentTime(dogChip.getPaymentTime());
		dogChipChange.setProcessState(null);
		dogChipChange.setProcessTime(null);
		dogChipChange.setOrganizationUsername(loginName);
		dogChipChange.setOperator(loginName+":"+DateUtils.formatDate(new Date(), "yyyy-M-d"));
		dogChipChangeService.save(dogChipChange);
		//添加芯片到出生证明表
		DogBirthCertificate byBirthCerRegCode = dogBirthCertificateService.getByBirthCerRegCode(birthCerRegCode);
		byBirthCerRegCode.setIdentificationFlag(identificationFlag);
		byBirthCerRegCode.setAddUser(loginName);
		byBirthCerRegCode.setChipInjectDate(new Date());
		dogBirthCertificateService.save(byBirthCerRegCode);
		//dog_chip 添加id
		dogChip.setDogChipChangeId(dogChipChange.getId());
		dogChipService.save(dogChip);

	}


	/**
	 * 新版出生纸 (医院确认端)
	 * @param birthCerRegCode
	 * @param identificationFlag
	 * @param dna
	 */
	@Transactional(readOnly = false)
	public void addNew(String birthCerRegCode, String identificationFlag,
			String dna,String samplingCode) {
		//血样留存标记为已采血
		dogChipService.setBloodSaveFlag(birthCerRegCode);
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		DogChipChange dogChipChange = dogChipChangeService.getByIdentificationFlag(identificationFlag);
		if(dogChipChange==null){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "无芯片记录,请确认芯片是否正确!");
		}
		dogChipChange.setReviewState("1");
		dogChipChange.setReviewTime(new Date());
		dogChipChange.setOrganizationUsername(loginName);
		dogChipChange.setOperator(loginName+":"+DateUtils.formatDate(new Date(), "yyyy-M-d"));
		dogChipChangeService.save(dogChipChange);
		
		DogChip dogChip = dogChipService.getByBirthCode(birthCerRegCode);
		dogChip.setDogChipChangeId(dogChipChange.getId());
		dogChipService.save(dogChip);
		DogBirthCertificate byBirthCerRegCode = dogBirthCertificateService.getByBirthCerRegCode(birthCerRegCode);
		byBirthCerRegCode.setChipInjectDate(new Date());
		dogBirthCertificateService.save(byBirthCerRegCode);
		// 位点分析业务表
		if ("1".equals(dna)) {
			dogDnaArchiveService.bindSamplingFront(birthCerRegCode,SamplingDogSourceTypeEnum.BIRTH_CODE,
					samplingCode, org.getMemberCode());
		}
		
	}
	
}
