/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.trainschool.entity;

import com.cku.oa.sys.entity.user.Member;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.modules.sys.entity.User;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 合作学校Entity
 * @author 柴雪腾
 * @version 2016-08-08
 */
public class TrainingInstitution extends DataEntity<TrainingInstitution> {

	private static final long serialVersionUID = 1L;
	private String schoolNameCn;		// 学校中文
	private String schoolNameEn;         //英文名
	private String schoolShortName;		// 培训机构缩写
	private String schoolUserId;		// 学校用户id
	private String schoolMemberCode;		// 学校会员号
	private String memberCode;		// 会员号
	private String responsibler;		// 负责人
	private String telephone;		// 联系电话
	private String province;		// 省
	private String city;		// 城市
	private String street;		// 街道
	private String address;		// 地址
	private Date startDate;		// 开始时间
	private Date endDate;		// 结束时间
	private String schoolType;		// 学校类别
	private String schoolWeb;		// 学校网址
	private String displayOnWeb;		// 网页是否显示
	private int student;  //输送学员数
	//User表相关字段
	private User user;
	private String password;// 密码
	//Member表相关字段
	private Member member;
	private Date responsiblerMemberEndDate;//负责人会员截止日期
	private Date responsiblerGroomerEndDate;//负责人美容会员截止日期
	private String responsiblerMemberPayFlag;//负责人会员是否缴费标记位。0：未缴费；1已缴费
	private String schoolMemberPayFlag;//学校会员是否缴费标记位。0：未缴费；1已缴费
	private String qualifications;
	private String avatar;
	private String avatarBack;
	private String introduce;
//	private String level;
	private String curriculumCount;//课程人数
	//1牵犬师培训学校2 训犬师培训学校 3营养师培训学校4 综合性培训学校
	private String firstSchoolType;//一级分类


	public String getQualifications() {
		return qualifications;
	}

	public void setQualifications(String qualifications) {
		this.qualifications = qualifications;
	}

	public int getStudent() {
		return student;
	}

	public void setStudent(int student) {
		this.student = student;
	}

	public TrainingInstitution() {
		super();
	}

	public TrainingInstitution(String id){
		super(id);
	}

	@Length(min=0, max=100, message="学校中文长度必须介于 0 和 100 之间")
	public String getSchoolNameCn() {
		return schoolNameCn;
	}

	public void setSchoolNameCn(String schoolNameCn) {
		this.schoolNameCn = schoolNameCn;
	}

	@Length(min=0, max=64, message="培训机构缩写长度必须介于 0 和 64 之间")
	public String getSchoolShortName() {
		return schoolShortName;
	}

	public void setSchoolShortName(String schoolShortName) {
		this.schoolShortName = schoolShortName;
	}

	public String getSchoolUserId() {
		return schoolUserId;
	}

	public void setSchoolUserId(String schoolUserId) {
		this.schoolUserId = schoolUserId;
	}

	public String getSchoolMemberCode() {
		return schoolMemberCode;
	}

	public void setSchoolMemberCode(String schoolMemberCode) {
		this.schoolMemberCode = schoolMemberCode;
	}

	@Length(min=0, max=100, message="会员号长度必须介于 0 和 100 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min=0, max=64, message="负责人长度必须介于 0 和 64 之间")
	public String getResponsibler() {
		return responsibler;
	}

	public void setResponsibler(String responsibler) {
		this.responsibler = responsibler;
	}

	@Length(min=0, max=64, message="联系电话长度必须介于 0 和 64 之间")
	public String getTelephone() {
		return telephone;
	}

	public void setTelephone(String telephone) {
		this.telephone = telephone;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getStreet() {
		return street;
	}

	public void setStreet(String street) {
		this.street = street;
	}

	@Length(min=0, max=150, message="地址长度必须介于 0 和 150 之间")
	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	@Length(min=0, max=100, message="学校类别长度必须介于 0 和 100 之间")
	public String getSchoolType() {
		return schoolType;
	}

	public void setSchoolType(String schoolType) {
		this.schoolType = schoolType;
	}

	public String getSchoolNameEn() {
		return schoolNameEn;
	}

	public void setSchoolNameEn(String schoolNameEn) {
		this.schoolNameEn = schoolNameEn;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public Member getMember() {
		return member;
	}

	public void setMember(Member member) {
		this.member = member;
	}

	public Date getResponsiblerMemberEndDate() {
		return responsiblerMemberEndDate;
	}

	public void setResponsiblerMemberEndDate(Date responsiblerMemberEndDate) {
		this.responsiblerMemberEndDate = responsiblerMemberEndDate;
	}

	public Date getResponsiblerGroomerEndDate() {
		return responsiblerGroomerEndDate;
	}

	public void setResponsiblerGroomerEndDate(Date responsiblerGroomerEndDate) {
		this.responsiblerGroomerEndDate = responsiblerGroomerEndDate;
	}

	public String getResponsiblerMemberPayFlag() {
		return responsiblerMemberPayFlag;
	}

	public void setResponsiblerMemberPayFlag(String responsiblerMemberPayFlag) {
		this.responsiblerMemberPayFlag = responsiblerMemberPayFlag;
	}

	public String getSchoolMemberPayFlag() {
		return schoolMemberPayFlag;
	}

	public void setSchoolMemberPayFlag(String schoolMemberPayFlag) {
		this.schoolMemberPayFlag = schoolMemberPayFlag;
	}

	public String getSchoolWeb() {
		return schoolWeb;
	}

	public void setSchoolWeb(String schoolWeb) {
		this.schoolWeb = schoolWeb;
	}

	public String getDisplayOnWeb() {
		return displayOnWeb;
	}

	public void setDisplayOnWeb(String displayOnWeb) {
		this.displayOnWeb = displayOnWeb;
	}



	public String getAvatar() {
		return avatar;
	}

	public void setAvatar(String avatar) {
		this.avatar = avatar;
	}
	public String getIntroduce() {
		return introduce;
	}

	public void setIntroduce(String introduce) {
		this.introduce = introduce;
	}

	public String getCurriculumCount() {
		return curriculumCount;
	}

	public void setCurriculumCount(String curriculumCount) {
		this.curriculumCount = curriculumCount;
	}

	public String getFirstSchoolType() {
		return firstSchoolType;
	}

	public void setFirstSchoolType(String firstSchoolType) {
		this.firstSchoolType = firstSchoolType;
	}

	public String getAvatarBack() {
		return avatarBack;
	}

	public void setAvatarBack(String avatarBack) {
		this.avatarBack = avatarBack;
	}
}