package com.cku.oa.sys.web;

import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.service.OrgService;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;

/**
 * 单犬种俱乐部
 * @author yuanshuai
 * @version 2019年10月15日16:52:59
 */
@Controller
@RequestMapping(value = "${adminPath}/sys/singleOrg")
public class SingleTypeOrgController extends BaseController {

	@Autowired
	private OrgService orgService;
	@Autowired
	private DogTypeService dogTypeService;

	@ModelAttribute
	public Org get(@RequestParam(required=false) String id) {
		Org entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = orgService.get(id);
		}
		if (entity == null){
			entity = new Org();
		}
		return entity;
	}

	@RequiresPermissions("sys:singleOrg:view")
	@RequestMapping(value = {"list", ""})
	public String list(Org org, HttpServletRequest request, HttpServletResponse response, Model model) {
//		//只查询单犬种俱乐部的数据
		Page<Org> page = orgService.findPageBySingleType(new Page<>(request, response), org);
		model.addAttribute("page", page);
		model.addAttribute("currentDate",new Date());
		return "oa/sys/singleOrgList";
	}

	@RequiresPermissions("sys:singleOrg:add")
	@RequestMapping(value = "addForm")
	public String addForm(Org org, Model model) {
		org.setDisplayOnWeb("0");
		model.addAttribute("org", org);
		model.addAttribute("province",UserUtils.getProvince());
		model.addAttribute("city",UserUtils.getCityByProvince(org.getProvince()));
		model.addAttribute("dogTypeList",dogTypeService.findNoSingleList());
		return "oa/sys/singleOrgAddForm";
	}

	@RequiresPermissions("sys:singleOrg:edit")
	@RequestMapping(value = "editForm")
	public String editForm(Org org, Model model) {
		orgService.buildSingleTypeOrgData(org);
		model.addAttribute("org", org);
		model.addAttribute("province", UserUtils.getProvince());
		model.addAttribute("city", UserUtils.getCityByProvince(org.getProvince()));
		model.addAttribute("authorizedProvince", UserUtils.getCityByProvince(org.getAuthorizedProvince()));
		model.addAttribute("dogTypeList",dogTypeService.findNoSingleList());
		return "oa/sys/singleOrgEditForm";
	}

	@RequiresPermissions("sys:singleOrg:view")
	@RequestMapping(value = "save")
	public String save(Org org, Model model, RedirectAttributes redirectAttributes) {
		boolean hasPermission = false;
		if(StringUtils.isEmpty(org.getId())){
			hasPermission = SecurityUtils.getSubject().isPermitted("sys:singleOrg:add");
		}else{
			hasPermission = SecurityUtils.getSubject().isPermitted("sys:singleOrg:edit");
		}
		if(!hasPermission){
			throw new AuthorizationException("用户权限不足");
		}

		if (!beanValidator(model, org)){
			if(StringUtils.isEmpty(org.getId())) {
				return addForm(org, model);
			}else{
				return editForm(org, model);
			}
		}
		orgService.save(org);
		addMessage(redirectAttributes, "保存合作机构成功");
		return "redirect:"+Global.getAdminPath()+"/sys/singleOrg/?repage";
	}

	@RequiresPermissions("sys:singleOrg:coupon")
	@RequestMapping(value = "orgCouponCountForm")
	public String changeCouponCountForm(HttpServletRequest request, Model model) {
		String id = request.getParameter("id");
		String type = request.getParameter("type");
		Org org = orgService.get(id);
		orgService.buildSingleTypeOrgData(org);
		model.addAttribute("org", org);
		model.addAttribute("type", type);
		return "oa/sys/orgCouponCountForm";
	}

	@RequiresPermissions("sys:singleOrg:coupon")
	@RequestMapping(value = "changeCouponCount")
	@ResponseBody
	public void changeCouponCount(HttpServletRequest request, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, orgService.changeCouponCount(request));
	}
	
	
	@RequestMapping("search")
	public String search(Org org, HttpServletRequest request, HttpServletResponse response, Model model) {
		org.setOrgType("singleTypeClub");
		Page<Org> page = orgService.findPage(new Page<>(request, response), org);
		model.addAttribute("page", page);
		model.addAttribute("currentDate",new Date());
		return "oa/sys/singleSearch";
	}

}