package com.cku.oa.sys.util;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

import java.util.regex.Pattern;

public class PinYinUtil {

	/**
	 * 获取汉字串拼音首字母，英文字符不变
	 * 
	 * @param chinese
	 *            汉字串
	 * @return 汉语拼音首字母
	 */
	public static String getFirstSpell(String chinese) {
		StringBuffer pybf = new StringBuffer();
		char[] arr = chinese.toCharArray();
		HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
		defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
		defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
		defaultFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
		for (int i = 0; i < arr.length; i++) {
			if (arr[i] > 128) {
				try {
					String[] temp = PinyinHelper.toHanyuPinyinStringArray(
							arr[i], defaultFormat);
					if (temp != null) {
						pybf.append(temp[0].charAt(0));
					}
				} catch (BadHanyuPinyinOutputFormatCombination e) {
					e.printStackTrace();
				}
			} else {
				pybf.append(arr[i]);
			}
		}
		return pybf.toString().replaceAll("\\W", "").trim();
	}

	/**
	 * 获取汉字串拼音，英文字符不变
	 * 
	 * @param chinese
	 *            汉字串
	 * @return 汉语拼音
	 */
	public static String getFullSpell(String chinese) {
		StringBuilder sb = new StringBuilder();
		char[] arr = chinese.toCharArray();
		HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
		defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
		defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
		defaultFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
		String pinyin;
		for (int i = 0; i < arr.length; i++) {
			if (arr[i] > 128
					&& '·' != arr[i]
					&& '•' != arr[i]
					&& '，' != arr[i]
					&& '＆' != arr[i]
					&& '（' != arr[i]
					&& '）' != arr[i]) {
				try {
					pinyin = PinyinHelper.toHanyuPinyinStringArray(arr[i], defaultFormat)[0];
				} catch (BadHanyuPinyinOutputFormatCombination e) {
					e.printStackTrace();
					pinyin = "";
				} catch (Exception e){
					e.printStackTrace();
					pinyin = "";
				}
			} else {
				pinyin = String.valueOf(arr[i]);
			}
			//每个字符首字母大写，第二个单词与第一个单词之间有空格
			if (i == 1) {
				sb.append(" ").append(String.valueOf(pinyin.charAt(0)).toUpperCase().concat(pinyin.substring(1)));
			} else {
				sb.append(String.valueOf(pinyin.charAt(0)).toUpperCase().concat(pinyin.substring(1)));
			}
		}
		return sb.toString();
	}

	/**
	 * 是否为汉字，不包括标点符号
	 *
	 * @param str
	 * @return true 是汉字
	 */
	public static boolean isChinese(String str) {
		String chineseRegex = "[\u4e00-\u9fa5]";
		Pattern pattern = Pattern.compile(chineseRegex);
		for (int i = 0; i < str.length(); i = i + 1) {
			if (!pattern.matcher(String.valueOf(str.charAt(i))).find()) {
				return false;
			}
		}
		return true;
	}
}