/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.entity.user;

import java.util.Calendar;
import java.util.Date;

import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;

import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.entity.KennelAlliance;
import com.cku.oa.sys.util.ConstantUtils;
import com.cku.oa.tcb.entity.TcbKennel;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import com.thinkgem.jeesite.modules.sys.entity.User;

/**
 * 用户会员信息表Entity
 * 
 * @author fanhuibin
 * @version 2016-07-13
 */
public class Member extends DataEntity<Member> {

	private static final long serialVersionUID = 1L;
	private User user; // user_id
	private Kennel kennel;
	@ExcelField(title = "付款状态", align = 2, sort = 16)
	private String paymentState; // 缴费状态
	private String memberCode; // 会员号
	private String breedCode; // 繁殖编号
	@ExcelField(title = "会员类型", align = 2, sort = 15)
	private String memberType; // 会员类型
	private String memberCardType; // 会员卡片类型
	private String paymentInfo; // 最后的缴费记录
	private Date firstPaymentTime; // 第一次缴会员费时间
	private Date memberEndDate; // 会员截止时间
	private String kuFlag; // 犬舍联盟标记
	private Date kuEndDate; // 犬舍联盟身份过期日期
	private String groomerType; // 美容师类型
	private String groomerRemarks; // 美容师备注
	private Date groomerEndDate; // 美容师结束时间
	private String referee; // 推荐人
	private Date lastCall; // 最后电话联系时间
	private Date banEndDate; // 禁赛截至时间
	private String dgMemberType; // 犬运动会员类型
	private Date dgEndDate; // 犬运动会员结束时间
	private String ckuClub; // cku_club
	private String accountBalance; // 账户余额
	private String balanceBlockedFlag; // 余额冻结标记位：0未冻结；1已冻结
	@ExcelField(title = "姓名", align = 2, sort = 1)
	private String name; // 姓名
	private String email; // 邮箱
	private String phone; // 电话
	@ExcelField(title = "手机", align = 2, sort = 4)
	private String mobile; // 手机
	private String nameEn; // 英文姓名
	private String cardType; // 证件类型
	@ExcelField(title = "证件号", align = 2, sort = 5)
	private String cardNo; // 证件号
	@ExcelField(title = "性别", align = 2, sort = 2)
	private String gender; // 性别
	@ExcelField(title = "出生日期", align = 2, sort = 3)
	private Date birthday; // 出生日期
	@ExcelField(title = "省", align = 2, sort = 10)
	private String province; // 省
	@ExcelField(title = "市", align = 2, sort = 11)
	private String city; // 城市
	private String area; // 区
	@ExcelField(title = "街道", align = 2, sort = 13)
	private String street; // 街道
	private String address; // 详细的地址
	private String postcode; // 邮编
	private String qq; // QQ
	private String avatar; // 现在用于显示证件照，头像等信息请参考用户的user表
	private String fax; // 传真
	private String deliveryMagazine; // 杂志邮寄方式
	private String deliveryCertified; // 证书邮寄方式
	private String deliveryNotice; // 通知邮寄方式
	private String registrant; // 登记人
	private String registrantModifyFlag;//登记人修改标识
	private String printState; // 打印状态
	private String reviewState; // 审核状态
	private Date reviewDate; // 审核时间
	private String reviewer; // 审核人
	private String reviewerName;// 审核人姓名
	private KennelAlliance kennelAlliance; // 优生繁育犬舍联盟
	private String cardPhotoFornt;// 身份证照正面
	private String cardPhotoRear;// 身份证照反面

	private TcbKennel tcbKennel; // 淘宠宝犬舍
	private String contractCode;// 淘宠宝合同编号
	private String loginType; // 登录端

	private String freezeFlag; // 会员冻结标记位
	private String safeMobile; // 安全手机
	@ExcelField(title = "会员站点", align = 2, sort = 20)
	private String memberSite; // 会员站点（cku、ckudc.....）
	private String authentication; // 实名认证标识（1为认证通过，0或空为未通过）
	@ExcelField(title = "备注", align = 2, sort = 50)
	private String importRemark; // 导入用备注
	@ExcelField(title = "订单项目", align = 2, sort = 45)
	private String orderProject; // 导入用订单项目名称

	private String couponFlag; // 是否使用优惠券
	private String registerFlag;
	private String states;

	private String dogNoseRepeatedDetection;
	private String dogNoseLivenessDetection;

	private String loginName;
	private String loginMobile;
	private String userId;
	private String clubType;
	private String upMemberType;
	
	private String groomerCertificateFlag;
	
	private String certificateCode;
	private String certificateLevel;
	
	private String registerProvince;
	private String registerCity;
	private String registerArea;
	private String registerStreet;
	
	public String getDogNoseRepeatedDetection() {
		return dogNoseRepeatedDetection;
	}

	private Date firstStartTime; // 筛选条件中的起始日期
	private Date firstEndTime; // 筛选条件中的终止日期
	
	private String singleClubId;
	
	private String singleClub;

	public String getSingleClub() {
		return singleClub;
	}

	public void setSingleClub(String singleClub) {
		this.singleClub = singleClub;
	}

	public String getSingleClubId() {
		return singleClubId;
	}

	public void setSingleClubId(String singleClubId) {
		this.singleClubId = singleClubId;
	}

	public void setDogNoseRepeatedDetection(String dogNoseRepeatedDetection) {
		this.dogNoseRepeatedDetection = dogNoseRepeatedDetection;
	}

	public String getDogNoseLivenessDetection() {
		return dogNoseLivenessDetection;
	}

	public void setDogNoseLivenessDetection(String dogNoseLivenessDetection) {
		this.dogNoseLivenessDetection = dogNoseLivenessDetection;
	}

	public String getStates() {
		return states;
	}

	public void setStates(String states) {
		this.states = states;
	}

	public String getRegisterFlag() {
		return registerFlag;
	}

	public void setRegisterFlag(String registerFlag) {
		this.registerFlag = registerFlag;
	}

	public String getCouponFlag() {
		return couponFlag;
	}

	public void setCouponFlag(String couponFlag) {
		this.couponFlag = couponFlag;
	}

	public KennelAlliance getKennelAlliance() {
		return kennelAlliance;
	}

	public void setKennelAlliance(KennelAlliance kennelAlliance) {
		this.kennelAlliance = kennelAlliance;
	}

	public TcbKennel getTcbKennel() {
		return tcbKennel;
	}

	public void setTcbKennel(TcbKennel tcbKennel) {
		this.tcbKennel = tcbKennel;
	}

	public Member() {
		super();
	}

	public Member(String id) {
		super(id);
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	@Length(min = 0, max = 1, message = "缴费状态长度必须介于 0 和 1 之间")
	public String getPaymentState() {
		// start by 柴雪腾 修改会员支付状态 美容师会员有效 也是有效会员
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(new Date());
		calendar.add(Calendar.DAY_OF_MONTH, -1);
		Date currentDate = calendar.getTime();
		if (this.getMemberEndDate() != null && this.getMemberEndDate().getTime() > currentDate.getTime()) {
			paymentState = ConstantUtils.PAYMENT_PAID;
		} else if (this.getMemberEndDate() != null && this.getMemberEndDate().getTime() < currentDate.getTime()) {
			if (this.getGroomerEndDate() != null && this.getGroomerEndDate().getTime() < currentDate.getTime()) {
				paymentState = ConstantUtils.PAYMENT_UNPAID;
			} else if (this.getGroomerEndDate() != null && this.getGroomerEndDate().getTime() > currentDate.getTime()) {
				paymentState = ConstantUtils.PAYMENT_PAID;
			} else {
				paymentState = ConstantUtils.PAYMENT_UNPAID;
			}
		} else if (this.getMemberEndDate() == null) {
			if (this.getGroomerEndDate() != null && this.getGroomerEndDate().getTime() < currentDate.getTime()) {
				paymentState = ConstantUtils.PAYMENT_UNPAID;
			} else if (this.getGroomerEndDate() != null && this.getGroomerEndDate().getTime() > currentDate.getTime()) {
				paymentState = ConstantUtils.PAYMENT_PAID;
			}
		}
		// end by 柴雪腾 修改会员支付状态 美容师会员有效 也是有效会员
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@Length(min = 1, max = 60, message = "会员号长度必须介于 1 和 60 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min = 0, max = 50, message = "繁殖编号长度必须介于 0 和 50 之间")
	public String getBreedCode() {
		return breedCode;
	}

	public void setBreedCode(String breedCode) {
		this.breedCode = breedCode;
	}

	@Length(min = 0, max = 50, message = "会员类型长度必须介于 0 和 50 之间")
	public String getMemberType() {
		return memberType;
	}

	public void setMemberType(String memberType) {
		this.memberType = memberType;
	}

	@Length(min = 0, max = 255, message = "最后的缴费记录长度必须介于 0 和 255 之间")
	public String getPaymentInfo() {
		return paymentInfo;
	}

	public void setPaymentInfo(String paymentInfo) {
		this.paymentInfo = paymentInfo;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getFirstPaymentTime() {
		return firstPaymentTime;
	}

	public void setFirstPaymentTime(Date firstPaymentTime) {
		this.firstPaymentTime = firstPaymentTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getMemberEndDate() {
		return memberEndDate;
	}

	public void setMemberEndDate(Date memberEndDate) {
		this.memberEndDate = memberEndDate;
	}

	@Length(min = 0, max = 1, message = "犬舍联盟标记长度必须介于 0 和 1 之间")
	public String getKuFlag() {
		return kuFlag;
	}

	public void setKuFlag(String kuFlag) {
		this.kuFlag = kuFlag;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getKuEndDate() {
		return kuEndDate;
	}

	public void setKuEndDate(Date kuEndDate) {
		this.kuEndDate = kuEndDate;
	}

	@Length(min = 0, max = 50, message = "美容师类型长度必须介于 0 和 50 之间")
	public String getGroomerType() {
		return groomerType;
	}

	public void setGroomerType(String groomerType) {
		this.groomerType = groomerType;
	}

	@Length(min = 0, max = 255, message = "美容师备注长度必须介于 0 和 255 之间")
	public String getGroomerRemarks() {
		return groomerRemarks;
	}

	public void setGroomerRemarks(String groomerRemarks) {
		this.groomerRemarks = groomerRemarks;
	}

	@Length(min = 0, max = 100, message = "推荐人长度必须介于 0 和 100 之间")
	public String getReferee() {
		return referee;
	}

	public void setReferee(String referee) {
		this.referee = referee;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getLastCall() {
		return lastCall;
	}

	public void setLastCall(Date lastCall) {
		this.lastCall = lastCall;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getBanEndDate() {
		return banEndDate;
	}

	public void setBanEndDate(Date banEndDate) {
		this.banEndDate = banEndDate;
	}

	@Length(min = 0, max = 10, message = "犬运动会员类型长度必须介于 0 和 10 之间")
	public String getDgMemberType() {
		return dgMemberType;
	}

	public void setDgMemberType(String dgMemberType) {
		this.dgMemberType = dgMemberType;
	}

	public Date getGroomerEndDate() {
		return groomerEndDate;
	}

	public void setGroomerEndDate(Date groomerEndDate) {
		this.groomerEndDate = groomerEndDate;
	}

	public Date getDgEndDate() {
		return dgEndDate;
	}

	public void setDgEndDate(Date dgEndDate) {
		this.dgEndDate = dgEndDate;
	}

	@Length(min = 0, max = 100, message = "cku_club长度必须介于 0 和 100 之间")
	public String getCkuClub() {
		return ckuClub;
	}

	public void setCkuClub(String ckuClub) {
		this.ckuClub = ckuClub;
	}

	public String getAccountBalance() {
		return accountBalance;
	}

	public void setAccountBalance(String accountBalance) {
		this.accountBalance = accountBalance;
	}

	public String getBalanceBlockedFlag() {
		return balanceBlockedFlag;
	}

	public void setBalanceBlockedFlag(String balanceBlockedFlag) {
		this.balanceBlockedFlag = balanceBlockedFlag;
	}

	@NotNull(message = "姓名不能为空")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Length(min = 0, max = 200, message = "邮箱长度必须介于 0 和 200 之间")
	@Email(message = "电子邮箱格式不符合要求")
	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	@Length(min = 0, max = 200, message = "电话长度必须介于 0 和 200 之间")
	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	@Length(min = 0, max = 200, message = "手机长度必须介于 0 和 200 之间")
	@NotNull(message = "手机号不能为空")
	public String getMobile() {
		return mobile;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}

	@Length(min = 0, max = 100, message = "英文姓名长度必须介于 0 和 100 之间")
	public String getNameEn() {
		return nameEn;
	}

	public void setNameEn(String nameEn) {
		this.nameEn = nameEn;
	}

	@Length(min = 0, max = 100, message = "证件类型长度必须介于 0 和 100 之间")
	public String getCardType() {
		return cardType;
	}

	public void setCardType(String cardType) {
		this.cardType = cardType;
	}

	@Length(min = 0, max = 50, message = "证件号长度必须介于 0 和 50 之间")
	@NotNull(message = "证件号不能为空")
	public String getCardNo() {
		return cardNo;
	}

	public void setCardNo(String cardNo) {
		this.cardNo = cardNo;
	}

	@Length(min = 0, max = 30, message = "性别长度必须介于 0 和 30 之间")
	@NotNull(message = "性别不能为空")
	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getBirthday() {
		return birthday;
	}

	public void setBirthday(Date birthday) {
		this.birthday = birthday;
	}

	@Length(min = 0, max = 50, message = "省长度必须介于 0 和 50 之间")
	@NotNull(message = "省份不能为空")
	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	@Length(min = 0, max = 50, message = "城市长度必须介于 0 和 50 之间")
	@NotNull(message = "城市不能为空")
	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}

	@Length(min = 0, max = 200, message = "街道长度必须介于 0 和 200 之间")
	@NotNull(message = "详细地址不能为空")
	public String getStreet() {
		return street;
	}

	public void setStreet(String street) {
		this.street = street;
	}

	@Length(min = 0, max = 255, message = "详细的地址长度必须介于 0 和 255 之间")
	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	@Length(min = 0, max = 60, message = "邮编长度必须介于 0 和 60 之间")
	public String getPostcode() {
		return postcode;
	}

	public void setPostcode(String postcode) {
		this.postcode = postcode;
	}

	@Length(min = 0, max = 50, message = "QQ长度必须介于 0 和 50 之间")
	public String getQq() {
		return qq;
	}

	public void setQq(String qq) {
		this.qq = qq;
	}

	@Length(min = 0, max = 255, message = "头像长度必须介于 0 和 255 之间")
	public String getAvatar() {
		return avatar;
	}

	public void setAvatar(String avatar) {
		this.avatar = avatar;
	}

	public Kennel getKennel() {
		return kennel;
	}

	public void setKennel(Kennel kennel) {
		this.kennel = kennel;
	}

	public String getFax() {
		return fax;
	}

	public void setFax(String fax) {
		this.fax = fax;
	}

	public String getDeliveryMagazine() {
		return deliveryMagazine;
	}

	public void setDeliveryMagazine(String deliveryMagazine) {
		this.deliveryMagazine = deliveryMagazine;
	}

	public String getDeliveryCertified() {
		return deliveryCertified;
	}

	public void setDeliveryCertified(String deliveryCertified) {
		this.deliveryCertified = deliveryCertified;
	}

	public String getDeliveryNotice() {
		return deliveryNotice;
	}

	public void setDeliveryNotice(String deliveryNotice) {
		this.deliveryNotice = deliveryNotice;
	}

	public String getRegistrant() {
		return registrant;
	}

	public void setRegistrant(String registrant) {
		this.registrant = registrant;
	}

	public String getRegistrantModifyFlag() {
		return registrantModifyFlag;
	}

	public void setRegistrantModifyFlag(String registrantModifyFlag) {
		this.registrantModifyFlag = registrantModifyFlag;
	}

	public String getPrintState() {
		return printState;
	}

	public void setPrintState(String printState) {
		this.printState = printState;
	}

	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}

	public Date getReviewDate() {
		return reviewDate;
	}

	public void setReviewDate(Date reviewDate) {
		this.reviewDate = reviewDate;
	}

	public String getReviewer() {
		return reviewer;
	}

	public void setReviewer(String reviewer) {
		this.reviewer = reviewer;
	}

	public String getReviewerName() {
		return reviewerName;
	}

	public void setReviewerName(String reviewerName) {
		this.reviewerName = reviewerName;
	}

	public String getCardPhotoFornt() {
		return cardPhotoFornt;
	}

	public String getCardPhotoRear() {
		return cardPhotoRear;
	}

	public void setCardPhotoFornt(String cardPhotoFornt) {
		this.cardPhotoFornt = cardPhotoFornt;
	}

	public void setCardPhotoRear(String cardPhotoRear) {
		this.cardPhotoRear = cardPhotoRear;
	}

	@Length(min = 0, max = 255, message = "淘宠宝合同编号必须介于 0 和 255 之间")
	public String getContractCode() {
		return contractCode;
	}

	public void setContractCode(String contractCode) {
		this.contractCode = contractCode;
	}

	public String getLoginType() {
		return loginType;
	}

	public void setLoginType(String loginType) {
		this.loginType = loginType;
	}

	public String getFreezeFlag() {
		return freezeFlag;
	}

	public void setFreezeFlag(String freezeFlag) {
		this.freezeFlag = freezeFlag;
	}

	public String getSafeMobile() {
		return safeMobile;
	}

	public void setSafeMobile(String safeMobile) {
		this.safeMobile = safeMobile;
	}

	public String getAuthentication() {
		return authentication;
	}

	public void setAuthentication(String authentication) {
		this.authentication = authentication;
	}

	public String getMemberSite() {
		return memberSite;
	}

	public void setMemberSite(String memberSite) {
		this.memberSite = memberSite;
	}

	public String getImportRemark() {
		return importRemark;
	}

	public void setImportRemark(String importRemark) {
		this.importRemark = importRemark;
	}

	public String getOrderProject() {
		return orderProject;
	}

	public void setOrderProject(String orderProject) {
		this.orderProject = orderProject;
	}

	public String getMemberCardType() {
		return memberCardType;
	}

	public void setMemberCardType(String memberCardType) {
		this.memberCardType = memberCardType;
	}

	public String getLoginName() {
		return loginName;
	}

	public void setLoginName(String loginName) {
		this.loginName = loginName;
	}

	public String getLoginMobile() {
		return loginMobile;
	}

	public void setLoginMobile(String loginMobile) {
		this.loginMobile = loginMobile;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getClubType() {
		return clubType;
	}

	public void setClubType(String clubType) {
		this.clubType = clubType;
	}
	public String getUpMemberType() {
		return upMemberType;
	}

	public void setUpMemberType(String upMemberType) {
		this.upMemberType = upMemberType;
	}

	@Override
	public String toString() {
		return "Member [id="+this.getId()+"memberCode=" + memberCode + ", memberType=" + memberType + ", name=" + name + ", avatar="
				+ avatar + ", loginName=" + loginName + ", loginMobile=" + loginMobile + ", userId=" + userId
				+ ", clubType=" + clubType + "]";
	}

	public String getGroomerCertificateFlag() {
		return groomerCertificateFlag;
	}

	public void setGroomerCertificateFlag(String groomerCertificateFlag) {
		this.groomerCertificateFlag = groomerCertificateFlag;
	}

	public String getCertificateCode() {
		return certificateCode;
	}

	public void setCertificateCode(String certificateCode) {
		this.certificateCode = certificateCode;
	}

	public String getCertificateLevel() {
		return certificateLevel;
	}

	public void setCertificateLevel(String certificateLevel) {
		this.certificateLevel = certificateLevel;
	}

	public Date getFirstStartTime() {
		return firstStartTime;
	}

	public void setFirstStartTime(Date firstStartTime) {
		this.firstStartTime = firstStartTime;
	}

	public Date getFirstEndTime() {
		return firstEndTime;
	}

	public void setFirstEndTime(Date firstEndTime) {
		this.firstEndTime = firstEndTime;
	}

	public String getRegisterProvince() {
		return registerProvince;
	}

	public void setRegisterProvince(String registerProvince) {
		this.registerProvince = registerProvince;
	}

	public String getRegisterCity() {
		return registerCity;
	}

	public void setRegisterCity(String registerCity) {
		this.registerCity = registerCity;
	}

	public String getRegisterArea() {
		return registerArea;
	}

	public void setRegisterArea(String registerArea) {
		this.registerArea = registerArea;
	}

	public String getRegisterStreet() {
		return registerStreet;
	}

	public void setRegisterStreet(String registerStreet) {
		this.registerStreet = registerStreet;
	}
	
	
}