/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 用户登录日志Entity
 * @author yuanshuai
 * @version 2018-12-07
 */
public class SysUserLoginLog extends DataEntity<SysUserLoginLog> {
	
	private static final long serialVersionUID = 1L;
	private String remoteAddr;		// 操作IP地址
	private String userAgent;		// 用户代理
	
	public SysUserLoginLog() {
		super();
	}

	public SysUserLoginLog(String id){
		super(id);
	}

	@Length(min=0, max=255, message="操作IP地址长度必须介于 0 和 255 之间")
	public String getRemoteAddr() {
		return remoteAddr;
	}

	public void setRemoteAddr(String remoteAddr) {
		this.remoteAddr = remoteAddr;
	}
	
	@Length(min=0, max=255, message="用户代理长度必须介于 0 和 255 之间")
	public String getUserAgent() {
		return userAgent;
	}

	public void setUserAgent(String userAgent) {
		this.userAgent = userAgent;
	}
	
}