/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.web;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.show.entity.ShowJudge;
import com.cku.oa.show.entity.ShowResultsDdz;
import com.cku.oa.show.service.ChildShowsService;
import com.cku.oa.show.service.ShowJudgeService;
import com.cku.oa.show.service.ShowResultsDdzService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 单独展犬展成绩Controller
 * @author lgl
 * @version 2016-07-21
 */
@Controller
@RequestMapping(value = "${adminPath}/results/showResultsDdz")
public class ShowResultsDdzController extends BaseController {

	@Autowired
	private ShowResultsDdzService showResultsDdzService;
	@Autowired
	private ChildShowsService childShowsService;
	@Autowired
	private ShowJudgeService showJudgeService;
	
	private final static String AUTHORITY_PRDFIX = "results:showResultsDdz:";
	
	@ModelAttribute
	public ShowResultsDdz get(@RequestParam(required=false) String id) {
		ShowResultsDdz entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = showResultsDdzService.get(id);
		}
		if (entity == null){
			entity = new ShowResultsDdz();
		}
		return entity;
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX+"view")
	@RequestMapping(value = {"list", ""})
	public String list(ShowResultsDdz showResultsDdz, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ShowResultsDdz> page = showResultsDdzService.findPage(new Page<ShowResultsDdz>(request, response), showResultsDdz); 
		model.addAttribute("page", page);
		return "oa/show/results/showResultsDdzList";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX+"view")
	@RequestMapping(value = "form")
	public String form(ShowResultsDdz showResultsDdz, Model model) {
		List<String> showCodeList = childShowsService.findShowCodeList("1");
		model.addAttribute("showCodeList", showCodeList);
		List<ShowJudge> showJudgeList = showJudgeService.findAllShowJudge();
		model.addAttribute("showJudgeList", showJudgeList);
		model.addAttribute("showResultsDdz", showResultsDdz);
		return "oa/show/results/showResultsDdzForm";
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX+"edit")
	@RequestMapping(value = "editForm")
	public String editForm(ShowResultsDdz showResultsDdz, Model model) {
		List<String> showCodeList = childShowsService.findShowCodeList("1");
		model.addAttribute("showCodeList", showCodeList);
		List<ShowJudge> showJudgeList = showJudgeService.findAllShowJudge();
		model.addAttribute("showJudgeList", showJudgeList);
		
		if(!StringUtils.isEmpty(showResultsDdz.getResultCc())) {
			showResultsDdz.setResultCcs(showResultsDdz.getResultCc().split("/"));
		}
		model.addAttribute("showResultsDdz", showResultsDdz);
		return "oa/show/results/showResultsDdzEditForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX+"edit")
	@RequestMapping(value = "save")
	public String save(ShowResultsDdz showResultsDdz, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, showResultsDdz)){
			return form(showResultsDdz, model);
		}
		if (!(showResultsDdz.getResultCcs() == null || showResultsDdz.getResultCcs().length == 0)) {
			String ccStr = "";
			for (String cc : showResultsDdz.getResultCcs()) {
				ccStr += cc + "/";
			}
			ccStr = ccStr.substring(0, ccStr.length() - 1);
			showResultsDdz.setResultCc(ccStr);
		}
		showResultsDdzService.save(showResultsDdz);
		addMessage(redirectAttributes, "保存单独展犬展成绩成功");
		return "redirect:"+Global.getAdminPath()+"/results/showResultsDdz/?repage";
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX+"delete")
	@RequestMapping(value = "delete")
	public String delete(ShowResultsDdz showResultsDdz, RedirectAttributes redirectAttributes) {
		showResultsDdzService.delete(showResultsDdz);
		addMessage(redirectAttributes, "删除单独展犬展成绩成功");
		return "redirect:"+Global.getAdminPath()+"/results/showResultsDdz/?repage";
	}
	
	/**
	 * 导入犬展成绩数据
	 * @param file
	 * @param redirectAttributes
	 * @return
	 */
	@RequiresPermissions(AUTHORITY_PRDFIX+"add")
    @RequestMapping(value = "import", method=RequestMethod.POST)
    public String importFile(MultipartFile file, RedirectAttributes redirectAttributes) {
		try {
			int count = showResultsDdzService.importShowResultsDdz(file);
			addMessage(redirectAttributes, "导入单独展犬展成绩成功，共导入"+count+"条记录。");
		} catch (Exception e) {
			addMessage(redirectAttributes, "导入单独展犬展成绩失败！失败信息："+e.getMessage());
		}
		return "redirect:"+Global.getAdminPath()+"/results/showResultsDdz/?repage";
    }

}