/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.dao;

import com.cku.oa.show.entity.ShowApply;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 赛事报名表DAO接口
 *
 * @author lgl
 * @version 2016-07-15
 */
@MyBatisDao
public interface ShowApplyDao extends CrudDao<ShowApply> {

	int listCount(ShowApply showApply);

	public List<ShowApply> findUnpayShowApplyByPedigreeCertified(ShowApply showApply);

	public void updateRefundAbsenceFlag(ShowApply showApply);

	public List<ShowApply> exportShowApply(String showCode);

	public List<ShowApply> findByPedigreeCertifiedAndShowCode(ShowApply showApply);

	public Map<String,Integer> countByShowCode(@Param("showCode") String showCode);

	/**
	 *
	 * @description: 根据赛事编号和血统证书号查询条数
	 * @author: laiguanglong
	 * @date: 2016年10月19日 下午2:41:56
	 */
	int countByShowCodeAndPedigreeCertified(@Param("showCode") String showCode,
			@Param("pedigreeCertified") String pedigreeCertified);

	/**
	 *
	 * @description: 根据主赛事id，把该主赛事下所有的报名信息标记为已过期
	 * @author: laiguanglong
	 * @date: 2016年12月5日 上午11:36:50
	 */
	void expireByMainShowId(@Param("mainShowId") String mainShowId);

	// 根据会员号查询参赛记录数
	int countByMemberCodeCurrentYear(@Param("memberCode") String memberCode);

	/**
	 * @description: 根据主赛事id，查询报名记录数
	 * @author: laiguanglong
	 * @date: 2017/7/25 11:41
	 */
	long countByMainShowId(@Param("mainShowId") String mainShowId,
			@Param("pedigreeCertified") String pedigreeCertified);

	void refundShowApply(@Param("vo") ShowApply vo, @Param("ids") List<String> ids);

	ShowApply getByShowCodeAndPedigreeCertified(@Param("pedigreeCertified") String pedigreeCertified, @Param("showCode") String showCode);

	ShowApply getByRunningNumber( @Param("runningNumber") String runningNumber);

	ShowApply getByShowMainIdAndPedigreeCertified(@Param("showMainId")String showMainId, @Param("pedigreeCertified")String pedigreeCertified);
	
	int countByShowMainIdAndShowCode(@Param("showMainId")String showMainId, @Param("showCode")String showCode);
	/**
	 * 根据赛事编号查询未退款的有效报名记录
	 * @param showCode
	 * @return
	 */
	List<ShowApply> getListByShowCode(String showCode);
	
	List<ShowApply> findUnpaidListByDogOwnerMemberCode(@Param("dogOwnerMemberCode")String dogOwnerMemberCode);
	
	ShowApply findByQusInfo(@Param("showCode")String showCode,@Param("pedigreeCertified")String pedigreeCertified);

	/**
	 * 根据证书号查已经完成的赛事数量
	 * @author yuanshuai
	 * @date 2023/8/10 15:26
	 */
	int finishShowApplyCount(@Param("pedigreeCertified")String pedigreeCertified);
	

	Date getMinDateByShowCodes(@Param("showCodes") List<String> showCodes);
}