package com.cku.oa.shop.service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.shop.dao.ShopUserMoneyDao;
import com.cku.oa.shop.entity.ShopUserMoney;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.util.MemberUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 商城用户钱Service
 * @author lyy
 * @version 2016-08-24
 */
@Service
@Transactional(readOnly = true)
public class ShopUserMoneyService extends CrudService<ShopUserMoneyDao, ShopUserMoney> {
	public static final String REBATE = "rebate";
	@Autowired
	private MemberDao memberDao;
	public ShopUserMoney get(String id) {
		return super.get(id);
	}
	
	public List<ShopUserMoney> findList(ShopUserMoney shopUserMoney) {
		return super.findList(shopUserMoney);
	}
	
	public Page<ShopUserMoney> findPage(Page<ShopUserMoney> page, ShopUserMoney shopUserMoney) {
		return super.findPage(page, shopUserMoney);
	}
	@Transactional(readOnly = false)
	public void save(ShopUserMoney shopUserMoney) {
		super.save(shopUserMoney);
	}
	public ShopUserMoney getByMemberCode(String memberCode){
		return dao.getByMemberCode(memberCode);
	}
	@Transactional(readOnly = false)
	public void delete(ShopUserMoney shopUserMoney) {
		super.delete(shopUserMoney);
	}
	/**
	 *	商城会员扣费
	 * @param memberCode
	 * @param chargeAcmount 扣费金额
	 * @param type 返利，余额
	 * @return
	 */
	@Transactional(readOnly = false)
	public void memberCharge(String memberCode,String chargeAcmount,String type)  throws ZAException{
		ShopUserMoney shopUserMoney = dao.getByMemberCode(memberCode);
		Member member = memberDao.getByMemberCode(memberCode);
		int result = 0;
		//会员是否有效
		//if(MemberUtil.isActiveMember(member)){
			String userMoney = "0";
			if(!REBATE.equals(type)){
				userMoney = shopUserMoney.getUserMoney();
			}else{
				userMoney = shopUserMoney.getRebateMoney();
			}
			BigDecimal ab = new BigDecimal(userMoney);
			BigDecimal ca = new BigDecimal(chargeAcmount);
			if(ab.compareTo(ca)<0){
				throw new ZAException(ZAErrorCode.ZA_ERC_PAYMENTRECORD_MEMBERMONEY_STATE,"商城会员"+("rebate".equals(type)?"返利":"")+"余额不足！");
			};
			//TODO 下面的代码有并发的风险，钱不能这么算，这是开玩笑。要学数据库基础，脏读、幻读、不可重复读  fanhuibin
			//TODO 后来者要注意，绝对不能这么写，绝对要改，我下午还要上线，没辙，放过他了。但是这就是个坑
			result = dao.memberCharge(memberCode,chargeAcmount,type);
			if(result<=0){
				throw new ZAException(ZAErrorCode.ZA_ERC_PAYMENTRECORD_MEMBERUPDATEFAIL_STATE,"修改商城会员"+("rebate".equals(type)?"返利":"")+"余额失败！");
			}
		//}else{
		//	throw new ZAException(ZAErrorCode.ZA_ERC_MEMBER_INVALID,"会员无效！");
		//}
	}

	/**
	 * 商城会员充值
	 * @param memberCode
	 * @param rechargeAmount
	 * @param paymentTime
	 * @return
	 */
	@Transactional(readOnly = false)
	public void memberRecharge(String memberCode,String rechargeAmount,Date paymentTime,String type) throws ZAException{
		int result = 0;
		ShopUserMoney shopUserMoney = dao.getByMemberCode(memberCode);
		//商城用户钱表无数据
		if(shopUserMoney==null){
			//新建数据
			shopUserMoney = new ShopUserMoney();
			shopUserMoney.setMemberCode(memberCode);
			shopUserMoney.setCommunity("");
			shopUserMoney.setIsRebate("0");
			shopUserMoney.setUserMoney("0");
			shopUserMoney.setRebateMoney("0");
			save(shopUserMoney);
		}
		//TODO 下面的代码有并发的风险，钱不能这么算，这是开玩笑。要学数据库基础，脏读、幻读、不可重复读 fanhuibin
		//TODO 后来者要注意，绝对不能这么写，绝对要改，我下午还要上线，没辙，放过他了。但是这就是个坑
		result = dao.memberRecharge(memberCode,rechargeAmount,paymentTime,type);
		if(result<=0){
			throw new ZAException(ZAErrorCode.ZA_ERC_PAYMENTRECORD_MEMBERUPDATEFAIL_STATE,"修改商城会员余额失败！");
		}
	}
}