/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.shop.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 商城充值流水Entity
 * @author lyy
 * @version 2016-08-23
 */
public class ShopPayRecord extends DataEntity<ShopPayRecord> {

	private static final long serialVersionUID = 1L;
	private String paymentType;		// 支付类别
	private String paymentWay;		// 支付方式
	private Date paymentTime;		// 支付时间
	private String paymentMoney;		// 钱数
	private String shopOrderCode;		// 订单编号
	private String memberCode;		// 会员编号
	private String paymentRemarks;	//备注
	private String outTradeNo;		//支付宝参数

	public ShopPayRecord() {
		super();
	}

	public ShopPayRecord(String id){
		super(id);
	}

	@Length(min=0, max=2, message="支付类别长度必须介于 0 和 2 之间")
	public String getPaymentType() {
		return paymentType;
	}

	public void setPaymentType(String paymentType) {
		this.paymentType = paymentType;
	}

	@Length(min=0, max=50, message="支付方式长度必须介于 0 和 50 之间")
	public String getPaymentWay() {
		return paymentWay;
	}

	public void setPaymentWay(String paymentWay) {
		this.paymentWay = paymentWay;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	public String getPaymentMoney() {
		return paymentMoney;
	}

	public void setPaymentMoney(String paymentMoney) {
		this.paymentMoney = paymentMoney;
	}

	@Length(min=0, max=64, message="订单编号长度必须介于 0 和 64 之间")
	public String getShopOrderCode() {
		return shopOrderCode;
	}

	public void setShopOrderCode(String shopOrderCode) {
		this.shopOrderCode = shopOrderCode;
	}

	@Length(min=0, max=64, message="会员编号长度必须介于 0 和 64 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	@Length(min=0, max=255, message="备注长度必须介于 0 和 255 之间")
	public String getPaymentRemarks() {
		return paymentRemarks;
	}

	public void setPaymentRemarks(String paymentRemarks) {
		this.paymentRemarks = paymentRemarks;
	}
	@Length(min=0, max=100, message="备注长度必须介于 0 和 100 之间")
	public String getOutTradeNo() {
		return outTradeNo;
	}

	public void setOutTradeNo(String outTradeNo) {
		this.outTradeNo = outTradeNo;
	}
}