package com.cku.oa.order.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.common.SysBusinessIdConstants;
import com.cku.oa.dog.entity.DogDnaParentsCompare;
import com.cku.oa.dog.service.DogDnaParentsCompareAuditService;
import com.cku.oa.dog.service.DogDnaParentsCompareService;
import com.cku.oa.order.service.BaseSkuBusinessService;
import com.cku.oa.order.vo.DnaParentsCompareBusinessVo;
import com.cku.oa.order.vo.OrderSkuVo;
import com.cku.restful.v2.order.vo.request.OrderApplyRequest;

/**
 * DNA亲子比对处理类
 *
 * @author yuanshuai
 * @date 2023/6/18 15:19
 */
@Service
public class DnaParentsCompareOrderServiceImpl extends BaseSkuBusinessService<DnaParentsCompareBusinessVo> {

	@Autowired
	private DogDnaParentsCompareService dogDnaParentsCompareService;

	@Autowired
	private DogDnaParentsCompareAuditService dogDnaParentsCompareAuditService;

	@Override
	@Transactional(readOnly = false)
	public void processBusinessPrePay(OrderApplyRequest orderRequest, DnaParentsCompareBusinessVo businessData,
			OrderSkuVo skuVo) {
		// 根据不同业务处理入口
		if (SysBusinessIdConstants.GOLD_CERTIFIED.equals(orderRequest.getBusinessID())) {
			// 处理金质证书
			DogDnaParentsCompare dogDnaParentsCompare = processBusinessByGoldCertified(businessData, skuVo);
			// 增加父母犬主审核
			dogDnaParentsCompareAuditService.save(dogDnaParentsCompare.getBirthCode(), dogDnaParentsCompare.getId(),dogDnaParentsCompare.getApplySource());
		}
	}

	/**
	 * 根据金质证书处理业务
	 *
	 * @author yuanshuai
	 * @date 2023/6/20 16:30
	 */
	private DogDnaParentsCompare processBusinessByGoldCertified(DnaParentsCompareBusinessVo businessData,
			OrderSkuVo skuVo) {
		DogDnaParentsCompare dogDnaParentsCompare = buildDnaParentsCompareByGoldCertified(businessData, skuVo);
		dogDnaParentsCompareService.save(dogDnaParentsCompare);
		return dogDnaParentsCompare;
	}

	/**
	 * 根据金质证书构建DNA亲子比对
	 *
	 * @author yuanshuai
	 * @date 2023/6/20 16:22
	 */
	private DogDnaParentsCompare buildDnaParentsCompareByGoldCertified(DnaParentsCompareBusinessVo businessData,
			OrderSkuVo skuVo) {
		DogDnaParentsCompare dogDnaParentsCompare = new DogDnaParentsCompare();
		dogDnaParentsCompare.setApplySource(businessData.getApplySource());
		dogDnaParentsCompare.setPedigreeCertified(businessData.getPedigreeCertified());
		dogDnaParentsCompare.setBirthCode(businessData.getBirthCode());
		dogDnaParentsCompare.setPaymentMemberCode(skuVo.getMember().getMemberCode());
		dogDnaParentsCompare.setPrice(skuVo.getUnitPrice().toString());
		dogDnaParentsCompare.setRunningNumber(skuVo.getOrderCode());
		dogDnaParentsCompare.setReviewState("0");
		dogDnaParentsCompare.setPaymentState("1");
		return dogDnaParentsCompare;
	}

}
