package com.cku.oa.groomer.web;

import java.util.List;
import java.util.Objects;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections.CollectionUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.oa.groomer.entity.GroomerForeignRegister;
import com.cku.oa.groomer.service.GroomerForeignRegisterService;
import com.cku.oa.sys.entity.user.Member;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 国外美容考试结果Controller
 * 
 * @author Sunny
 * @version 2024-01-11
 */
@Controller
@RequestMapping(value = "${adminPath}/groomer/groomerForeignRegister")
public class GroomerForeignRegisterController extends BaseController {

	@Autowired
	private GroomerForeignRegisterService groomerForeignRegisterService;

	@ModelAttribute
	public GroomerForeignRegister get(@RequestParam(required = false) String id) {
		GroomerForeignRegister entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = groomerForeignRegisterService.get(id);
		}
		if (entity == null) {
			entity = new GroomerForeignRegister();
		}
		return entity;
	}

	@RequiresPermissions("groomer:groomerForeignRegister:view")
	@RequestMapping(value = { "list", "" })
	public String list(GroomerForeignRegister groomerForeignRegister, HttpServletRequest request,
			HttpServletResponse response, Model model) {
		if (Objects.nonNull(groomerForeignRegister) && Objects.nonNull(groomerForeignRegister.getSpecificDate())) {
			groomerForeignRegister
					.setSpecificDateStr(DateUtils.formatDate(groomerForeignRegister.getSpecificDate(), "yyyy-MM"));
		}
		Page<GroomerForeignRegister> page = groomerForeignRegisterService
				.findPage(new Page<GroomerForeignRegister>(request, response), groomerForeignRegister);
		model.addAttribute("page", page);
		return "oa/groomer/groomerForeignRegisterList";
	}

	@RequiresPermissions("groomer:groomerForeignRegister:view")
	@RequestMapping(value = "form")
	public String form(GroomerForeignRegister groomerForeignRegister, Model model) {
		model.addAttribute("groomerForeignRegister", groomerForeignRegister);
		return "oa/groomer/groomerForeignRegisterForm";
	}

	@RequiresPermissions("groomer:groomerForeignRegister:edit")
	@RequestMapping(value = "save")
	public String save(GroomerForeignRegister groomerForeignRegister, Model model,
			RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, groomerForeignRegister)) {
			return form(groomerForeignRegister, model);
		}
		groomerForeignRegisterService.save(groomerForeignRegister);
		addMessage(redirectAttributes, "保存国外美容考试结果成功");
		return "redirect:" + Global.getAdminPath() + "/groomer/groomerForeignRegister/?repage";
	}

	@RequiresPermissions("groomer:groomerForeignRegister:edit")
	@RequestMapping(value = "delete")
	public String delete(GroomerForeignRegister groomerForeignRegister, RedirectAttributes redirectAttributes) {
		groomerForeignRegisterService.delete(groomerForeignRegister);
		addMessage(redirectAttributes, "删除国外美容考试结果成功");
		return "redirect:" + Global.getAdminPath() + "/groomer/groomerForeignRegister/?repage";
	}

	@RequiresPermissions("groomer:groomerForeignRegister:edit")
	@RequestMapping(value = "import/form")
	public String bindForm(Member member, Model model) {
		return "oa/groomer/groomerForeignRegisterImport";
	}

	@ResponseBody
	@RequiresPermissions("groomer:groomerForeignRegister:edit")
	@RequestMapping(value = "import", method = RequestMethod.POST)
	public ResultDto<Boolean> importFile(GroomerForeignRegister groomerForeignRegister, MultipartFile file) {
		try {
			groomerForeignRegisterService.importFile(groomerForeignRegister, file);
		} catch (Exception e) {
			return ResultDto.error(ZAErrorCode.ZA_ERROR, e.getMessage());
		}
		return ResultDto.success(Boolean.TRUE);
	}

	@RequiresPermissions("groomer:groomerForeignRegister:edit")
	@RequestMapping(value = "import/template", method = RequestMethod.GET)
	public String importTemplate(HttpServletResponse response, RedirectAttributes redirectAttributes) {
		try {
			return groomerForeignRegisterService.importTemplate(response);
		} catch (Exception e) {
			addMessage(redirectAttributes, "导入模板下载失败！失败信息：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/groomer/groomerForeignRegister/list/?repage";
	}

	@ResponseBody
	@RequiresPermissions("groomer:groomerForeignRegister:edit")
	@RequestMapping(value = "batchDelete", method = RequestMethod.POST)
	public ResultDto<Boolean> batchDelete(@RequestBody List<GroomerForeignRegister> idList) {
		try {
			if (CollectionUtils.isNotEmpty(idList)) {
				idList.forEach(g -> {
					groomerForeignRegisterService.delete(g);
				});
			}
		} catch (Exception e) {
			return ResultDto.error(ZAErrorCode.ZA_ERROR, e.getMessage());
		}
		return ResultDto.success(Boolean.TRUE);
	}

}